/*
 * Decompiled with CFR 0.152.
 */
package dev.mattware.slimebuckets.mixin;

import dev.mattware.slimebuckets.SlimeBuckets;
import dev.mattware.slimebuckets.item.SlimeBucketsItems;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public class SlimeMixin {
    @Inject(method={"mobInteract(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    public void onInteract(Player player, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResult> cir) {
        Mob mob = (Mob)this;
        if (mob instanceof Slime) {
            Slime slime = (Slime)mob;
            ItemStack heldItem = player.getItemInHand(interactionHand);
            if (heldItem.getItem() == Items.BUCKET) {
                Level level = slime.level();
                if (slime.getClass() == Slime.class && !SlimeBuckets.SERVER_CONFIG.slimeBucketingEnabled) {
                    if (!level.isClientSide) {
                        player.displayClientMessage((Component)Component.translatable((String)"text.slimebuckets.slime_bucketing_disabled"), true);
                    }
                    return;
                }
                if (slime.getClass() == MagmaCube.class && !SlimeBuckets.SERVER_CONFIG.magmaCubeBucketingEnabled) {
                    if (!level.isClientSide) {
                        player.displayClientMessage((Component)Component.translatable((String)"text.slimebuckets.magma_cube_bucketing_disabled"), true);
                    }
                    return;
                }
                if (slime.getSize() <= SlimeBuckets.SERVER_CONFIG.maxBucketableSlimeSize) {
                    slime.playSound(SoundEvents.BUCKET_FILL_FISH, 1.0f, 1.0f);
                    ItemStack bucket = new ItemStack(slime instanceof MagmaCube ? (ItemLike)SlimeBucketsItems.MAGMA_CUBE_BUCKET.get() : (ItemLike)SlimeBucketsItems.SLIME_BUCKET.get());
                    if (!level.isClientSide) {
                        CompoundTag entityData = new CompoundTag();
                        slime.saveWithoutId(entityData);
                        entityData.remove("UUID");
                        bucket.set(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.of((CompoundTag)entityData));
                        CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, bucket);
                    }
                    ItemStack newHeldResult = ItemUtils.createFilledResult((ItemStack)heldItem, (Player)player, (ItemStack)bucket, (boolean)false);
                    player.setItemInHand(interactionHand, newHeldResult);
                    slime.discard();
                    cir.setReturnValue((Object)InteractionResult.sidedSuccess((boolean)level.isClientSide));
                } else if (!level.isClientSide) {
                    if (SlimeBuckets.SERVER_CONFIG.maxBucketableSlimeSize == 1) {
                        player.displayClientMessage((Component)Component.translatable((String)"text.slimebuckets.only_smallest_slimes"), true);
                    } else {
                        player.displayClientMessage((Component)Component.translatable((String)"text.slimebuckets.max_slime_size", (Object[])new Object[]{String.valueOf(SlimeBuckets.SERVER_CONFIG.maxBucketableSlimeSize)}), true);
                    }
                }
            }
        }
    }
}

