/*
 * Decompiled with CFR 0.152.
 */
package dev.mattware.slimebuckets.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public record SyncServerConfig(boolean slimeBucketingEnabled, boolean magmaCubeBucketingEnabled, boolean enableSlimeChunkDetection, boolean magmaCubeBucketHurts, int maxBucketableSlime) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, SyncServerConfig> PACKET_CODEC = StreamCodec.of(SyncServerConfig::staticWrite, SyncServerConfig::staticRead);
    public static final CustomPacketPayload.Type<SyncServerConfig> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"slimebuckets", (String)"sync_slimebuckets_config"));

    public void write(FriendlyByteBuf buf) {
        SyncServerConfig.staticWrite(buf, this);
    }

    public static void staticWrite(FriendlyByteBuf buf, SyncServerConfig ssc) {
        buf.writeBoolean(ssc.slimeBucketingEnabled);
        buf.writeBoolean(ssc.magmaCubeBucketingEnabled);
        buf.writeBoolean(ssc.enableSlimeChunkDetection);
        buf.writeBoolean(ssc.magmaCubeBucketHurts);
        buf.writeInt(ssc.maxBucketableSlime);
    }

    public static SyncServerConfig staticRead(FriendlyByteBuf buf) {
        return new SyncServerConfig(buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readInt());
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

