/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.common.palette;

import com.mojang.datafixers.util.Pair;
import earth.terrarium.chipped.common.palette.IdType;
import earth.terrarium.chipped.common.palette.Palette;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.UnaryOperator;

public class PaletteBuilder {
    private final List<Pair<IdType, String>> ids = new ArrayList<Pair<IdType, String>>();

    public PaletteBuilder() {
    }

    public static PaletteBuilder create() {
        return new PaletteBuilder();
    }

    public PaletteBuilder(Palette palette, String ... removals) {
        this.ids.addAll(palette.ids());
        HashSet<String> set = new HashSet<String>(List.of(removals));
        this.ids.removeIf(pair -> set.contains(pair.getSecond()));
    }

    public PaletteBuilder(Palette palette, UnaryOperator<IdType> swap, String ... removals) {
        HashSet<String> set = new HashSet<String>(List.of(removals));
        for (Pair<IdType, String> entry : palette.ids()) {
            if (set.contains(entry.getSecond())) continue;
            this.ids.add((Pair<IdType, String>)Pair.of((Object)((Object)((IdType)((Object)swap.apply((IdType)((Object)entry.getFirst()))))), (Object)((String)entry.getSecond())));
        }
    }

    public static PaletteBuilder create(Palette palette, String ... removals) {
        return new PaletteBuilder(palette, removals);
    }

    public static PaletteBuilder create(Palette palette, UnaryOperator<IdType> swap, String ... removals) {
        return new PaletteBuilder(palette, swap, removals);
    }

    public PaletteBuilder add(IdType type, String ... ids) {
        for (String id : ids) {
            this.ids.add((Pair<IdType, String>)Pair.of((Object)((Object)type), (Object)id));
        }
        return this;
    }

    public PaletteBuilder add(String ... ids) {
        this.add(IdType.NONE, ids);
        return this;
    }

    public PaletteBuilder directional(String ... ids) {
        this.add(IdType.DIRECTIONAL, ids);
        return this;
    }

    public PaletteBuilder limitedPillar(String ... ids) {
        this.add(IdType.LIMITED_PILLAR, ids);
        return this;
    }

    public PaletteBuilder pillar(String ... ids) {
        this.add(IdType.PILLAR, ids);
        return this;
    }

    public PaletteBuilder ctm(String ... ids) {
        this.add(IdType.CTM, ids);
        return this;
    }

    public PaletteBuilder giant(String ... ids) {
        this.add(IdType.GIANT, ids);
        return this;
    }

    public Palette build() {
        List<Pair<IdType, String>> ids = List.copyOf(this.ids);
        return () -> ids;
    }
}

