/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.api.node.parent;

import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.node.parent.ParentNode;
import eu.pb4.placeholders.api.node.parent.ParentTextNode;
import eu.pb4.placeholders.impl.GeneralUtils;
import eu.pb4.placeholders.impl.color.HSV;
import eu.pb4.placeholders.impl.color.OkLab;
import eu.pb4.placeholders.impl.color.OkLch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5251;

public final class GradientNode
extends ParentNode {
    private final GradientProvider gradientProvider;

    public GradientNode(TextNode[] children, GradientProvider gradientBuilder) {
        super(children);
        this.gradientProvider = gradientBuilder;
    }

    public static class_2561 apply(class_2561 text, GradientProvider gradientProvider) {
        return GeneralUtils.toGradient(text, gradientProvider);
    }

    public static GradientNode rainbow(float saturation, float value, float frequency, float offset, int gradientLength, TextNode ... nodes) {
        return new GradientNode(nodes, GradientProvider.rainbow(saturation, value, frequency, offset, gradientLength));
    }

    public static GradientNode rainbow(float saturation, float value, float frequency, float offset, TextNode ... nodes) {
        return new GradientNode(nodes, GradientProvider.rainbow(saturation, value, frequency, offset));
    }

    public static GradientNode rainbow(float saturation, float value, float frequency, TextNode ... nodes) {
        return GradientNode.rainbow(saturation, value, frequency, 0.0f, nodes);
    }

    public static GradientNode rainbow(float saturation, float value, TextNode ... nodes) {
        return GradientNode.rainbow(saturation, value, 1.0f, 0.0f, nodes);
    }

    public static GradientNode rainbow(float saturation, TextNode ... nodes) {
        return GradientNode.rainbow(saturation, 1.0f, 1.0f, 0.0f, nodes);
    }

    public static GradientNode rainbow(TextNode ... nodes) {
        return GradientNode.rainbow(1.0f, 1.0f, 1.0f, 0.0f, nodes);
    }

    public static GradientNode colors(class_5251 from, class_5251 to, TextNode ... nodes) {
        return GradientNode.colors(List.of(from, to), nodes);
    }

    public static GradientNode colors(List<class_5251> colors, TextNode ... nodes) {
        return new GradientNode(nodes, GradientProvider.colors(colors));
    }

    public static GradientNode colorsHard(class_5251 from, class_5251 to, TextNode ... nodes) {
        return GradientNode.colorsHard(List.of(from, to), nodes);
    }

    public static GradientNode colorsHard(List<class_5251> colors, TextNode ... nodes) {
        return new GradientNode(nodes, GradientProvider.colorsHard(colors));
    }

    @Override
    protected class_2561 applyFormatting(class_5250 out, ParserContext context) {
        return GeneralUtils.toGradient((class_2561)out, this.gradientProvider);
    }

    @Override
    public ParentTextNode copyWith(TextNode[] children) {
        return new GradientNode(children, this.gradientProvider);
    }

    @Override
    public String toString() {
        return "GradientNode{gradientProvider=" + String.valueOf(this.gradientProvider) + ", children=" + Arrays.toString(this.children) + "}";
    }

    @FunctionalInterface
    public static interface GradientProvider {
        public class_5251 getColorAt(int var1, int var2);

        public static GradientProvider colors(List<class_5251> colors) {
            return GradientProvider.colorsOkLab(colors);
        }

        public static GradientProvider colorsOkLab(List<class_5251> colors) {
            ArrayList<OkLab> hvs = new ArrayList<OkLab>(colors.size());
            for (class_5251 color : colors) {
                hvs.add(OkLab.fromRgb(color.method_27716()));
            }
            if (hvs.isEmpty()) {
                hvs.add(new OkLab(1.0f, 1.0f, 1.0f));
            } else if (hvs.size() == 1) {
                hvs.add((OkLab)hvs.get(0));
            }
            int colorSize = hvs.size();
            return (pos, length) -> {
                float sectionSize = (float)length / (float)(colorSize - 1);
                float progress = (float)pos % sectionSize / sectionSize;
                OkLab colorA = (OkLab)hvs.get(Math.min((int)((float)pos / sectionSize), colorSize - 1));
                OkLab colorB = (OkLab)hvs.get(Math.min((int)((float)pos / sectionSize) + 1, colorSize - 1));
                float l = class_3532.method_16439((float)progress, (float)colorA.l(), (float)colorB.l());
                float a = class_3532.method_16439((float)progress, (float)colorA.a(), (float)colorB.a());
                float b = class_3532.method_16439((float)progress, (float)colorA.b(), (float)colorB.b());
                return class_5251.method_27717((int)OkLab.toRgb(l, a, b));
            };
        }

        public static GradientProvider colorsHvs(List<class_5251> colors) {
            ArrayList<HSV> hvs = new ArrayList<HSV>(colors.size());
            for (class_5251 color : colors) {
                hvs.add(HSV.fromRgb(color.method_27716()));
            }
            if (hvs.isEmpty()) {
                hvs.add(new HSV(1.0f, 1.0f, 1.0f));
            } else if (hvs.size() == 1) {
                hvs.add((HSV)hvs.get(0));
            }
            int colorSize = hvs.size();
            return (pos, length) -> {
                float h;
                double step = ((double)colorSize - 1.0) / (double)length;
                float sectionSize = (float)length / (float)(colorSize - 1);
                float progress = (float)pos % sectionSize / sectionSize;
                HSV colorA = (HSV)hvs.get(Math.min((int)((float)pos / sectionSize), colorSize - 1));
                HSV colorB = (HSV)hvs.get(Math.min((int)((float)pos / sectionSize) + 1, colorSize - 1));
                float delta = h + (float)((double)Math.abs(h = colorB.h() - colorA.h()) > 0.50001 ? (h < 0.0f ? 1 : -1) : 0);
                float futureHue = (float)((double)colorA.h() + (double)delta * step * (double)((float)pos % sectionSize));
                if (futureHue < 0.0f) {
                    futureHue += 1.0f;
                } else if (futureHue > 1.0f) {
                    futureHue -= 1.0f;
                }
                float hue = futureHue;
                float sat = class_3532.method_15363((float)(colorB.s() * progress + colorA.s() * (1.0f - progress)), (float)0.0f, (float)1.0f);
                float value = class_3532.method_15363((float)(colorB.v() * progress + colorA.v() * (1.0f - progress)), (float)0.0f, (float)1.0f);
                return class_5251.method_27717((int)HSV.toRgb(class_3532.method_15363((float)hue, (float)0.0f, (float)1.0f), sat, value));
            };
        }

        public static GradientProvider colorsHard(List<class_5251> colors) {
            int colorSize = colors.size();
            return (pos, length) -> {
                if (length == 0) {
                    return (class_5251)colors.get(0);
                }
                float sectionSize = (float)length / (float)colorSize;
                return (class_5251)colors.get(Math.min((int)((float)pos / sectionSize), colorSize - 1));
            };
        }

        public static GradientProvider rainbow(float saturation, float value, float frequency, float offset, int gradientLength) {
            return GradientProvider.rainbowHvs(saturation, value, frequency, offset, gradientLength);
        }

        public static GradientProvider rainbowHvs(float saturation, float value, float frequency, float offset, int gradientLength) {
            float finalFreqLength = frequency < 0.0f ? -frequency : 0.0f;
            return (pos, length) -> class_5251.method_27717((int)HSV.toRgb((((float)pos * frequency + finalFreqLength * (float)length) / (float)(gradientLength + 1) + offset) % 1.0f, saturation, value));
        }

        public static GradientProvider rainbowOkLch(float saturation, float value, float frequency, float offset, int gradientLength) {
            float finalFreqLength = frequency < 0.0f ? -frequency : 0.0f;
            return (pos, length) -> class_5251.method_27717((int)OkLch.toRgb(value, saturation / 2.0f, (((float)pos * frequency * ((float)Math.PI * 2) + finalFreqLength * (float)length) / (float)(gradientLength + 1) + offset) % 1.0f));
        }

        public static GradientProvider rainbow(float saturation, float value, float frequency, float offset) {
            return GradientProvider.rainbowHvs(saturation, value, frequency, offset);
        }

        public static GradientProvider rainbowHvs(float saturation, float value, float frequency, float offset) {
            float finalFreqLength = frequency < 0.0f ? -frequency : 0.0f;
            return (pos, length) -> class_5251.method_27717((int)HSV.toRgb(((float)pos * frequency + finalFreqLength * (float)length) / (float)(length + 1) + offset, saturation, value));
        }

        public static GradientProvider rainbowOkLch(float saturation, float value, float frequency, float offset) {
            float finalFreqLength = frequency < 0.0f ? -frequency : 0.0f;
            return (pos, length) -> class_5251.method_27717((int)OkLch.toRgb(value, saturation / 2.0f, ((float)pos * frequency * ((float)Math.PI * 2) + finalFreqLength * (float)length) / (float)length + offset));
        }
    }
}

