/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.VoiceChatScreen;
import de.maxhenkel.voicechat.gui.VoiceChatSettingsScreen;
import de.maxhenkel.voicechat.gui.group.GroupScreen;
import de.maxhenkel.voicechat.gui.group.JoinGroupScreen;
import de.maxhenkel.voicechat.gui.onboarding.OnboardingManager;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumesScreen;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_746;

public class KeyEvents {
    private final class_310 minecraft = class_310.method_1551();
    public static class_304 KEY_PTT;
    public static class_304 KEY_WHISPER;
    public static class_304 KEY_MUTE;
    public static class_304 KEY_DISABLE;
    public static class_304 KEY_HIDE_ICONS;
    public static class_304 KEY_VOICE_CHAT;
    public static class_304 KEY_VOICE_CHAT_SETTINGS;
    public static class_304 KEY_GROUP;
    public static class_304 KEY_TOGGLE_RECORDING;
    public static class_304 KEY_ADJUST_VOLUMES;
    public static class_304[] ALL_KEYS;

    public KeyEvents() {
        ClientCompatibilityManager.INSTANCE.onHandleKeyBinds(this::handleKeybinds);
    }

    public static void registerKeyBinds() {
        if (KEY_PTT != null) {
            throw new IllegalStateException("Registered key binds twice");
        }
        KEY_PTT = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new class_304("key.push_to_talk", class_3675.field_16237.method_1444(), "key.categories.voicechat"));
        KEY_WHISPER = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new class_304("key.whisper", class_3675.field_16237.method_1444(), "key.categories.voicechat"));
        KEY_MUTE = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new class_304("key.mute_microphone", 77, "key.categories.voicechat"));
        KEY_DISABLE = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new class_304("key.disable_voice_chat", 78, "key.categories.voicechat"));
        KEY_HIDE_ICONS = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new class_304("key.hide_icons", 72, "key.categories.voicechat"));
        KEY_VOICE_CHAT = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new class_304("key.voice_chat", 86, "key.categories.voicechat"));
        KEY_VOICE_CHAT_SETTINGS = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new class_304("key.voice_chat_settings", class_3675.field_16237.method_1444(), "key.categories.voicechat"));
        KEY_GROUP = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new class_304("key.voice_chat_group", 71, "key.categories.voicechat"));
        KEY_TOGGLE_RECORDING = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new class_304("key.voice_chat_toggle_recording", class_3675.field_16237.method_1444(), "key.categories.voicechat"));
        KEY_ADJUST_VOLUMES = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new class_304("key.voice_chat_adjust_volumes", class_3675.field_16237.method_1444(), "key.categories.voicechat"));
        ALL_KEYS = new class_304[]{KEY_PTT, KEY_WHISPER, KEY_MUTE, KEY_DISABLE, KEY_HIDE_ICONS, KEY_VOICE_CHAT, KEY_VOICE_CHAT_SETTINGS, KEY_GROUP, KEY_TOGGLE_RECORDING, KEY_ADJUST_VOLUMES};
    }

    private void handleKeybinds() {
        class_746 player = this.minecraft.field_1724;
        if (player == null) {
            return;
        }
        if (OnboardingManager.isOnboarding()) {
            for (class_304 allKey : ALL_KEYS) {
                if (!allKey.method_1436()) continue;
                OnboardingManager.startOnboarding(null);
                return;
            }
            return;
        }
        ClientVoicechat client = ClientManager.getClient();
        ClientPlayerStateManager playerStateManager = ClientManager.getPlayerStateManager();
        if (KEY_VOICE_CHAT.method_1436()) {
            if (class_437.method_25443()) {
                if (class_437.method_25441()) {
                    VoicechatClient.CLIENT_CONFIG.onboardingFinished.set(false).save();
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.voicechat.onboarding.reset"), true);
                } else {
                    ClientManager.getDebugOverlay().toggle();
                }
            } else {
                this.minecraft.method_1507((class_437)new VoiceChatScreen());
            }
        }
        if (KEY_GROUP.method_1436()) {
            if (client != null && client.getConnection() != null && client.getConnection().getData().groupsEnabled()) {
                ClientGroup group = playerStateManager.getGroup();
                if (group != null) {
                    this.minecraft.method_1507((class_437)new GroupScreen(group));
                } else {
                    this.minecraft.method_1507((class_437)new JoinGroupScreen());
                }
            } else {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.voicechat.groups_disabled"), true);
            }
        }
        if (KEY_VOICE_CHAT_SETTINGS.method_1436()) {
            this.minecraft.method_1507((class_437)new VoiceChatSettingsScreen());
        }
        if (KEY_ADJUST_VOLUMES.method_1436()) {
            this.minecraft.method_1507((class_437)new AdjustVolumesScreen());
        }
        if (KEY_PTT.method_1436()) {
            this.checkConnected();
        }
        if (KEY_WHISPER.method_1436()) {
            this.checkConnected();
        }
        if (KEY_MUTE.method_1436()) {
            playerStateManager.setMuted(!playerStateManager.isMuted());
        }
        if (KEY_DISABLE.method_1436()) {
            playerStateManager.setDisabled(!playerStateManager.isDisabled());
        }
        if (KEY_TOGGLE_RECORDING.method_1436() && client != null) {
            ClientManager.getClient().toggleRecording();
        }
        if (KEY_HIDE_ICONS.method_1436()) {
            boolean hidden = VoicechatClient.CLIENT_CONFIG.hideIcons.get() == false;
            VoicechatClient.CLIENT_CONFIG.hideIcons.set(hidden).save();
            if (hidden) {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.voicechat.icons_hidden"), true);
            } else {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.voicechat.icons_visible"), true);
            }
        }
    }

    private boolean checkConnected() {
        if (ClientManager.getClient() == null || ClientManager.getClient().getConnection() == null || !ClientManager.getClient().getConnection().isInitialized()) {
            this.sendNotConnectedMessage();
            return false;
        }
        return true;
    }

    private void sendNotConnectedMessage() {
        class_746 player = this.minecraft.field_1724;
        if (player == null) {
            Voicechat.LOGGER.warn("Voice chat not connected", new Object[0]);
            return;
        }
        player.method_7353((class_2561)class_2561.method_43471((String)"message.voicechat.voice_chat_not_connected"), true);
    }
}

