/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.entities;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import earth.terrarium.handcrafted.common.blocks.base.SittableBlock;
import earth.terrarium.handcrafted.common.registry.ModEntityTypes;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2945;
import net.minecraft.class_3231;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_5275;
import net.minecraft.class_5321;
import net.minecraft.class_5569;
import net.minecraft.class_6328;

@class_6328
public class Seat
extends class_1297 {
    public static final Multimap<class_5321<class_1937>, class_2338> SITTING_POSITIONS = ArrayListMultimap.create();
    private class_238 shape;
    private boolean remove;
    private boolean canRotate;

    public Seat(class_1299<? extends class_1297> entityType, class_1937 level) {
        super(entityType, level);
        this.method_31744(class_5569.field_27243);
    }

    public Seat(class_1937 level, class_238 shape) {
        super((class_1299)ModEntityTypes.SEAT.get(), level);
        this.shape = Seat.copyAABB(shape);
    }

    public static Seat of(class_1937 level, class_2338 pos, class_2350 dir) {
        class_2680 state = level.method_8320(pos);
        class_238 shape = new class_238(pos);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof SittableBlock) {
            SittableBlock seat = (SittableBlock)class_22482;
            shape = seat.getSeatSize(state);
        }
        Seat entity = new Seat(level, shape);
        if (dir != null) {
            entity.method_36456(dir.method_10144());
        } else {
            entity.canRotate = true;
        }
        entity.method_5814((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
        return entity;
    }

    private static class_238 copyAABB(class_238 aabb) {
        return new class_238(aabb.field_1323, aabb.field_1322, aabb.field_1321, aabb.field_1320, aabb.field_1325, aabb.field_1324);
    }

    public class_2596<class_2602> method_18002(class_3231 serverEntity) {
        return new class_2604((class_1297)this, serverEntity, this.canRotate ? 1 : 0);
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        this.canRotate = packet.method_11166() == 1;
    }

    public boolean method_5655() {
        return true;
    }

    public boolean method_5782() {
        return true;
    }

    public boolean method_5727(double x, double y, double z) {
        return false;
    }

    public class_243 method_24829(class_1309 passenger) {
        class_2350 facing = this.method_5735();
        for (class_2350 offset : new class_2350[]{facing, facing.method_10170(), facing.method_10160(), facing.method_10153()}) {
            class_243 safeLocation = class_5275.method_30769((class_1299)passenger.method_5864(), (class_1941)this.method_37908(), (class_2338)this.method_24515().method_10093(offset), (boolean)false);
            if (safeLocation == null) continue;
            return safeLocation.method_1031(0.0, 0.25, 0.0);
        }
        return super.method_24829(passenger);
    }

    public void method_5773() {
        super.method_5773();
        if (!(this.method_37908().method_8608() || this.method_37908().method_8320(this.method_24515()).method_26204() instanceof SittableBlock && !this.remove)) {
            this.removeSeat();
        }
    }

    protected void method_5793(class_1297 passenger) {
        super.method_5793(passenger);
        if (!this.method_37908().method_8608() && this.method_5685().isEmpty()) {
            this.remove = true;
        }
    }

    public void removeSeat() {
        SITTING_POSITIONS.get((Object)this.method_37908().method_27983()).remove(this.method_24515());
        this.method_31472();
    }

    protected class_238 method_33332() {
        if (this.shape == null) {
            return super.method_33332();
        }
        return this.shape.method_996(this.method_24515());
    }

    protected class_243 method_52533(class_1297 entity, class_4048 dimensions, float partialTick) {
        if (this.shape == null) {
            return super.method_52533(entity, dimensions, partialTick);
        }
        return new class_243(0.0, (double)((float)(this.shape.method_17940() * 0.75) + 0.2f), 0.0);
    }

    protected void clampRotation(class_1297 entityToUpdate) {
        entityToUpdate.method_5636(this.method_36454());
        float f = class_3532.method_15393((float)(entityToUpdate.method_36454() - this.method_36454()));
        float g = class_3532.method_15363((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.field_5982 += g - f;
        entityToUpdate.method_36456(entityToUpdate.method_36454() + g - f);
        entityToUpdate.method_5847(entityToUpdate.method_36454());
    }

    public void method_5644(class_1297 entityToUpdate) {
        if (!this.canRotate) {
            this.clampRotation(entityToUpdate);
        }
    }

    public void method_31744(class_5569 levelCallback) {
        super.method_31744((class_5569)new WrappedLevelCallBack(levelCallback));
    }

    protected void method_5693(class_2945.class_9222 builder) {
    }

    protected void method_5749(class_2487 compound) {
    }

    protected void method_5652(class_2487 compound) {
    }

    private class WrappedLevelCallBack
    implements class_5569 {
        private final class_5569 callback;

        public WrappedLevelCallBack(class_5569 callback) {
            this.callback = callback;
        }

        public void method_31749() {
            if (this.callback != null) {
                this.callback.method_31749();
                class_2248 class_22482 = Seat.this.method_37908().method_8320(Seat.this.method_24515()).method_26204();
                if (class_22482 instanceof SittableBlock) {
                    SittableBlock seat = (SittableBlock)class_22482;
                    Seat.this.shape = seat.getSeatSize(Seat.this.method_37908().method_8320(Seat.this.method_24515()));
                }
            } else {
                Seat.this.shape = null;
            }
        }

        public void method_31750(class_1297.class_5529 reason) {
            if (this.callback != null) {
                this.callback.method_31750(reason);
            }
        }
    }
}

