/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.plant;

import java.util.List;
import jeresources.api.drop.PlantDrop;
import jeresources.entry.PlantEntry;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class PlantTooltip
implements IRecipeSlotTooltipCallback {
    private final PlantEntry entry;

    public PlantTooltip(PlantEntry entry) {
        this.entry = entry;
    }

    public void onTooltip(IRecipeSlotView recipeSlotView, @NotNull List<class_2561> tooltip) {
        if (recipeSlotView.getRole() != RecipeIngredientRole.INPUT) {
            tooltip.add(this.getChanceString((class_1799)((ITypedIngredient)recipeSlotView.getDisplayedIngredient().get()).getIngredient()));
        }
    }

    public float getChance(class_1799 itemStack) {
        PlantDrop drop = this.entry.getDrop(itemStack);
        return switch (drop.getDropKind()) {
            case PlantDrop.DropKind.chance -> drop.getChance();
            case PlantDrop.DropKind.weight -> (float)drop.getWeight() / (float)this.entry.getTotalWeight();
            case PlantDrop.DropKind.minMax -> Float.NaN;
            default -> 0.0f;
        };
    }

    public int[] getMinMax(class_1799 itemStack) {
        PlantDrop drop = this.entry.getDrop(itemStack);
        return new int[]{drop.getMinDrop(), drop.getMaxDrop()};
    }

    private class_2561 getChanceString(class_1799 itemStack) {
        String toPrint;
        float chance = this.getChance(itemStack);
        if (Float.isNaN(chance)) {
            int[] minMax = this.getMinMax(itemStack);
            toPrint = minMax[0] + (String)(minMax[0] == minMax[1] ? "" : " - " + minMax[1]);
        } else {
            toPrint = String.format("%2.2f", Float.valueOf(chance * 100.0f)).replace(",", ".") + "%";
        }
        return class_2561.method_43470((String)toPrint);
    }
}

