/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.rendering.BatchRenderElement;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.config.IJeiClientConfigs;
import mezz.jei.common.platform.IPlatformInputHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.class_124;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SafeIngredientUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<IIngredientRenderer<?>> CRASHING_INGREDIENT_BATCH_RENDERERS = new HashSet();
    private static final Set<Object> CRASHING_INGREDIENT_RENDERERS = new HashSet<Object>();
    private static final Set<Object> CRASHING_INGREDIENT_TOOLTIPS = new HashSet<Object>();

    private SafeIngredientUtil() {
    }

    public static <T> void getTooltip(ITooltipBuilder tooltip, IIngredientManager ingredientManager, IIngredientRenderer<T> ingredientRenderer, ITypedIngredient<T> typedIngredient) {
        class_310 minecraft = class_310.method_1551();
        class_1836.class_1837 tooltipFlag = minecraft.field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070;
        tooltipFlag = tooltipFlag.method_47371();
        SafeIngredientUtil.getTooltip(tooltip, ingredientManager, ingredientRenderer, typedIngredient, (class_1836)tooltipFlag);
    }

    public static <T> void getTooltip(ITooltipBuilder tooltip, IIngredientManager ingredientManager, IIngredientRenderer<T> ingredientRenderer, ITypedIngredient<T> typedIngredient, class_1836 tooltipFlag) {
        T ingredient = typedIngredient.getIngredient();
        if (CRASHING_INGREDIENT_TOOLTIPS.contains(ingredient)) {
            SafeIngredientUtil.getTooltipErrorTooltip(tooltip);
            return;
        }
        IPlatformInputHelper inputHelper = Services.PLATFORM.getInputHelper();
        tooltipFlag = inputHelper.getClientTooltipFlag(tooltipFlag);
        tooltip.setIngredient(typedIngredient);
        try {
            ingredientRenderer.getTooltip(tooltip, ingredient, tooltipFlag);
            if (CRASHING_INGREDIENT_RENDERERS.contains(ingredient)) {
                SafeIngredientUtil.getRenderErrorTooltip(tooltip);
            }
        }
        catch (LinkageError | RuntimeException e) {
            CRASHING_INGREDIENT_TOOLTIPS.add(ingredient);
            ErrorUtil.logIngredientCrash(e, "Caught an error getting an Ingredient's tooltip", ingredientManager, typedIngredient.getType(), ingredient);
            SafeIngredientUtil.getTooltipErrorTooltip(tooltip);
        }
    }

    private static void getTooltipErrorTooltip(ITooltipBuilder tooltip) {
        class_5250 crash = class_2561.method_43471((String)"jei.tooltip.error.crash");
        tooltip.add((class_5348)crash.method_27692(class_124.field_1061));
    }

    private static void getRenderErrorTooltip(ITooltipBuilder tooltip) {
        class_5250 crash = class_2561.method_43471((String)"jei.tooltip.error.render.crash");
        tooltip.add((class_5348)crash.method_27692(class_124.field_1061));
    }

    public static <T> void renderBatch(class_332 guiGraphics, IIngredientType<T> ingredientType, IIngredientRenderer<T> ingredientRenderer, List<BatchRenderElement<T>> elements) {
        if (CRASHING_INGREDIENT_BATCH_RENDERERS.contains(ingredientRenderer)) {
            for (BatchRenderElement<T> element : elements) {
                SafeIngredientUtil.render(guiGraphics, ingredientRenderer, ingredientType, element);
            }
            return;
        }
        try {
            ingredientRenderer.renderBatch(guiGraphics, elements);
        }
        catch (LinkageError | RuntimeException e) {
            CRASHING_INGREDIENT_BATCH_RENDERERS.add(ingredientRenderer);
            LOGGER.error("Caught an error while rendering a batch of Ingredients with ingredient renderer: {}", ingredientRenderer.getClass(), (Object)e);
        }
    }

    public static <T> void render(class_332 guiGraphics, IIngredientRenderer<T> ingredientRenderer, ITypedIngredient<T> typedIngredient, int x, int y) {
        SafeIngredientUtil.render(guiGraphics, ingredientRenderer, typedIngredient.getType(), typedIngredient.getIngredient(), x, y);
    }

    public static <T> void render(class_332 guiGraphics, IIngredientRenderer<T> ingredientRenderer, IIngredientType<T> ingredientType, BatchRenderElement<T> element) {
        SafeIngredientUtil.render(guiGraphics, ingredientRenderer, ingredientType, element.ingredient(), element.x(), element.y());
    }

    public static <T> void render(class_332 guiGraphics, IIngredientRenderer<T> ingredientRenderer, IIngredientType<T> ingredientType, T ingredient, int x, int y) {
        if (CRASHING_INGREDIENT_RENDERERS.contains(ingredient)) {
            SafeIngredientUtil.renderError(guiGraphics);
            return;
        }
        try {
            ingredientRenderer.render(guiGraphics, ingredient, x, y);
        }
        catch (LinkageError | RuntimeException e) {
            CRASHING_INGREDIENT_RENDERERS.add(ingredient);
            IIngredientManager ingredientManager = Internal.getJeiRuntime().getIngredientManager();
            if (SafeIngredientUtil.shouldCatchRenderErrors()) {
                ErrorUtil.logIngredientCrash(e, "Caught an error rendering an Ingredient", ingredientManager, ingredientType, ingredient);
                SafeIngredientUtil.renderError(guiGraphics);
            }
            class_128 crashReport = ErrorUtil.createIngredientCrashReport(e, "Rendering ingredient", ingredientManager, ingredientType, ingredient);
            throw new class_148(crashReport);
        }
    }

    private static boolean shouldCatchRenderErrors() {
        return Internal.getOptionalJeiClientConfigs().map(IJeiClientConfigs::getClientConfig).map(IClientConfig::isCatchRenderErrorsEnabled).orElse(false);
    }

    private static void renderError(class_332 guiGraphics) {
        class_310 minecraft = class_310.method_1551();
        class_327 font = minecraft.field_1772;
        guiGraphics.method_51433(font, "ERR", 0, 0, -65536, false);
        guiGraphics.method_51433(font, "OR", 0, 8, -65536, false);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

