/*
 * Decompiled with CFR 0.152.
 */
package commonnetwork.networking;

import commonnetwork.Constants;
import commonnetwork.networking.PacketRegistrationHandler;
import commonnetwork.networking.data.CommonPacketWrapper;
import commonnetwork.networking.data.PacketContainer;
import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import commonnetwork.networking.exceptions.RegistrationException;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2535;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class FabricNetworkHandler
extends PacketRegistrationHandler {
    public FabricNetworkHandler(Side side) {
        super(side);
    }

    @Override
    protected <T> void registerPacket(PacketContainer<T> container) {
        try {
            if (container.packetType() == PacketContainer.PacketType.PLAY) {
                PayloadTypeRegistry.playC2S().register(container.getType(), container.getCodec());
                PayloadTypeRegistry.playS2C().register(container.getType(), container.getCodec());
            } else {
                PayloadTypeRegistry.configurationC2S().register(container.getType(), container.getCodec());
                PayloadTypeRegistry.configurationS2C().register(container.getType(), container.getCodec());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (Side.CLIENT.equals((Object)this.side)) {
            Constants.LOG.debug("Registering packet {} : {} on the: {}", new Object[]{container.type().comp_2242(), container.classType(), Side.CLIENT});
            if (container.packetType() == PacketContainer.PacketType.PLAY) {
                ClientPlayNetworking.registerGlobalReceiver(container.getType(), (payload, context) -> context.client().execute(() -> container.handler().accept(new PacketContext(payload.packet(), Side.CLIENT))));
            } else {
                ClientConfigurationNetworking.registerGlobalReceiver(container.getType(), (payload, context) -> context.client().execute(() -> container.handler().accept(new PacketContext(payload.packet(), Side.CLIENT))));
            }
        }
        Constants.LOG.debug("Registering packet {} : {} on the: {}", new Object[]{container.type().comp_2242(), container.classType(), Side.SERVER});
        if (container.packetType() == PacketContainer.PacketType.PLAY) {
            ServerPlayNetworking.registerGlobalReceiver(container.getType(), (payload, context) -> context.player().field_13995.execute(() -> container.handler().accept(new PacketContext(context.player(), payload.packet(), Side.SERVER))));
        } else {
            ServerConfigurationNetworking.registerGlobalReceiver(container.getType(), (payload, context) -> context.server().execute(() -> container.handler().accept(new PacketContext(null, payload.packet(), Side.SERVER))));
        }
    }

    @Override
    public <T> void send(T packet, class_2535 connection) {
        PacketContainer container = (PacketContainer)this.PACKET_MAP.get(packet.getClass());
        if (container != null) {
            if (this.side == Side.SERVER) {
                connection.method_10743((class_2596)new class_2658(new CommonPacketWrapper<T>(container, packet)));
            } else {
                connection.method_10743((class_2596)new class_2817(new CommonPacketWrapper<T>(container, packet)));
            }
        }
    }

    @Override
    @Nullable
    public <T> class_2658 getRawClientboundPacket(T packet) {
        PacketContainer container = (PacketContainer)this.PACKET_MAP.get(packet.getClass());
        if (container != null) {
            return new class_2658(new CommonPacketWrapper<T>(container, packet));
        }
        return null;
    }

    @Override
    @Nullable
    public <T> class_2817 getRawServerboundPacket(T packet) {
        PacketContainer container = (PacketContainer)this.PACKET_MAP.get(packet.getClass());
        if (container != null) {
            return new class_2817(new CommonPacketWrapper<T>(container, packet));
        }
        return null;
    }

    @Override
    public <T> void sendToServer(T packet, boolean ignoreCheck) {
        PacketContainer container = (PacketContainer)this.PACKET_MAP.get(packet.getClass());
        if (container != null) {
            if (ignoreCheck || ClientPlayNetworking.canSend((class_2960)container.type().comp_2242())) {
                ClientPlayNetworking.send(new CommonPacketWrapper<T>(container, packet));
            }
        } else {
            throw new RegistrationException(String.valueOf(packet.getClass()) + "{} packet not registered on the client, packets need to be registered on both sides!");
        }
    }

    @Override
    public <T> void sendToClient(T packet, class_3222 player, boolean ignoreCheck) {
        PacketContainer container = (PacketContainer)this.PACKET_MAP.get(packet.getClass());
        if (container != null) {
            if (ignoreCheck || ServerPlayNetworking.canSend((class_3222)player, (class_2960)container.type().comp_2242())) {
                ServerPlayNetworking.send((class_3222)player, new CommonPacketWrapper<T>(container, packet));
            }
        } else {
            throw new RegistrationException(String.valueOf(packet.getClass()) + "{} packet not registered on the server, packets need to be registered on both sides!");
        }
    }
}

