/*
 * Decompiled with CFR 0.152.
 */
package net.tschipcraft.moremobs.forge;

import com.mojang.logging.LogUtils;
import eu.midnightdust.lib.config.MidnightConfig;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.tschipcraft.moremobs.forge.Config;
import net.tschipcraft.moremobs.forge.sendConfig;
import org.slf4j.Logger;

public class Init {
    public static final String MODID = "moremobs";
    private static Logger LOGGER;

    public static void registerEvent() {
        block3: {
            try {
                if (LOGGER != null) {
                    LOGGER.info("[More Mobs] Registering server started event ...");
                }
                Class.forName("net.minecraftforge.event.server.ServerStartedEvent");
                MinecraftForge.EVENT_BUS.register(new Object(){

                    @SubscribeEvent
                    public void onServerStarted(ServerStartedEvent event) {
                        if (ModList.get().isLoaded("midnightlib")) {
                            LOGGER.info("[More Mobs] Sending global config to world ...");
                            sendConfig.sendConfig(event.getServer());
                        }
                    }
                });
            }
            catch (ClassNotFoundException e) {
                if (LOGGER == null) break block3;
                LOGGER.info("[More Mobs] ServerStartedEvent not found, not registering event handler.");
            }
        }
    }

    public static void finishSetup() {
        if (ModList.get().isLoaded("midnightlib")) {
            LOGGER.info("[More Mobs] MidnightLib detected!");
            Config.init((String)MODID, Config.class);
            ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((client, parent) -> MidnightConfig.getScreen((Screen)parent, (String)MODID)));
        }
    }

    static {
        try {
            LOGGER = LogUtils.getLogger();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

