<h1 align="center">
  <img alt="Icon" src="pack.png" width="80" height="80" style="image-rendering: pixelated"><br/>
  Tschipcraft's More Mobs
</h1>
<p align="center">
  <a href="https://github.com/Tschipcraft/more_mobs/stargazers"><img alt="GitHub Stars" src="https://img.shields.io/github/stars/Tschipcraft/more_mobs?colorA=1b1b29&colorB=bd5216&style=for-the-badge"></a>
  <a href="https://www.curseforge.com/minecraft/mc-mods/mod-more-mobs"><img alt="CurseForge Downloads" src="https://img.shields.io/curseforge/dt/909654?logo=curseforge&label=CurseForge&colorA=1b1b29&colorB=bd5216&style=for-the-badge"></a>
  <a href="https://modrinth.com/datapack/more-mobs"><img alt="Modrinth Downloads" src="https://img.shields.io/modrinth/dt/more-mobs?label=Modrinth&colorA=1b1b29&colorB=bd5216&style=for-the-badge&logo=modrinth"></a>
  <a href="https://github.com/Tschipcraft/more_mobs/releases/latest"><img alt="GitHub Downloads" src="https://img.shields.io/github/downloads/Tschipcraft/more_mobs/total?logo=github&colorA=1b1b29&colorB=bd5216&style=for-the-badge"></a>
</p>

> A data pack/mod for Minecraft 1.14x-1.21x

<details>
<summary>YouTube showcase</summary>
<a href="http://www.youtube.com/watch?v=sruFdJCgIDo">
<img alt="More Mobs Thumbnail" width=50% src="https://tschipcraft.ddns.net/mod_resources/youtube_preview.php?id=sruFdJCgIDo" title="Watch on YouTube">
</a>
</details>

## Features

Mobs have new variants through custom heads or unused vanilla mobs! This pack uses **over 85 custom player heads** which can be obtained and placed in your world. Spiders also turn upside down when hanging from ceilings.

**Supported Entities:**
Zombies, Husks, Drowned, Skeletons, Strays, Wither Skeletons, Mooshrooms, Piglins, Pillagers, Evokers and Vindicators

Since this project is completely server-side, players joining a server with More Mobs installed will not need to install anything on their end for it to work! No resource pack needed!  
However, you can still use the mod version on the client for single-player worlds only. Joining a server that does not have More Mobs installed will have no effect.

[➜ For all added heads, available settings and customization, take a look at the wiki](https://github.com/Tschipcraft/more_mobs/wiki)

## Installation

[Download the latest release](https://github.com/Tschipcraft/more_mobs/releases/latest) and install either as:

* **Data Pack** ➜ Place `.zip` in your world's `datapacks` folder
* **Mod** ➜ Drop into your `mods` folder and optionally install [MidnightLib](https://modrinth.com/project/codAaoxh) for a global config file and UI

To manage settings, reset, or uninstall the pack, use `/trigger tschipcraft.menu` or `/function #tschipcraft:menu`.

Also available on Modrinth and CurseForge!

<a href="https://modrinth.com/datapack/more-mobs">
<picture>
  <source height="72px" media="(prefers-color-scheme: dark)" srcset="https://raw.githubusercontent.com/Tschipcraft/badges/main/assets/modrinth-badge-dark.svg">
  <source height="72px" media="(prefers-color-scheme: light)" srcset="https://raw.githubusercontent.com/Tschipcraft/badges/main/assets/modrinth-badge-light.svg">
  <img height="72px" alt="Download on Modrinth" src="https://raw.githubusercontent.com/Tschipcraft/badges/main/assets/modrinth-badge-dark.svg">
</picture>
</a>
<a href="https://www.curseforge.com/minecraft/data-packs/more-mobs">
<picture>
  <source height="72px" media="(prefers-color-scheme: dark)" srcset="https://raw.githubusercontent.com/Tschipcraft/badges/main/assets/curseforge-badge-dark.svg">
  <source height="72px" media="(prefers-color-scheme: light)" srcset="https://raw.githubusercontent.com/Tschipcraft/badges/main/assets/curseforge-badge-light.svg">
  <img height="72px" alt="Download on CurseForge" src="https://raw.githubusercontent.com/Tschipcraft/badges/main/assets/curseforge-badge-dark.svg">
</picture>
</a>

## Development Builds

Development builds are available on [GitHub Actions](https://github.com/Tschipcraft/more_mobs/actions/workflows/ci.yml). These builds are not guaranteed to be stable and may contain bugs. Please always back up your world before using them.

## Compatibility

This data pack implements the [Smithed](https://wiki.smithed.dev/conventions/) and essential [MC Datapacks Discord Server](https://mc-datapacks.github.io/en/conventions/index.html) Conventions to ensure data pack compatibility.
