/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block.crops;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_9062;
import net.satisfy.farm_and_charm.core.block.RopeBlock;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public abstract class ClimbingCropBlock
extends class_2248 {
    public static final class_2746 SUPPORTED = class_2746.method_11825((String)"supported");
    protected final class_265 shape;

    protected ClimbingCropBlock(class_4970.class_2251 properties, class_265 shape) {
        super(properties);
        this.shape = shape;
    }

    protected abstract class_2758 getAgeProperty();

    protected abstract int getMaxAge();

    protected abstract class_1935 getRipeItem();

    protected abstract class_1935 getRottenItem();

    protected float getRottenChance() {
        return 0.05f;
    }

    protected int getHarvestResetAge(class_1937 level, class_2338 pos, class_2680 state) {
        return 1;
    }

    protected static boolean isRopeAbove(class_1936 level, class_2338 pos) {
        class_2338 up = pos.method_10084();
        class_2680 s = level.method_8320(up);
        if (s.method_26204() instanceof RopeBlock) {
            return true;
        }
        return s.method_26206((class_1922)level, up, class_2350.field_11033);
    }

    protected static int getHeight(class_2338 pos, class_1936 level) {
        int h = 0;
        while (level.method_8320(pos.method_10087(h)).method_26204() instanceof ClimbingCropBlock) {
            ++h;
        }
        return h;
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return this.shape;
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).method_11657((class_2769)SUPPORTED, (Comparable)Boolean.valueOf(false));
    }

    @NotNull
    public class_2680 getStateForAge(int age) {
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)this.getAgeProperty(), (Comparable)Integer.valueOf(Math.min(age, this.getMaxAge())))).method_11657((class_2769)SUPPORTED, (Comparable)Boolean.valueOf(false));
    }

    public boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
        class_2338 below = pos.method_10074();
        class_2680 belowState = level.method_8320(below);
        return this.mayPlaceOn(belowState) || belowState.method_26204() instanceof ClimbingCropBlock;
    }

    protected boolean mayPlaceOn(class_2680 state) {
        return state.method_26204() instanceof class_2344;
    }

    protected boolean canGrow(class_2680 state) {
        return (Integer)state.method_11654((class_2769)this.getAgeProperty()) < this.getMaxAge();
    }

    @NotNull
    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hit) {
        class_1268 hand = player.method_6058();
        if (player.method_5998(hand).method_31574(class_1802.field_8324)) {
            return class_1269.field_5811;
        }
        int age = (Integer)state.method_11654((class_2769)this.getAgeProperty());
        if (age == this.getMaxAge()) {
            this.dropFruits(level, pos, state);
            return class_1269.method_29236((boolean)level.field_9236);
        }
        return super.method_55766(state, level, pos, player, hit);
    }

    @NotNull
    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (stack.method_31574(((class_1792)ObjectRegistry.ROPE.get()).method_8389()) && !((Boolean)state.method_11654((class_2769)SUPPORTED)).booleanValue()) {
            if (!level.field_9236) {
                level.method_8652(pos, (class_2680)state.method_11657((class_2769)SUPPORTED, (Comparable)Boolean.valueOf(true)), 2);
                if (!player.method_31549().field_7477) {
                    stack.method_7934(1);
                }
                level.method_8396(null, pos, class_3417.field_15226, class_3419.field_15245, 0.8f, 1.0f);
            }
            return class_9062.field_47728;
        }
        return super.method_55765(stack, state, level, pos, player, hand, hit);
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean isMoving) {
        if (state.method_26204() != newState.method_26204() && !level.field_9236) {
            class_2338 p = pos.method_10084();
            class_2680 s = level.method_8320(p);
            while (s.method_26204() instanceof ClimbingCropBlock) {
                level.method_22352(p, true);
                p = p.method_10084();
                s = level.method_8320(p);
            }
        }
        super.method_9536(state, level, pos, newState, isMoving);
    }

    protected void dropFruits(class_1937 level, class_2338 blockPos, class_2680 blockState) {
        int age = (Integer)blockState.method_11654((class_2769)this.getAgeProperty());
        int amount = level.method_8409().method_43048(2) + (age >= this.getMaxAge() ? 1 : 0);
        class_1799 drop = level.method_8409().method_43057() < this.getRottenChance() ? new class_1799(this.getRottenItem(), 1) : new class_1799(this.getRipeItem(), amount);
        ClimbingCropBlock.method_9577((class_1937)level, (class_2338)blockPos, (class_1799)drop);
        level.method_8396(null, blockPos, class_3417.field_17617, class_3419.field_15245, 1.0f, 0.8f + level.field_9229.method_43057() * 0.4f);
        int resetAge = this.getHarvestResetAge(level, blockPos, blockState);
        level.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)this.getAgeProperty(), (Comparable)Integer.valueOf(resetAge)), 2);
    }

    public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        if (!state.method_26184((class_4538)level, pos)) {
            level.method_22352(pos, true);
        }
    }

    public boolean method_9542(class_2680 state) {
        return this.canGrow(state);
    }

    public void method_9514(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        int age;
        if (level.method_22335(pos, 0) >= 9 && (age = ((Integer)state.method_11654((class_2769)this.getAgeProperty())).intValue()) < this.getMaxAge() && random.method_43057() < 0.2f) {
            boolean supported = (Boolean)state.method_11654((class_2769)SUPPORTED);
            level.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)this.getAgeProperty(), (Comparable)Integer.valueOf(age + 1))).method_11657((class_2769)SUPPORTED, (Comparable)Boolean.valueOf(supported)), 2);
        }
    }

    public boolean method_9579(class_2680 state, class_1922 level, class_2338 pos) {
        return state.method_26227().method_15769();
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{this.getAgeProperty(), SUPPORTED});
    }
}

