/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block.entity;

import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.class_1262;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2621;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3956;
import net.minecraft.class_5558;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.satisfy.farm_and_charm.core.block.MincerBlock;
import net.satisfy.farm_and_charm.core.recipe.MincerRecipe;
import net.satisfy.farm_and_charm.core.registry.EntityTypeRegistry;
import net.satisfy.farm_and_charm.core.registry.RecipeTypeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MincerBlockEntity
extends class_2621
implements class_1278,
class_5558<MincerBlockEntity> {
    public final int SLOT_COUNT = 2;
    public final int INPUT_SLOT = 0;
    public final int OUTPUT_SLOT = 1;
    private class_2371<class_1799> stacks = class_2371.method_10213((int)2, (Object)class_1799.field_8037);

    public MincerBlockEntity(class_2338 position, class_2680 state) {
        super((class_2591)EntityTypeRegistry.MINCER_BLOCK_ENTITY.get(), position, state);
    }

    public static void spawnItem(class_1937 world, class_1799 stack, int speed, class_2350 side, class_2374 pos) {
        double d = pos.method_10216();
        double e = pos.method_10214();
        double f = pos.method_10215();
        e = side.method_10166() == class_2350.class_2351.field_11052 ? (e -= 0.125) : (e -= 0.15625);
        class_1542 itemEntity = new class_1542(world, d, e, f, stack);
        double g = world.field_9229.method_43058() * 0.1 + 0.2;
        itemEntity.method_18800(world.field_9229.method_43385((double)side.method_10148() * g, 0.0172275 * (double)speed), world.field_9229.method_43385(0.2, 0.0172275 * (double)speed), world.field_9229.method_43385((double)side.method_10165() * g, 0.0172275 * (double)speed));
        world.method_8649((class_1297)itemEntity);
    }

    public void method_11014(class_2487 compound, class_7225.class_7874 provider) {
        super.method_11014(compound, provider);
        if (!this.method_54871(compound)) {
            this.stacks = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        }
        class_1262.method_5429((class_2487)compound, this.stacks, (class_7225.class_7874)provider);
    }

    public void method_11007(class_2487 compound, class_7225.class_7874 provider) {
        super.method_11007(compound, provider);
        if (!this.method_54872(compound)) {
            class_1262.method_5426((class_2487)compound, this.stacks, (class_7225.class_7874)provider);
        }
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        return this.method_38244(provider);
    }

    public boolean method_5442() {
        for (class_1799 itemstack : this.stacks) {
            if (itemstack.method_7960()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public class_2561 method_17823() {
        return class_2561.method_43470((String)"mincer");
    }

    @NotNull
    public class_1703 method_5465(int id, class_1661 inventory) {
        return class_1707.method_19248((int)id, (class_1661)inventory);
    }

    private void dropItemsInOutputSlot(class_1937 level, class_2338 pos, class_2680 state, MincerBlockEntity mincer) {
        class_2350 direction = ((class_2350)state.method_11654((class_2769)MincerBlock.FACING)).method_10170();
        if (!level.method_8608() && !((class_1799)this.stacks.get(1)).method_7960()) {
            class_1799 droppedStack = new class_1799((class_1935)((class_1799)mincer.stacks.get(1)).method_7909());
            droppedStack.method_7939(((class_1799)mincer.stacks.get(1)).method_7947());
            this.stacks.set(1, (Object)class_1799.field_8037);
            class_243 vec3d = class_243.method_24953((class_2382)pos);
            class_243 vec3d2 = vec3d.method_43206(direction, 0.7);
            ((class_3218)level).method_14199((class_2394)class_2398.field_11228, vec3d2.method_10216(), vec3d2.method_10214(), vec3d2.method_10215(), 3, 0.2, 0.1, 0.0, 0.1);
            MincerBlockEntity.spawnItem(level, droppedStack, 6, direction, (class_2374)vec3d2);
        }
    }

    public int method_5444() {
        return 64;
    }

    public int method_5439() {
        return this.stacks.size();
    }

    public boolean method_5437(int index, class_1799 stack) {
        class_1799 inputSlotItemStack = (class_1799)this.stacks.get(0);
        return index == 0 && inputSlotItemStack.method_7960() || stack.method_31574(inputSlotItemStack.method_7909()) && inputSlotItemStack.method_7947() < inputSlotItemStack.method_7914();
    }

    @NotNull
    public class_1799 method_5438(int index) {
        return (class_1799)this.method_11282().get(index);
    }

    @NotNull
    public class_2371<class_1799> method_11282() {
        return this.stacks;
    }

    protected void method_11281(class_2371<class_1799> stacks) {
        this.stacks = stacks;
    }

    public int @NotNull [] method_5494(class_2350 side) {
        return IntStream.range(0, this.method_5439()).toArray();
    }

    public boolean method_5492(int index, class_1799 stack, @Nullable class_2350 direction) {
        return this.method_5437(index, stack);
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        return direction == class_2350.field_11036 && this.method_5437(index, stack);
    }

    public void tick(class_1937 level, class_2338 pos, class_2680 state, MincerBlockEntity mincer) {
        this.dropItemsInOutputSlot(level, pos, state, mincer);
        if (!level.method_8608() && level.method_8320(pos).method_26204() instanceof MincerBlock) {
            int crank = (Integer)state.method_11654((class_2769)MincerBlock.CRANK);
            int cranked = (Integer)state.method_11654((class_2769)MincerBlock.CRANKED);
            if (crank > 0) {
                if (cranked < 20) {
                    ++cranked;
                }
                --crank;
                if (cranked >= 20) {
                    cranked = 0;
                    class_1863 recipeManager = level.method_8433();
                    List recipes = recipeManager.method_30027((class_3956)RecipeTypeRegistry.MINCER_RECIPE_TYPE.get());
                    Optional<MincerRecipe> recipe = Optional.ofNullable(this.getRecipe(recipes, this.stacks));
                    if (recipe.isPresent()) {
                        class_1799 inputStack = (class_1799)this.stacks.get(0);
                        String recipe_type = recipe.get().getRecipeType();
                        int recipe_difficulty = 5;
                        switch (recipe_type) {
                            case "MEAT": {
                                recipe_difficulty = 1;
                                break;
                            }
                            case "WOOD": {
                                recipe_difficulty = 2;
                                break;
                            }
                            case "STONE": {
                                recipe_difficulty = 3;
                                break;
                            }
                            case "METAL": {
                                recipe_difficulty = 4;
                            }
                        }
                        class_238 searched_area = new class_238(pos);
                        searched_area.method_1014(4.0);
                        List playersNearby = level.method_8390(class_3222.class, searched_area, class_1309::method_5805);
                        if (!playersNearby.isEmpty()) {
                            for (class_1657 player : playersNearby) {
                                if (player == null || !player.method_6079().method_31574(inputStack.method_7909())) continue;
                                --recipe_difficulty;
                            }
                        }
                        if (recipe_difficulty > 0) {
                            inputStack.method_7934(1);
                            inputStack = inputStack.method_7960() ? class_1799.field_8037 : inputStack;
                            mincer.method_5447(0, inputStack);
                            mincer.method_5447(1, recipe.get().method_8110((class_7225.class_7874)level.method_30349()));
                            level.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)MincerBlock.CRANK, (Comparable)Integer.valueOf(crank))).method_11657((class_2769)MincerBlock.CRANKED, (Comparable)Integer.valueOf(cranked)), 3);
                            return;
                        }
                    }
                }
                level.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)MincerBlock.CRANK, (Comparable)Integer.valueOf(crank))).method_11657((class_2769)MincerBlock.CRANKED, (Comparable)Integer.valueOf(cranked)), 3);
            } else if (cranked > 0 && cranked < 20) {
                level.method_8652(pos, (class_2680)state.method_11657((class_2769)MincerBlock.CRANKED, (Comparable)Integer.valueOf(0)), 3);
            }
        }
    }

    private MincerRecipe getRecipe(List<class_8786<MincerRecipe>> recipes, class_2371<class_1799> inventory) {
        block0: for (class_8786<MincerRecipe> recipeHolder : recipes) {
            MincerRecipe recipe = (MincerRecipe)recipeHolder.comp_1933();
            for (class_1856 ingredient : recipe.method_8117()) {
                boolean ingredientFound = false;
                for (class_1799 slotItem : inventory) {
                    if (!ingredient.method_8093(slotItem)) continue;
                    ingredientFound = true;
                    break;
                }
                if (ingredientFound) continue;
                continue block0;
            }
            return recipe;
        }
        return null;
    }
}

