/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block;

import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3956;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_8786;
import net.minecraft.class_9062;
import net.satisfy.farm_and_charm.core.block.FacingBlock;
import net.satisfy.farm_and_charm.core.block.entity.SiloBlockEntity;
import net.satisfy.farm_and_charm.core.recipe.SiloRecipe;
import net.satisfy.farm_and_charm.core.registry.EntityTypeRegistry;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import net.satisfy.farm_and_charm.core.registry.RecipeTypeRegistry;
import net.satisfy.farm_and_charm.core.util.ConnectivityHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SiloBlock
extends FacingBlock
implements class_2343 {
    public static final class_2746 TOP = class_2746.method_11825((String)"top");
    public static final class_2746 BOTTOM = class_2746.method_11825((String)"bottom");
    public static final class_2746 OPEN = class_2746.method_11825((String)"open");
    public static final class_2754<Shape> SHAPE = class_2754.method_11850((String)"shape", Shape.class);
    static final class_265 CAMPFIRE_SMOKE_CLIP = class_2248.method_9541((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public SiloBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)TOP, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)BOTTOM, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false))).method_11657(SHAPE, (Comparable)((Object)Shape.NONE))).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043));
    }

    public static boolean isSilo(class_1799 itemStack) {
        class_1747 bi;
        class_1792 item = itemStack.method_7909();
        return item instanceof class_1747 && ((bi = (class_1747)item).method_7711() == ObjectRegistry.SILO_WOOD.get() || bi.method_7711() == ObjectRegistry.SILO_COPPER.get());
    }

    public static boolean isSilo(class_2680 state) {
        return state.method_26204() instanceof SiloBlock;
    }

    public static boolean isDryItem(class_1937 level, class_1799 itemStack) {
        return SiloBlock.getDryItemRecipe(level, itemStack).isPresent();
    }

    public static Optional<class_8786<SiloRecipe>> getDryItemRecipe(class_1937 level, class_1799 itemStack) {
        return level.method_8433().method_30027((class_3956)RecipeTypeRegistry.SILO_RECIPE_TYPE.get()).stream().filter(siloRecipe -> ((SiloRecipe)siloRecipe.comp_1933()).getInput().method_8093(itemStack)).findFirst();
    }

    public class_2350 getFacing(class_2680 state) {
        return (class_2350)state.method_11654((class_2769)field_11177);
    }

    public class_2680 setFacing(class_2680 state, class_2350 facing) {
        return (class_2680)state.method_11657((class_2769)field_11177, (Comparable)facing);
    }

    protected class_9062 method_55765(class_1799 itemStack, class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        if (level.field_9236) {
            return itemStack.method_7960() || SiloBlock.isDryItem(level, itemStack) ? class_9062.field_47728 : (SiloBlock.isSilo(itemStack) || player.method_21751() ? class_9062.field_47731 : class_9062.field_47729);
        }
        class_2586 be = level.method_8321(blockPos);
        if (be instanceof SiloBlockEntity) {
            SiloBlockEntity siloBE = (SiloBlockEntity)be;
            SiloBlockEntity siloController = (SiloBlockEntity)siloBE.getControllerBE();
            if (siloController == null) {
                return class_9062.field_47731;
            }
            if (itemStack.method_7960()) {
                if (player.method_21751()) {
                    class_1799 returnStack = siloBE.tryRemoveItem();
                    if (!returnStack.method_7960()) {
                        player.method_7270(itemStack);
                        level.method_8396(null, blockPos, class_3417.field_17606, class_3419.field_15245, 1.0f, 1.0f);
                    }
                } else {
                    boolean isOpen = (Boolean)blockState.method_11654((class_2769)OPEN);
                    siloController.open(!isOpen);
                    level.method_8396(null, blockPos, isOpen ? class_3417.field_15131 : class_3417.field_15082, class_3419.field_15245, 1.0f, 1.0f);
                }
                return class_9062.field_47728;
            }
            if (SiloBlock.isDryItem(level, itemStack) && siloController.tryAddItem(itemStack)) {
                level.method_8396(null, blockPos, class_3417.field_17608, class_3419.field_15245, 1.0f, 1.0f);
                return class_9062.field_47728;
            }
        }
        return SiloBlock.isSilo(itemStack) || player.method_21751() ? class_9062.field_47731 : class_9062.field_47729;
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (oldState.method_26204() == state.method_26204()) {
            return;
        }
        if (notify) {
            return;
        }
        class_2586 be = world.method_8321(pos);
        if (be instanceof SiloBlockEntity) {
            SiloBlockEntity siloBlockEntity = (SiloBlockEntity)be;
            siloBlockEntity.updateConnectivity();
        }
    }

    public void method_9536(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2680 newState, boolean moved) {
        if (blockState.method_31709() && (blockState.method_26204() != newState.method_26204() || !newState.method_31709())) {
            class_2586 be = level.method_8321(blockPos);
            if (!(be instanceof SiloBlockEntity)) {
                return;
            }
            SiloBlockEntity siloBE = (SiloBlockEntity)be;
            class_1264.method_5451((class_1937)level, (class_2338)blockPos, (class_1263)siloBE);
            level.method_8544(blockPos);
            ConnectivityHandler.splitMulti(siloBE);
        }
    }

    public boolean method_9522(class_2680 blockState, class_2680 blockState2, class_2350 direction) {
        return blockState2.method_27852((class_2248)this) || super.method_9522(blockState, blockState2, direction);
    }

    public boolean method_9498(class_2680 blockState) {
        return true;
    }

    public int method_9572(class_2680 blockState, class_1937 level, class_2338 blockPos) {
        return level.method_35230(blockPos, (class_2591)EntityTypeRegistry.SILO_BLOCK_ENTITY.get()).map(class_1703::method_7618).orElse(0);
    }

    @NotNull
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (context == class_3726.method_16194()) {
            return CAMPFIRE_SMOKE_CLIP;
        }
        return state.method_26218(world, pos);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{TOP, BOTTOM, OPEN, SHAPE, field_11177});
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof class_5558) {
                ((class_5558)blockEntity).tick(world, pos, state1, blockEntity);
            }
        };
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new SiloBlockEntity(pos, state);
    }

    @NotNull
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        if (mirror == class_2415.field_11302) {
            return state;
        }
        return switch (((Shape)((Object)state.method_11654(SHAPE))).ordinal()) {
            case 1 -> (class_2680)state.method_11657(SHAPE, (Comparable)((Object)Shape.SOUTH));
            case 2 -> (class_2680)state.method_11657(SHAPE, (Comparable)((Object)Shape.SOUTH_WEST));
            case 3 -> (class_2680)state.method_11657(SHAPE, (Comparable)((Object)Shape.WEST));
            case 4 -> (class_2680)state.method_11657(SHAPE, (Comparable)((Object)Shape.NORTH_WEST));
            case 5 -> (class_2680)state.method_11657(SHAPE, (Comparable)((Object)Shape.NORTH));
            case 6 -> (class_2680)state.method_11657(SHAPE, (Comparable)((Object)Shape.NORTH_EAST));
            case 7 -> (class_2680)state.method_11657(SHAPE, (Comparable)((Object)Shape.EAST));
            case 8 -> (class_2680)state.method_11657(SHAPE, (Comparable)((Object)Shape.SOUTH_EAST));
            default -> state;
        };
    }

    @NotNull
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        for (int i = 0; i < rotation.ordinal(); ++i) {
            state = this.rotateOnce(state);
        }
        return state;
    }

    private class_2680 rotateOnce(class_2680 state) {
        return switch (((Shape)((Object)state.method_11654(SHAPE))).ordinal()) {
            case 1 -> (class_2680)state.method_11657(SHAPE, (Comparable)((Object)Shape.EAST));
            case 2 -> (class_2680)state.method_11657(SHAPE, (Comparable)((Object)Shape.SOUTH_EAST));
            case 3 -> (class_2680)state.method_11657(SHAPE, (Comparable)((Object)Shape.SOUTH));
            case 4 -> (class_2680)state.method_11657(SHAPE, (Comparable)((Object)Shape.SOUTH_WEST));
            case 5 -> (class_2680)state.method_11657(SHAPE, (Comparable)((Object)Shape.WEST));
            case 6 -> (class_2680)state.method_11657(SHAPE, (Comparable)((Object)Shape.NORTH_WEST));
            case 7 -> (class_2680)state.method_11657(SHAPE, (Comparable)((Object)Shape.NORTH));
            case 8 -> (class_2680)state.method_11657(SHAPE, (Comparable)((Object)Shape.NORTH_EAST));
            default -> state;
        };
    }

    public static enum Shape implements class_3542
    {
        NONE,
        NORTH,
        NORTH_EAST,
        EAST,
        SOUTH_EAST,
        SOUTH,
        SOUTH_WEST,
        WEST,
        NORTH_WEST;


        @NotNull
        public String method_15434() {
            return this.name().toLowerCase();
        }
    }
}

