/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block.entity;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.class_1262;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2621;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3956;
import net.minecraft.class_5558;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.satisfy.farm_and_charm.core.block.CraftingBowlBlock;
import net.satisfy.farm_and_charm.core.recipe.CraftingBowlRecipe;
import net.satisfy.farm_and_charm.core.registry.EntityTypeRegistry;
import net.satisfy.farm_and_charm.core.registry.RecipeTypeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftingBowlBlockEntity
extends class_2621
implements class_1278,
class_5558<CraftingBowlBlockEntity> {
    private class_2371<class_1799> stacks = class_2371.method_10213((int)5, (Object)class_1799.field_8037);

    public CraftingBowlBlockEntity(class_2338 position, class_2680 state) {
        super((class_2591)EntityTypeRegistry.CRAFTING_BOWL_BLOCK_ENTITY.get(), position, state);
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        if (!this.method_54871(tag)) {
            this.stacks = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        }
        class_1262.method_5429((class_2487)tag, this.stacks, (class_7225.class_7874)provider);
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        if (!this.method_54872(tag)) {
            class_1262.method_5426((class_2487)tag, this.stacks, (class_7225.class_7874)provider);
        }
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887(class_7225.class_7874 provider) {
        return this.method_38244(provider);
    }

    public int method_5439() {
        return this.stacks.size();
    }

    public boolean method_5442() {
        for (class_1799 itemstack : this.stacks) {
            if (itemstack.method_7960()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public class_2561 method_17823() {
        return class_2561.method_43470((String)"crafting_bowl");
    }

    @NotNull
    public class_1703 method_5465(int id, class_1661 inventory) {
        return class_1707.method_19248((int)id, (class_1661)inventory);
    }

    public int method_5444() {
        return 64;
    }

    public boolean method_5437(int index, class_1799 stack) {
        return index >= 0 && index < 4;
    }

    @NotNull
    public class_2371<class_1799> method_11282() {
        return this.stacks;
    }

    protected void method_11281(class_2371<class_1799> stacks) {
        this.stacks = stacks;
    }

    public boolean canAddItem(class_1799 stack) {
        for (int i = 0; i < 4; ++i) {
            if (!this.method_5438(i).method_7960()) continue;
            return true;
        }
        return false;
    }

    public void addItemStack(class_1799 stack) {
        for (int j = 0; j < 4; ++j) {
            if (!this.method_5438(j).method_7960()) continue;
            class_1799 one = stack.method_7972();
            one.method_7939(1);
            this.method_5447(j, one);
            this.method_5431();
            return;
        }
    }

    public int @NotNull [] method_5494(class_2350 side) {
        return IntStream.range(0, this.method_5439()).toArray();
    }

    public boolean method_5492(int index, class_1799 stack, @Nullable class_2350 direction) {
        return this.method_5437(index, stack);
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        return true;
    }

    private class_1799 getRemainderItem(class_1799 stack) {
        if (stack.method_7909().method_7857()) {
            return new class_1799((class_1935)Objects.requireNonNull(stack.method_7909().method_7858()));
        }
        return class_1799.field_8037;
    }

    public int getStirringProgress() {
        return (Integer)this.method_11010().method_11654((class_2769)CraftingBowlBlock.STIRRED);
    }

    public Optional<CraftingBowlRecipe> findRecipe(class_1937 level) {
        if (!this.method_5438(4).method_7960()) {
            return Optional.empty();
        }
        List all = level.method_8433().method_30027((class_3956)RecipeTypeRegistry.CRAFTING_BOWL_RECIPE_TYPE.get());
        return Optional.ofNullable(this.matchExact(all));
    }

    private CraftingBowlRecipe matchExact(List<class_8786<CraftingBowlRecipe>> recipes) {
        class_1799[] inputs = new class_1799[4];
        int present = 0;
        for (int i = 0; i < 4; ++i) {
            inputs[i] = this.method_5438(i);
            if (inputs[i].method_7960()) continue;
            ++present;
        }
        for (class_8786<CraftingBowlRecipe> holder : recipes) {
            CraftingBowlRecipe r = (CraftingBowlRecipe)holder.comp_1933();
            int needed = 0;
            for (class_1856 ing : r.method_8117()) {
                if (ing.method_8103()) continue;
                ++needed;
            }
            if (present != needed) continue;
            boolean[] used = new boolean[4];
            boolean ok = true;
            for (class_1856 ing : r.method_8117()) {
                if (ing.method_8103()) continue;
                boolean matched = false;
                for (int i = 0; i < 4; ++i) {
                    if (used[i] || inputs[i].method_7960() || !ing.method_8093(inputs[i])) continue;
                    used[i] = true;
                    matched = true;
                    break;
                }
                if (matched) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            return r;
        }
        return null;
    }

    public void tick(class_1937 level, class_2338 pos, class_2680 state, CraftingBowlBlockEntity be) {
        if (!level.field_9236 && state.method_26204() instanceof CraftingBowlBlock) {
            int stirring = (Integer)state.method_11654((class_2769)CraftingBowlBlock.STIRRING);
            int stirred = (Integer)state.method_11654((class_2769)CraftingBowlBlock.STIRRED);
            if (stirring > 0) {
                Optional<CraftingBowlRecipe> recipe = be.findRecipe(level);
                if (recipe.isPresent() && stirred < 50 && ++stirred == 50) {
                    class_2371<class_1856> ings = recipe.get().method_8117();
                    boolean[] used = new boolean[4];
                    block0: for (class_1856 ing : ings) {
                        if (ing.method_8103()) continue;
                        for (int i = 0; i < 4; ++i) {
                            if (used[i] || !ing.method_8093(be.method_5438(i))) continue;
                            class_1799 stack = be.method_5438(i);
                            class_1799 remainder = this.getRemainderItem(stack);
                            stack.method_7934(1);
                            if (stack.method_7960()) {
                                be.method_5447(i, class_1799.field_8037);
                            }
                            if (!remainder.method_7960()) {
                                double ox = level.field_9229.method_43058() * 0.7 + 0.15;
                                double oy = level.field_9229.method_43058() * 0.7 + 0.15;
                                double oz = level.field_9229.method_43058() * 0.7 + 0.15;
                                level.method_8649((class_1297)new class_1542(level, (double)pos.method_10263() + ox, (double)pos.method_10264() + oy, (double)pos.method_10260() + oz, remainder));
                            }
                            used[i] = true;
                            continue block0;
                        }
                    }
                    class_1799 resultItem = recipe.get().method_8110((class_7225.class_7874)level.method_30349()).method_7972();
                    resultItem.method_7939(recipe.get().getOutputCount());
                    be.method_5447(4, resultItem);
                }
                level.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)CraftingBowlBlock.STIRRING, (Comparable)Integer.valueOf(--stirring))).method_11657((class_2769)CraftingBowlBlock.STIRRED, (Comparable)Integer.valueOf(stirred)), 3);
            } else if (stirred > 0 && stirred < 50) {
                level.method_8652(pos, (class_2680)state.method_11657((class_2769)CraftingBowlBlock.STIRRED, (Comparable)Integer.valueOf(0)), 3);
            }
        }
    }
}

