/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.entity.ai;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1429;
import net.minecraft.class_1493;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.satisfy.farm_and_charm.core.block.entity.PetBowlBlockEntity;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;

public class WhineAtBowlGoal
extends class_1352 {
    private final class_1493 wolf;
    private class_2338 bowlPos;
    private class_243 lastTargetPos;
    private int whineTicks;
    private int fadeOutTicks;
    private long lastScanTick;
    private long lastWhineSoundTick;
    private boolean active;
    private static final int SCAN_INTERVAL_TICKS = 40;
    private static final int MAX_WHINE_TICKS = 300;
    private static final int WHINE_INTERVAL = 60;
    private static final int ANGRY_PARTICLE_INTERVAL = 100;
    private static final int WHINE_PARTICLE_COUNT = 6;
    private static final int FINAL_PARTICLE_COUNT = 15;
    private static final int FADE_OUT_DURATION = 30;
    private static final double BASE_SPEED = 1.0;
    private static final double EVENING_SPEED_FACTOR = 0.8;
    private static final double CLOSE_ENOUGH_DIST = 1.1;
    private static final float BASE_VOLUME = 0.4f;
    private static final float BASE_PITCH = 0.4f;
    private static final int LOOK_YAW = 10;
    private static final int LOOK_PITCH = 30;
    private static final int RANGE_XZ = 10;
    private static final int RANGE_Y = 2;
    private static final long MORNING_START = 5800L;
    private static final long MORNING_END = 6200L;
    private static final long EVENING_START = 11500L;
    private static final long EVENING_END = 12500L;
    private static final double NAVIGATION_RECALC_THRESHOLD_SQR = 0.5;
    private static final List<class_3414> WHINE_SOUNDS = List.of(class_3417.field_14807, class_3417.field_14922);

    public WhineAtBowlGoal(class_1493 wolf) {
        this.wolf = wolf;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        this.whineTicks = 0;
        this.lastScanTick = -40L;
        this.lastWhineSoundTick = -60L;
        this.active = false;
        this.lastTargetPos = null;
    }

    public boolean method_6264() {
        if (!this.wolf.method_5805() || !this.wolf.method_6181() || this.wolf.method_24345()) {
            return false;
        }
        class_1937 class_19372 = this.wolf.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return false;
        }
        class_3218 server = (class_3218)class_19372;
        if (!this.shouldScanForBowl(server.method_8510())) {
            return false;
        }
        if (!this.isValidWhineTime(server.method_8532())) {
            return false;
        }
        class_2338 wolfPos = this.wolf.method_24515();
        double closestDistance = Double.MAX_VALUE;
        class_2338 closest = null;
        for (class_2338 pos : class_2338.method_10097((class_2338)wolfPos.method_10069(-10, -2, -10), (class_2338)wolfPos.method_10069(10, 2, 10))) {
            double dist;
            PetBowlBlockEntity bowl;
            class_2586 be;
            if (!this.wolf.method_37908().method_8320(pos).method_27852((class_2248)ObjectRegistry.PET_BOWL.get()) || !((be = this.wolf.method_37908().method_8321(pos)) instanceof PetBowlBlockEntity) || !(bowl = (PetBowlBlockEntity)be).method_5442() || !bowl.canBeUsedBy((class_1429)this.wolf) || !((dist = this.wolf.method_19538().method_1025(class_243.method_24953((class_2382)pos))) < closestDistance)) continue;
            closestDistance = dist;
            closest = pos.method_10062();
        }
        if (closest != null) {
            this.bowlPos = closest;
            return true;
        }
        return false;
    }

    public boolean method_6266() {
        PetBowlBlockEntity bowl;
        if (!this.active || !this.wolf.method_5805() || this.bowlPos == null) {
            return false;
        }
        class_1937 class_19372 = this.wolf.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return false;
        }
        class_3218 server = (class_3218)class_19372;
        class_2586 be = server.method_8321(this.bowlPos);
        return be instanceof PetBowlBlockEntity && (bowl = (PetBowlBlockEntity)be).method_5442() && bowl.canBeUsedBy((class_1429)this.wolf);
    }

    public boolean method_6267() {
        return false;
    }

    public void method_6269() {
        PetBowlBlockEntity bowl;
        class_1937 class_19372 = this.wolf.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 server = (class_3218)class_19372;
        class_2586 be = server.method_8321(this.bowlPos);
        if (!(be instanceof PetBowlBlockEntity && (bowl = (PetBowlBlockEntity)be).method_5442() && bowl.canBeUsedBy((class_1429)this.wolf))) {
            this.method_6270();
            return;
        }
        this.wolf.method_24346(false);
        this.moveToBowl(server.method_8532());
        this.whineTicks = 0;
        this.fadeOutTicks = 0;
        this.lastWhineSoundTick = -60L;
        this.active = true;
    }

    public void method_6268() {
        class_1309 owner;
        PetBowlBlockEntity bowl;
        class_3218 server;
        block17: {
            block16: {
                class_1937 class_19372 = this.wolf.method_37908();
                if (!(class_19372 instanceof class_3218)) break block16;
                server = (class_3218)class_19372;
                if (this.wolf.method_5805()) break block17;
            }
            this.method_6270();
            return;
        }
        class_2586 be = server.method_8321(this.bowlPos);
        if (!(be instanceof PetBowlBlockEntity) || !(bowl = (PetBowlBlockEntity)be).method_5442()) {
            this.method_6270();
            return;
        }
        class_243 bowlCenter = class_243.method_24953((class_2382)this.bowlPos);
        if (this.isNearBowl()) {
            if (this.wolf.method_5942().method_23966()) {
                this.wolf.method_5942().method_6340();
            }
            if (!this.wolf.method_6172()) {
                this.wolf.method_24346(true);
            }
            this.wolf.method_5988().method_6230(bowlCenter.field_1352, bowlCenter.field_1351, bowlCenter.field_1350, 10.0f, 30.0f);
        } else {
            if (this.wolf.method_6172()) {
                this.wolf.method_24346(false);
            }
            if (!this.wolf.method_5942().method_23966() || this.needsRepath(bowlCenter)) {
                this.moveToBowl(server.method_8532());
            }
        }
        if ((long)this.whineTicks - this.lastWhineSoundTick >= 60L) {
            this.playWhineSound();
            this.lastWhineSoundTick = this.whineTicks;
        }
        if (this.whineTicks % 100 == 0) {
            class_243 pos = this.wolf.method_19538().method_1031(0.0, 0.5, 0.0);
            server.method_14199((class_2394)class_2398.field_11231, pos.field_1352, pos.field_1351, pos.field_1350, 6, 0.3, 0.3, 0.3, 0.01);
        }
        if ((owner = this.wolf.method_35057()) != null && (double)this.wolf.method_5739((class_1297)owner) < 4.0 && server.method_8409().method_43048(100) < 10) {
            this.wolf.method_5783(class_3417.field_14807, 0.6f, 0.9f + server.method_8409().method_43057() * 0.2f);
        }
        if (++this.whineTicks >= 300) {
            PetBowlBlockEntity finalBowl;
            if (this.fadeOutTicks < 30) {
                ++this.fadeOutTicks;
                return;
            }
            class_2586 currentBowl = server.method_8321(this.bowlPos);
            if (currentBowl instanceof PetBowlBlockEntity && (finalBowl = (PetBowlBlockEntity)currentBowl).method_5442()) {
                this.wolf.method_5783(class_3417.field_14575, 0.4f, 0.4f);
                class_243 pos = this.wolf.method_19538().method_1031(0.0, 0.5, 0.0);
                server.method_14199((class_2394)class_2398.field_11231, pos.field_1352, pos.field_1351, pos.field_1350, 15, 0.3, 0.3, 0.3, 0.01);
            }
            this.method_6270();
        }
    }

    public void method_6270() {
        this.bowlPos = null;
        this.whineTicks = 0;
        this.fadeOutTicks = 0;
        this.active = false;
        this.lastTargetPos = null;
        this.wolf.method_24346(false);
        if (this.wolf.method_5942().method_23966()) {
            this.wolf.method_5942().method_6340();
        }
    }

    private void playWhineSound() {
        class_3414 sound = WHINE_SOUNDS.get(this.wolf.method_59922().method_43048(WHINE_SOUNDS.size()));
        float volume = 0.4f + this.wolf.method_59922().method_43057() * 0.3f;
        float pitch = 0.4f + this.wolf.method_59922().method_43057() * 0.4f;
        this.wolf.method_5783(sound, volume, pitch);
    }

    private boolean isNearBowl() {
        return this.bowlPos != null && this.wolf.method_19538().method_1025(class_243.method_24953((class_2382)this.bowlPos)) < 1.2100000000000002;
    }

    private boolean shouldScanForBowl(long currentTick) {
        if (currentTick - this.lastScanTick < 40L) {
            return false;
        }
        this.lastScanTick = currentTick;
        return true;
    }

    private boolean isValidWhineTime(long timeOfDay) {
        long dayTime = timeOfDay % 24000L;
        return dayTime >= 5800L && dayTime <= 6200L || dayTime >= 11500L && dayTime <= 12500L;
    }

    private void moveToBowl(long timeOfDay) {
        if (this.bowlPos != null) {
            class_243 target = class_243.method_24953((class_2382)this.bowlPos);
            this.wolf.method_5942().method_6337(target.field_1352, target.field_1351, target.field_1350, this.getSpeed(timeOfDay));
            this.lastTargetPos = target;
        }
    }

    private boolean needsRepath(class_243 target) {
        return this.lastTargetPos == null || this.lastTargetPos.method_1025(target) > 0.5;
    }

    private double getSpeed(long timeOfDay) {
        long dayTime = timeOfDay % 24000L;
        if (dayTime >= 11500L && dayTime <= 12500L) {
            return 0.8;
        }
        return 1.0;
    }
}

