/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.client.gui.handler;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.satisfy.farm_and_charm.client.gui.handler.slot.ExtendedSlot;
import net.satisfy.farm_and_charm.client.gui.handler.slot.StoveOutputSlot;
import net.satisfy.farm_and_charm.core.registry.ScreenhandlerTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class StoveGuiHandler
extends AbstractContainerMenu {
    private final Container inventory;
    public final ContainerData propertyDelegate;

    public StoveGuiHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(5), (ContainerData)new SimpleContainerData(4));
    }

    public StoveGuiHandler(int syncId, Inventory playerInventory, Container inventory, ContainerData propertyDelegate) {
        super((MenuType)ScreenhandlerTypeRegistry.STOVE_SCREEN_HANDLER.get(), syncId);
        this.inventory = inventory;
        this.propertyDelegate = propertyDelegate;
        this.m_38884_(propertyDelegate);
        this.buildBlockEntityContainer(playerInventory);
        this.buildPlayerContainer(playerInventory);
    }

    private static boolean isFuel(ItemStack stack) {
        return AbstractFurnaceBlockEntity.m_58399_((ItemStack)stack);
    }

    private void buildBlockEntityContainer(Inventory playerInventory) {
        this.m_38897_(new StoveOutputSlot(playerInventory.f_35978_, this.inventory, 0, 126, 42));
        this.m_38897_(new ExtendedSlot(this.inventory, 1, 29, 18));
        this.m_38897_(new ExtendedSlot(this.inventory, 2, 47, 18));
        this.m_38897_(new ExtendedSlot(this.inventory, 3, 65, 18));
        this.m_38897_(new ExtendedSlot(this.inventory, 4, 42, 48, StoveGuiHandler::isFuel));
    }

    private void buildPlayerContainer(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 142));
        }
    }

    public int getScaledProgress(int arrowWidth) {
        int progress = this.propertyDelegate.m_6413_(2);
        int totalProgress = this.propertyDelegate.m_6413_(3);
        if (progress > 0 && totalProgress > 0) {
            return progress * arrowWidth / totalProgress;
        }
        return 0;
    }

    public boolean isBeingBurned() {
        return this.propertyDelegate.m_6413_(0) > 0;
    }

    @NotNull
    public ItemStack m_7648_(Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            ItemStack copy = stack.m_41777_();
            if (index == 0) {
                if (!this.m_38903_(stack, 5, 41, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(stack, copy);
            } else if (index >= 1 && index <= 3 ? !this.m_38903_(stack, 5, 41, true) : (index == 4 ? !this.m_38903_(stack, 5, 41, true) : (StoveGuiHandler.isFuel(stack) ? !this.m_38903_(stack, 4, 5, false) : !this.m_38903_(stack, 1, 4, false)))) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack.m_41613_() == copy.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stack);
            return copy;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return this.inventory.m_6542_(player);
    }
}

