/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block;

import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.farm_and_charm.core.block.entity.CraftingBowlBlockEntity;
import net.satisfy.farm_and_charm.core.registry.EntityTypeRegistry;
import net.satisfy.farm_and_charm.core.registry.SoundEventRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftingBowlBlock
extends BaseEntityBlock {
    public static final int STIRS_NEEDED = 50;
    public static final IntegerProperty STIRRING = IntegerProperty.m_61631_((String)"stirring", (int)0, (int)32);
    public static final IntegerProperty STIRRED = IntegerProperty.m_61631_((String)"stirred", (int)0, (int)100);

    public CraftingBowlBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)STIRRING, (Comparable)Integer.valueOf(0)));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)STIRRED, (Comparable)Integer.valueOf(0)));
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.m_60824_(world, pos);
        return Shapes.m_83110_((VoxelShape)CraftingBowlBlock.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), (VoxelShape)CraftingBowlBlock.m_49796_((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0)).m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STIRRING});
        builder.m_61104_(new Property[]{STIRRED});
    }

    @NotNull
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        List dropsOriginal = super.m_49635_(state, builder);
        if (!dropsOriginal.isEmpty()) {
            return dropsOriginal;
        }
        return Collections.singletonList(new ItemStack((ItemLike)this, 1));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState blockState, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = world.m_7702_(pos);
        ItemStack itemStack = player.m_21120_(hand);
        if (blockEntity instanceof CraftingBowlBlockEntity) {
            CraftingBowlBlockEntity bowlEntity = (CraftingBowlBlockEntity)blockEntity;
            int stirring = (Integer)blockState.m_61143_((Property)STIRRING);
            int stirred = (Integer)blockState.m_61143_((Property)STIRRED);
            if (player.m_6144_() && itemStack.m_41619_() && hand == InteractionHand.MAIN_HAND) {
                for (int i = 0; i < bowlEntity.m_6643_(); ++i) {
                    ItemStack stack = bowlEntity.m_8020_(i);
                    if (stack.m_41619_()) continue;
                    CraftingBowlBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)stack);
                    bowlEntity.m_6836_(i, ItemStack.f_41583_);
                }
                bowlEntity.m_6596_();
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            if (!itemStack.m_41619_() && stirring == 0) {
                if (bowlEntity.canAddItem(itemStack)) {
                    bowlEntity.addItemStack(itemStack.m_41777_());
                    if (!player.m_7500_()) {
                        itemStack.m_41764_(0);
                    }
                    return InteractionResult.SUCCESS;
                }
            } else if (itemStack.m_41619_()) {
                if (stirred >= 50 && stirring == 0) {
                    player.m_150109_().m_36054_(bowlEntity.m_8020_(4));
                    bowlEntity.m_6836_(4, ItemStack.f_41583_);
                    world.m_7731_(pos, (BlockState)blockState.m_61124_((Property)STIRRED, (Comparable)Integer.valueOf(0)), 3);
                    return InteractionResult.SUCCESS;
                }
                if (world instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)world;
                    RandomSource randomSource = serverWorld.f_46441_;
                    for (ItemStack stack : bowlEntity.m_7086_()) {
                        if (stack.m_41619_() || bowlEntity.m_8020_(4) == stack) continue;
                        ItemParticleOption particleOption = new ItemParticleOption(ParticleTypes.f_123752_, stack);
                        serverWorld.m_8767_((ParticleOptions)particleOption, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.6, (double)pos.m_123343_() + 0.5, 1, randomSource.m_188583_() * 0.15, 0.05, randomSource.m_188583_() * 0.15, 0.05);
                    }
                }
                if (stirring <= 6) {
                    world.m_7731_(pos, (BlockState)blockState.m_61124_((Property)STIRRING, (Comparable)Integer.valueOf(10)), 3);
                    world.m_5594_(null, pos, (SoundEvent)SoundEventRegistry.CRAFTING_BOWL_STIRRING.get(), SoundSource.BLOCKS, 0.05f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        VoxelShape shape = world.m_8055_(pos.m_7495_()).m_60808_((BlockGetter)world, pos.m_7495_());
        Direction direction = Direction.UP;
        return Block.m_49918_((VoxelShape)shape, (Direction)direction);
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_46961_(pos, true);
        }
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_186460_(pos, (Block)this, 1);
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public void m_6807_(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.m_6807_(blockstate, world, pos, oldState, moving);
    }

    public MenuProvider m_7246_(BlockState state, Level worldIn, BlockPos pos) {
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        return tileEntity instanceof MenuProvider ? (MenuProvider)tileEntity : null;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CraftingBowlBlockEntity(pos, state);
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.m_8133_(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.m_7702_(pos);
        return blockEntity != null && blockEntity.m_7531_(eventID, eventParam);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof CraftingBowlBlockEntity) {
                CraftingBowlBlockEntity be = (CraftingBowlBlockEntity)blockEntity;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)be);
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return CraftingBowlBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)EntityTypeRegistry.CRAFTING_BOWL_BLOCK_ENTITY.get()), (world1, pos, state1, be) -> be.tick(world1, pos, state1, (CraftingBowlBlockEntity)be));
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.farm_and_charm.canbeplaced").m_130940_(ChatFormatting.GRAY));
    }
}

