/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.registry;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.satisfy.farm_and_charm.core.effect.ChickenEffect;
import net.satisfy.farm_and_charm.core.effect.DogFoodEffect;
import net.satisfy.farm_and_charm.core.effect.FarmersBlessingEffect;
import net.satisfy.farm_and_charm.core.effect.FeastEffect;
import net.satisfy.farm_and_charm.core.effect.GrandmasBlessingEffect;
import net.satisfy.farm_and_charm.core.effect.HorseFodderEffect;
import net.satisfy.farm_and_charm.core.effect.RestedEffect;
import net.satisfy.farm_and_charm.core.effect.SatiationEffect;
import net.satisfy.farm_and_charm.core.effect.SustenanceEffect;
import net.satisfy.farm_and_charm.core.effect.SweetsEffect;
import net.satisfy.farm_and_charm.core.util.FarmAndCharmIdentifier;

public class MobEffectRegistry {
    private static final DeferredRegister<MobEffect> MOB_EFFECTS = DeferredRegister.create((String)"farm_and_charm", (ResourceKey)Registries.f_256929_);
    private static final Registrar<MobEffect> MOB_EFFECTS_REGISTRAR = MOB_EFFECTS.getRegistrar();
    public static final RegistrySupplier<MobEffect> SWEETS = MobEffectRegistry.registerEffect("sweets", SweetsEffect::new);
    public static final RegistrySupplier<MobEffect> HORSE_FODDER = MobEffectRegistry.registerEffect("horse_fodder", HorseFodderEffect::new);
    public static final RegistrySupplier<MobEffect> DOG_FOOD = MobEffectRegistry.registerEffect("dog_food", DogFoodEffect::new);
    public static final RegistrySupplier<MobEffect> CLUCK = MobEffectRegistry.registerEffect("cluck", ChickenEffect::new);
    public static final RegistrySupplier<MobEffect> GRANDMAS_BLESSING = MobEffectRegistry.registerEffect("grandmas_blessing", GrandmasBlessingEffect::new);
    public static final RegistrySupplier<MobEffect> RESTED = MobEffectRegistry.registerEffect("rested", RestedEffect::new);
    public static final RegistrySupplier<MobEffect> FARMERS_BLESSING = MobEffectRegistry.registerEffect("farmers_blessing", FarmersBlessingEffect::new);
    public static final RegistrySupplier<MobEffect> SUSTENANCE = MobEffectRegistry.registerEffect("sustenance", SustenanceEffect::new);
    public static final RegistrySupplier<MobEffect> SATIATION = MobEffectRegistry.registerEffect("satiation", SatiationEffect::new);
    public static final RegistrySupplier<MobEffect> FEAST = MobEffectRegistry.registerEffect("feast", FeastEffect::new);

    private static RegistrySupplier<MobEffect> registerEffect(String name, Supplier<MobEffect> effect) {
        if (Platform.isForge()) {
            return MOB_EFFECTS.register(name, effect);
        }
        return MOB_EFFECTS_REGISTRAR.register((ResourceLocation)new FarmAndCharmIdentifier(name), effect);
    }

    public static void init() {
        MOB_EFFECTS.register();
    }
}

