/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import net.satisfy.farm_and_charm.platform.PlatformHelper;
import org.jetbrains.annotations.Nullable;

public class FertilizedFarmlandBlock
extends FarmBlock {
    public FertilizedFarmlandBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static void turnToSoil(@Nullable Entity entity, BlockState blockState, Level level, BlockPos blockPos) {
        BlockState blockState2 = FertilizedFarmlandBlock.pushEntitiesUp((BlockState)blockState, (BlockState)((Block)ObjectRegistry.FERTILIZED_SOIL_BLOCK.get()).defaultBlockState(), (LevelAccessor)level, (BlockPos)blockPos);
        level.setBlockAndUpdate(blockPos, blockState2);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((Entity)entity, (BlockState)blockState2));
    }

    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        return !this.defaultBlockState().canSurvive((LevelReader)blockPlaceContext.getLevel(), blockPlaceContext.getClickedPos()) ? ((Block)ObjectRegistry.FERTILIZED_SOIL_BLOCK.get()).defaultBlockState() : super.getStateForPlacement(blockPlaceContext);
    }

    public void tick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
    }

    public void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (randomSource.nextFloat() < this.getGrowthChance(serverLevel, blockPos)) {
            this.applyBonemealEffect(serverLevel, blockPos, randomSource);
        }
    }

    private float getGrowthChance(ServerLevel serverLevel, BlockPos blockPos) {
        int lightLevel = serverLevel.getMaxLocalRawBrightness(blockPos.above());
        return lightLevel >= 10 ? 0.055f : 0.05f;
    }

    private void applyBonemealEffect(ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        BonemealableBlock bonemealableBlock;
        if (PlatformHelper.isBonemealEffectEnabled()) {
            return;
        }
        BlockPos posAbove = blockPos.above();
        BlockState stateAbove = serverLevel.getBlockState(posAbove);
        Block block = stateAbove.getBlock();
        if (block instanceof BonemealableBlock && (bonemealableBlock = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)serverLevel, posAbove, stateAbove)) {
            bonemealableBlock.performBonemeal(serverLevel, randomSource, posAbove, stateAbove);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)posAbove.getX() + 0.5, (double)posAbove.getY() + 1.0, (double)posAbove.getZ() + 0.5, 5, 0.5, 0.5, 0.5, 0.5);
        }
        this.checkAndTurnToSoil(serverLevel, blockPos, serverLevel.getBlockState(blockPos));
    }

    private void checkAndTurnToSoil(ServerLevel serverLevel, BlockPos blockPos, BlockState currentBlockState) {
        if (currentBlockState.is((Block)ObjectRegistry.FERTILIZED_SOIL_BLOCK.get())) {
            FertilizedFarmlandBlock.turnToSoil(null, currentBlockState, (Level)serverLevel, blockPos);
        }
    }

    public void fallOn(Level level, BlockState blockState, BlockPos blockPos, Entity entity, float f) {
    }
}

