/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block;

import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.farm_and_charm.core.block.entity.MincerBlockEntity;
import net.satisfy.farm_and_charm.core.registry.EntityTypeRegistry;
import net.satisfy.farm_and_charm.core.registry.SoundEventRegistry;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MincerBlock
extends BaseEntityBlock {
    public static final MapCodec<MincerBlock> CODEC = MincerBlock.simpleCodec(MincerBlock::new);
    public static final int CRANKS_NEEDED = 20;
    public static final IntegerProperty CRANK = IntegerProperty.create((String)"crank", (int)0, (int)32);
    public static final IntegerProperty CRANKED = IntegerProperty.create((String)"cranked", (int)0, (int)100);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.0, (double)0.1875, (double)0.9375, (double)0.0625, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.0625, (double)0.3125, (double)0.5625, (double)0.375, (double)0.6875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.375, (double)0.25, (double)0.625, (double)0.8125, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.625, (double)0.4375, (double)0.3125, (double)0.9375, (double)0.75, (double)0.6875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.8125, (double)0.3125, (double)0.5625, (double)1.0, (double)0.6875), (BooleanOp)BooleanOp.OR);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
            map.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
        }
    });

    public MincerBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)CRANK, (Comparable)Integer.valueOf(0))).setValue((Property)CRANKED, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, CRANK, CRANKED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection());
    }

    @NotNull
    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List dropsOriginal = super.getDrops(state, builder);
        if (!dropsOriginal.isEmpty()) {
            return dropsOriginal;
        }
        return Collections.singletonList(new ItemStack((ItemLike)this, 1));
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        InteractionHand hand = player.getUsedItemHand();
        BlockEntity entity = level.getBlockEntity(pos);
        ItemStack playerStack = player.getItemInHand(hand);
        if (entity instanceof MincerBlockEntity) {
            ItemParticleOption particleOption;
            ServerLevel serverWorld;
            MincerBlockEntity mincer = (MincerBlockEntity)entity;
            if (player.isShiftKeyDown()) {
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)mincer);
                return InteractionResult.SUCCESS;
            }
            ItemStack inputStack = mincer.getItem(mincer.INPUT_SLOT);
            int crank = (Integer)state.getValue((Property)CRANK);
            int cranked = (Integer)state.getValue((Property)CRANKED);
            if (!playerStack.isEmpty() && crank == 0) {
                if (player.isCreative()) {
                    ItemStack playerStackCopy = playerStack.copy();
                    playerStackCopy.setCount(playerStackCopy.getMaxStackSize());
                    mincer.setItem(mincer.INPUT_SLOT, playerStackCopy);
                    return InteractionResult.SUCCESS;
                }
                if (mincer.canPlaceItem(mincer.INPUT_SLOT, playerStack)) {
                    if (inputStack.is(playerStack.getItem())) {
                        int countToTakeFromPlayer;
                        int countInPlayerHand = playerStack.getCount();
                        int insertableCount = inputStack.getMaxStackSize() - inputStack.getCount();
                        for (countToTakeFromPlayer = 0; countToTakeFromPlayer < insertableCount && countToTakeFromPlayer < countInPlayerHand; ++countToTakeFromPlayer) {
                        }
                        inputStack.setCount(inputStack.getCount() + countToTakeFromPlayer);
                        mincer.setItem(mincer.INPUT_SLOT, inputStack);
                        playerStack.shrink(countToTakeFromPlayer);
                    } else if (inputStack.isEmpty()) {
                        inputStack = playerStack.copy();
                        mincer.setItem(mincer.INPUT_SLOT, inputStack);
                        playerStack.shrink(playerStack.getCount());
                    }
                    return InteractionResult.SUCCESS;
                }
                if (level.isClientSide() && playerStack.getItem() instanceof BlockItem) {
                    return InteractionResult.sidedSuccess((boolean)level.isClientSide());
                }
            } else if (playerStack.isEmpty()) {
                if (cranked >= 20 && crank == 0) {
                    level.setBlock(pos, (BlockState)state.setValue((Property)CRANKED, (Comparable)Integer.valueOf(0)), 3);
                    return InteractionResult.SUCCESS;
                }
                if (level instanceof ServerLevel) {
                    serverWorld = (ServerLevel)level;
                    for (ItemStack stack : mincer.getItems()) {
                        if (stack.isEmpty() || mincer.getItem(mincer.OUTPUT_SLOT) == stack) continue;
                        particleOption = new ItemParticleOption(ParticleTypes.ITEM, stack);
                        serverWorld.sendParticles((ParticleOptions)particleOption, (double)pos.getX() + 0.5, (double)pos.getY() + 1.1, (double)pos.getZ() + 0.4, 3, 0.2, 0.1, 0.0, 0.1);
                    }
                }
                if (crank <= 6) {
                    level.setBlock(pos, (BlockState)state.setValue((Property)CRANK, (Comparable)Integer.valueOf(10)), 3);
                    level.playSound(null, pos, (SoundEvent)SoundEventRegistry.MINCER_CRANKING.get(), SoundSource.BLOCKS, 1.0f, 2.5f);
                    return InteractionResult.SUCCESS;
                }
            }
            if (cranked >= 20 && crank == 0) {
                level.setBlock(pos, (BlockState)state.setValue((Property)CRANKED, (Comparable)Integer.valueOf(0)), 3);
                return InteractionResult.SUCCESS;
            }
            if (level instanceof ServerLevel) {
                serverWorld = (ServerLevel)level;
                for (ItemStack stack : mincer.getItems()) {
                    if (stack.isEmpty() || mincer.getItem(mincer.OUTPUT_SLOT) == stack) continue;
                    particleOption = new ItemParticleOption(ParticleTypes.ITEM, stack);
                    serverWorld.sendParticles((ParticleOptions)particleOption, (double)pos.getX() + 0.5, (double)pos.getY() + 1.1, (double)pos.getZ() + 0.4, 3, 0.2, 0.1, 0.0, 0.1);
                }
            }
            if (crank <= 6) {
                level.setBlock(pos, (BlockState)state.setValue((Property)CRANK, (Comparable)Integer.valueOf(10)), 3);
                level.playSound(null, pos, (SoundEvent)SoundEventRegistry.MINCER_CRANKING.get(), SoundSource.BLOCKS, 0.05f, 2.5f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        VoxelShape shape = world.getBlockState(pos.below()).getShape((BlockGetter)world, pos.below());
        Direction direction = Direction.UP;
        return Block.isFaceFull((VoxelShape)shape, (Direction)direction);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.destroyBlock(pos, true);
        }
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.scheduleTick(pos, (Block)this, 1);
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (MenuProvider)tileEntity : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new MincerBlockEntity(pos, state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity != null && blockEntity.triggerEvent(eventID, eventParam);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof MincerBlockEntity) {
                MincerBlockEntity be = (MincerBlockEntity)blockEntity;
                for (int slot = 0; slot < be.getContainerSize(); ++slot) {
                    ItemStack stack = be.removeItem(slot, be.getItem(slot).getCount());
                    if (stack.isEmpty()) continue;
                    Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
                }
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.getValue((Property)FACING));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return MincerBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)EntityTypeRegistry.MINCER_BLOCK_ENTITY.get()), (world1, pos, state1, be) -> be.tick(world1, pos, state1, (MincerBlockEntity)be));
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)Component.translatable((String)"tooltip.farm_and_charm.canbeplaced").withStyle(ChatFormatting.GRAY));
    }
}

