/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.farm_and_charm.core.block.FacingBlock;
import net.satisfy.farm_and_charm.core.block.entity.SiloBlockEntity;
import net.satisfy.farm_and_charm.core.recipe.SiloRecipe;
import net.satisfy.farm_and_charm.core.registry.EntityTypeRegistry;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import net.satisfy.farm_and_charm.core.registry.RecipeTypeRegistry;
import net.satisfy.farm_and_charm.core.util.ConnectivityHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SiloBlock
extends FacingBlock
implements EntityBlock {
    public static final BooleanProperty TOP = BooleanProperty.create((String)"top");
    public static final BooleanProperty BOTTOM = BooleanProperty.create((String)"bottom");
    public static final BooleanProperty OPEN = BooleanProperty.create((String)"open");
    public static final EnumProperty<Shape> SHAPE = EnumProperty.create((String)"shape", Shape.class);
    static final VoxelShape CAMPFIRE_SMOKE_CLIP = Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public SiloBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TOP, (Comparable)Boolean.valueOf(true))).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(true))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue(SHAPE, (Comparable)((Object)Shape.NONE))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public static boolean isSilo(ItemStack itemStack) {
        BlockItem bi;
        Item item = itemStack.getItem();
        return item instanceof BlockItem && ((bi = (BlockItem)item).getBlock() == ObjectRegistry.SILO_WOOD.get() || bi.getBlock() == ObjectRegistry.SILO_COPPER.get());
    }

    public static boolean isSilo(BlockState state) {
        return state.getBlock() instanceof SiloBlock;
    }

    public static boolean isDryItem(Level level, ItemStack itemStack) {
        return SiloBlock.getDryItemRecipe(level, itemStack).isPresent();
    }

    public static Optional<RecipeHolder<SiloRecipe>> getDryItemRecipe(Level level, ItemStack itemStack) {
        return level.getRecipeManager().getAllRecipesFor((RecipeType)RecipeTypeRegistry.SILO_RECIPE_TYPE.get()).stream().filter(siloRecipe -> ((SiloRecipe)siloRecipe.value()).getInput().test(itemStack)).findFirst();
    }

    public Direction getFacing(BlockState state) {
        return (Direction)state.getValue((Property)FACING);
    }

    public BlockState setFacing(BlockState state, Direction facing) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)facing);
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (level.isClientSide) {
            return itemStack.isEmpty() || SiloBlock.isDryItem(level, itemStack) ? ItemInteractionResult.SUCCESS : (SiloBlock.isSilo(itemStack) || player.isDiscrete() ? ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION : ItemInteractionResult.CONSUME);
        }
        BlockEntity be = level.getBlockEntity(blockPos);
        if (be instanceof SiloBlockEntity) {
            SiloBlockEntity siloBE = (SiloBlockEntity)be;
            SiloBlockEntity siloController = (SiloBlockEntity)siloBE.getControllerBE();
            if (siloController == null) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (itemStack.isEmpty()) {
                if (player.isDiscrete()) {
                    ItemStack returnStack = siloBE.tryRemoveItem();
                    if (!returnStack.isEmpty()) {
                        player.addItem(itemStack);
                        level.playSound(null, blockPos, SoundEvents.COMPOSTER_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                } else {
                    boolean isOpen = (Boolean)blockState.getValue((Property)OPEN);
                    siloController.open(!isOpen);
                    level.playSound(null, blockPos, isOpen ? SoundEvents.IRON_TRAPDOOR_CLOSE : SoundEvents.IRON_TRAPDOOR_OPEN, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return ItemInteractionResult.SUCCESS;
            }
            if (SiloBlock.isDryItem(level, itemStack) && siloController.tryAddItem(itemStack)) {
                level.playSound(null, blockPos, SoundEvents.COMPOSTER_FILL_SUCCESS, SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return SiloBlock.isSilo(itemStack) || player.isDiscrete() ? ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION : ItemInteractionResult.CONSUME;
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (oldState.getBlock() == state.getBlock()) {
            return;
        }
        if (notify) {
            return;
        }
        BlockEntity be = world.getBlockEntity(pos);
        if (be instanceof SiloBlockEntity) {
            SiloBlockEntity siloBlockEntity = (SiloBlockEntity)be;
            siloBlockEntity.updateConnectivity();
        }
    }

    public void onRemove(BlockState blockState, Level level, BlockPos blockPos, BlockState newState, boolean moved) {
        if (blockState.hasBlockEntity() && (blockState.getBlock() != newState.getBlock() || !newState.hasBlockEntity())) {
            BlockEntity be = level.getBlockEntity(blockPos);
            if (!(be instanceof SiloBlockEntity)) {
                return;
            }
            SiloBlockEntity siloBE = (SiloBlockEntity)be;
            Containers.dropContents((Level)level, (BlockPos)blockPos, (Container)siloBE);
            level.removeBlockEntity(blockPos);
            ConnectivityHandler.splitMulti(siloBE);
        }
    }

    public boolean skipRendering(BlockState blockState, BlockState blockState2, Direction direction) {
        return blockState2.is((Block)this) || super.skipRendering(blockState, blockState2, direction);
    }

    public boolean hasAnalogOutputSignal(BlockState blockState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos blockPos) {
        return level.getBlockEntity(blockPos, (BlockEntityType)EntityTypeRegistry.SILO_BLOCK_ENTITY.get()).map(AbstractContainerMenu::getRedstoneSignalFromContainer).orElse(0);
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (context == CollisionContext.empty()) {
            return CAMPFIRE_SMOKE_CLIP;
        }
        return state.getShape(world, pos);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TOP, BOTTOM, OPEN, SHAPE, FACING});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof BlockEntityTicker) {
                ((BlockEntityTicker)blockEntity).tick(world, pos, state1, blockEntity);
            }
        };
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SiloBlockEntity(pos, state);
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        return switch (((Shape)((Object)state.getValue(SHAPE))).ordinal()) {
            case 1 -> (BlockState)state.setValue(SHAPE, (Comparable)((Object)Shape.SOUTH));
            case 2 -> (BlockState)state.setValue(SHAPE, (Comparable)((Object)Shape.SOUTH_WEST));
            case 3 -> (BlockState)state.setValue(SHAPE, (Comparable)((Object)Shape.WEST));
            case 4 -> (BlockState)state.setValue(SHAPE, (Comparable)((Object)Shape.NORTH_WEST));
            case 5 -> (BlockState)state.setValue(SHAPE, (Comparable)((Object)Shape.NORTH));
            case 6 -> (BlockState)state.setValue(SHAPE, (Comparable)((Object)Shape.NORTH_EAST));
            case 7 -> (BlockState)state.setValue(SHAPE, (Comparable)((Object)Shape.EAST));
            case 8 -> (BlockState)state.setValue(SHAPE, (Comparable)((Object)Shape.SOUTH_EAST));
            default -> state;
        };
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        for (int i = 0; i < rotation.ordinal(); ++i) {
            state = this.rotateOnce(state);
        }
        return state;
    }

    private BlockState rotateOnce(BlockState state) {
        return switch (((Shape)((Object)state.getValue(SHAPE))).ordinal()) {
            case 1 -> (BlockState)state.setValue(SHAPE, (Comparable)((Object)Shape.EAST));
            case 2 -> (BlockState)state.setValue(SHAPE, (Comparable)((Object)Shape.SOUTH_EAST));
            case 3 -> (BlockState)state.setValue(SHAPE, (Comparable)((Object)Shape.SOUTH));
            case 4 -> (BlockState)state.setValue(SHAPE, (Comparable)((Object)Shape.SOUTH_WEST));
            case 5 -> (BlockState)state.setValue(SHAPE, (Comparable)((Object)Shape.WEST));
            case 6 -> (BlockState)state.setValue(SHAPE, (Comparable)((Object)Shape.NORTH_WEST));
            case 7 -> (BlockState)state.setValue(SHAPE, (Comparable)((Object)Shape.NORTH));
            case 8 -> (BlockState)state.setValue(SHAPE, (Comparable)((Object)Shape.NORTH_EAST));
            default -> state;
        };
    }

    public static enum Shape implements StringRepresentable
    {
        NONE,
        NORTH,
        NORTH_EAST,
        EAST,
        SOUTH_EAST,
        SOUTH,
        SOUTH_WEST,
        WEST,
        NORTH_WEST;


        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase();
        }
    }
}

