/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.farm_and_charm.core.block.StorageBlock;
import net.satisfy.farm_and_charm.core.registry.StorageTypeRegistry;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class WindowSillBlock
extends StorageBlock {
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.4375, (double)1.0, (double)0.125, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.125, (double)0.5, (double)0.4375, (double)0.5, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.53125, (double)0.125, (double)0.53125, (double)0.90625, (double)0.5, (double)0.90625), (BooleanOp)BooleanOp.OR);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
        }
    });

    public WindowSillBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public boolean canInsertStack(ItemStack stack) {
        return stack.is(ItemTags.SMALL_FLOWERS);
    }

    @Override
    public ResourceLocation type() {
        return StorageTypeRegistry.WINDOW_SILL;
    }

    @Override
    public Direction[] unAllowedDirections() {
        return new Direction[]{Direction.DOWN};
    }

    @Override
    public int getSection(Float x, Float y) {
        return x.floatValue() < 0.5f ? 0 : 1;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos neighborPos = facing == Direction.DOWN ? pos.above() : pos.relative(facing.getOpposite());
        BlockState neighborState = world.getBlockState(neighborPos);
        if (neighborState.is(Blocks.GLASS_PANE) || neighborState.getBlock() instanceof IronBarsBlock) {
            return true;
        }
        if (facing == Direction.DOWN) {
            return neighborState.isFaceSturdy((BlockGetter)world, neighborPos, Direction.DOWN);
        }
        if (facing == Direction.UP) {
            return false;
        }
        return neighborState.isFaceSturdy((BlockGetter)world, neighborPos, facing);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.destroyBlock(pos, true);
        }
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.scheduleTick(pos, (Block)this, 1);
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.getValue((Property)FACING));
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)Component.translatable((String)"tooltip.farm_and_charm.canbeplacedwall").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
    }
}

