package net.satisfy.farm_and_charm.neoforge.core.config;

import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

public class FarmAndCharmNeoForgeConfig {
    public static final ModConfigSpec COMMON_CONFIG;
    public static final ModConfigSpec.BooleanValue ENABLE_BONEMEAL_EFFECT;
    public static final ModConfigSpec.IntValue FERTILIZED_SOIL_RANGE;
    public static final ModConfigSpec.IntValue WATER_SPRINKLER_RANGE;
    public static final ModConfigSpec.BooleanValue ENABLE_RAIN_GROWTH_EFFECT;
    public static final ModConfigSpec.DoubleValue RAIN_GROWTH_MULTIPLIER;
    public static final ModConfigSpec.IntValue FEEDING_TROUGH_RANGE;
    public static final ModConfigSpec.BooleanValue ENABLE_FERTILIZER;
    public static final ModConfigSpec.BooleanValue ENABLE_TAMING;
    public static final ModConfigSpec.BooleanValue ENABLE_HORSE_TAMING;
    public static final ModConfigSpec.BooleanValue ENABLE_HORSE_EFFECTS;
    public static final ModConfigSpec.BooleanValue ENABLE_CHICKEN_EFFECTS;
    public static final ModConfigSpec.BooleanValue ENABLE_CAT_TAMING_CHANCE;
    public static final ModConfigSpec.IntValue OAT_PANCAKE_NUTRITION;
    public static final ModConfigSpec.DoubleValue OAT_PANCAKE_SATURATION_MOD;
    public static final ModConfigSpec.IntValue ROASTED_CORN_NUTRITION;
    public static final ModConfigSpec.DoubleValue ROASTED_CORN_SATURATION_MOD;
    public static final ModConfigSpec.IntValue POTATO_WITH_ROAST_MEAT_NUTRITION;
    public static final ModConfigSpec.DoubleValue POTATO_WITH_ROAST_MEAT_SATURATION_MOD;
    public static final ModConfigSpec.IntValue BAKED_LAMB_HAM_NUTRITION;
    public static final ModConfigSpec.DoubleValue BAKED_LAMB_HAM_SATURATION_MOD;
    public static final ModConfigSpec.IntValue FARMERS_BREAKFAST_NUTRITION;
    public static final ModConfigSpec.DoubleValue FARMERS_BREAKFAST_SATURATION_MOD;
    public static final ModConfigSpec.IntValue STUFFED_CHICKEN_NUTRITION;
    public static final ModConfigSpec.DoubleValue STUFFED_CHICKEN_SATURATION_MOD;
    public static final ModConfigSpec.IntValue STUFFED_RABBIT_NUTRITION;
    public static final ModConfigSpec.DoubleValue STUFFED_RABBIT_SATURATION_MOD;
    public static final ModConfigSpec.IntValue GRANDMOTHERS_STRAWBERRY_CAKE_NUTRITION;
    public static final ModConfigSpec.DoubleValue GRANDMOTHERS_STRAWBERRY_CAKE_SATURATION_MOD;
    public static final ModConfigSpec.IntValue FARMERS_BREAD_NUTRITION;
    public static final ModConfigSpec.DoubleValue FARMERS_BREAD_SATURATION_MOD;
    public static final ModConfigSpec.IntValue FARMER_SALAD_NUTRITION;
    public static final ModConfigSpec.DoubleValue FARMER_SALAD_SATURATION_MOD;
    public static final ModConfigSpec.IntValue GOULASH_NUTRITION;
    public static final ModConfigSpec.DoubleValue GOULASH_SATURATION_MOD;
    public static final ModConfigSpec.IntValue SIMPLE_TOMATO_SOUP_NUTRITION;
    public static final ModConfigSpec.DoubleValue SIMPLE_TOMATO_SOUP_SATURATION_MOD;
    public static final ModConfigSpec.IntValue BARLEY_SOUP_NUTRITION;
    public static final ModConfigSpec.DoubleValue BARLEY_SOUP_SATURATION_MOD;
    public static final ModConfigSpec.IntValue ONION_SOUP_NUTRITION;
    public static final ModConfigSpec.DoubleValue ONION_SOUP_SATURATION_MOD;
    public static final ModConfigSpec.IntValue POTATO_SOUP_NUTRITION;
    public static final ModConfigSpec.DoubleValue POTATO_SOUP_SATURATION_MOD;
    public static final ModConfigSpec.IntValue PASTA_WITH_ONION_SAUCE_NUTRITION;
    public static final ModConfigSpec.DoubleValue PASTA_WITH_ONION_SAUCE_SATURATION_MOD;
    public static final ModConfigSpec.IntValue CORN_GRITS_NUTRITION;
    public static final ModConfigSpec.DoubleValue CORN_GRITS_SATURATION_MOD;
    public static final ModConfigSpec.IntValue OATMEAL_WITH_STRAWBERRIES_NUTRITION;
    public static final ModConfigSpec.DoubleValue OATMEAL_WITH_STRAWBERRIES_SATURATION_MOD;
    public static final ModConfigSpec.IntValue SAUSAGE_WITH_OAT_PATTY_NUTRITION;
    public static final ModConfigSpec.DoubleValue SAUSAGE_WITH_OAT_PATTY_SATURATION_MOD;
    public static final ModConfigSpec.IntValue LAMB_WITH_CORN_NUTRITION;
    public static final ModConfigSpec.DoubleValue LAMB_WITH_CORN_SATURATION_MOD;
    public static final ModConfigSpec.IntValue BEEF_PATTY_WITH_VEGETABLES_NUTRITION;
    public static final ModConfigSpec.DoubleValue BEEF_PATTY_WITH_VEGETABLES_SATURATION_MOD;
    public static final ModConfigSpec.IntValue BARLEY_PATTIES_WITH_POTATOES_NUTRITION;
    public static final ModConfigSpec.DoubleValue BARLEY_PATTIES_WITH_POTATOES_SATURATION_MOD;
    public static final ModConfigSpec.IntValue BACON_WITH_EGGS_NUTRITION;
    public static final ModConfigSpec.DoubleValue BACON_WITH_EGGS_SATURATION_MOD;
    public static final ModConfigSpec.IntValue CHICKEN_WRAPPED_IN_BACON_NUTRITION;
    public static final ModConfigSpec.DoubleValue CHICKEN_WRAPPED_IN_BACON_SATURATION_MOD;
    public static final ModConfigSpec.IntValue COOKED_SALMON_NUTRITION;
    public static final ModConfigSpec.DoubleValue COOKED_SALMON_SATURATION_MOD;
    public static final ModConfigSpec.IntValue COOKED_COD_NUTRITION;
    public static final ModConfigSpec.DoubleValue COOKED_COD_SATURATION_MOD;
    public static final ModConfigSpec.IntValue ROASTED_CHICKEN_NUTRITION;
    public static final ModConfigSpec.DoubleValue ROASTED_CHICKEN_SATURATION_MOD;
    public static final ModConfigSpec.IntValue CHICKEN_EFFECT_TICK_INTERVAL;
    public static final ModConfigSpec.IntValue CHICKEN_EFFECT_EGG_CHANCE;
    public static final ModConfigSpec.IntValue CHICKEN_EFFECT_FEATHER_CHANCE;
    public static final ModConfigSpec.IntValue FEAST_EFFECT_SATIATION_INTERVAL;
    public static final ModConfigSpec.IntValue FEAST_EFFECT_SUSTENANCE_INTERVAL;
    public static final ModConfigSpec.IntValue FEAST_EFFECT_HEAL_AMOUNT;
    public static final ModConfigSpec.IntValue SUSTENANCE_EFFECT_INTERVAL;
    public static final ModConfigSpec.IntValue SUSTENANCE_EFFECT_HEAL_AMOUNT;
    public static final ModConfigSpec.IntValue SUSTENANCE_EFFECT_FOOD_INCREMENT;
    public static final ModConfigSpec.IntValue SATIATION_EFFECT_INTERVAL;
    public static final ModConfigSpec.IntValue SATIATION_EFFECT_HEAL_AMOUNT;

    public static boolean enableBonemealEffect = true;
    public static int fertilizedSoilRange = 5;
    public static int waterSprinklerRange = 8;
    public static boolean enableRainGrowthEffect = true;
    public static double rainGrowthMultiplier = 0.5;
    public static int feedingTroughRange = 8;
    public static boolean enableFertilizer = true;
    public static boolean enableTaming = true;
    public static boolean enableHorseTaming = true;
    public static boolean enableHorseEffects = true;
    public static boolean enableChickenEffects = true;
    public static boolean enableCatTamingChance = true;

    public static int oatPancakeNutrition = 5;
    public static double oatPancakeSaturationMod = 0.6;
    public static int roastedCornNutrition = 5;
    public static double roastedCornSaturationMod = 0.5;
    public static int potatoWithRoastMeatNutrition = 7;
    public static double potatoWithRoastMeatSaturationMod = 0.7;
    public static int bakedLambHamNutrition = 8;
    public static double bakedLambHamSaturationMod = 0.9;
    public static int farmersBreakfastNutrition = 12;
    public static double farmersBreakfastSaturationMod = 1.2;
    public static int stuffedChickenNutrition = 8;
    public static double stuffedChickenSaturationMod = 0.8;
    public static int stuffedRabbitNutrition = 9;
    public static double stuffedRabbitSaturationMod = 0.9;
    public static int grandmothersStrawberryCakeNutrition = 4;
    public static double grandmothersStrawberryCakeSaturationMod = 0.7;
    public static int farmersBreadNutrition = 6;
    public static double farmersBreadSaturationMod = 0.8;
    public static int farmerSaladNutrition = 7;
    public static double farmerSaladSaturationMod = 0.6;
    public static int goulashNutrition = 8;
    public static double goulashSaturationMod = 0.9;
    public static int simpleTomatoSoupNutrition = 6;
    public static double simpleTomatoSoupSaturationMod = 0.6;
    public static int barleySoupNutrition = 5;
    public static double barleySoupSaturationMod = 0.8;
    public static int onionSoupNutrition = 7;
    public static double onionSoupSaturationMod = 0.6;
    public static int potatoSoupNutrition = 5;
    public static double potatoSoupSaturationMod = 0.6;
    public static int pastaWithOnionSauceNutrition = 6;
    public static double pastaWithOnionSauceSaturationMod = 0.7;
    public static int cornGritsNutrition = 6;
    public static double cornGritsSaturationMod = 0.5;
    public static int oatmealWithStrawberriesNutrition = 4;
    public static double oatmealWithStrawberriesSaturationMod = 0.8;
    public static int sausageWithOatPattyNutrition = 8;
    public static double sausageWithOatPattySaturationMod = 0.9;
    public static int lambWithCornNutrition = 8;
    public static double lambWithCornSaturationMod = 0.8;
    public static int beefPattyWithVegetablesNutrition = 6;
    public static double beefPattyWithVegetablesSaturationMod = 0.8;
    public static int barleyPattiesWithPotatoesNutrition = 5;
    public static double barleyPattiesWithPotatoesSaturationMod = 0.9;
    public static int baconWithEggsNutrition = 6;
    public static double baconWithEggsSaturationMod = 0.7;
    public static int chickenWrappedInBaconNutrition = 9;
    public static double chickenWrappedInBaconSaturationMod = 0.9;
    public static int cookedSalmonNutrition = 7;
    public static double cookedSalmonSaturationMod = 0.9;
    public static int cookedCodNutrition = 7;
    public static double cookedCodSaturationMod = 0.9;
    public static int roastedChickenNutrition = 5;
    public static double roastedChickenSaturationMod = 0.8;

    public static int chickenEffectTickInterval = 120;
    public static int chickenEffectEggChance = 20;
    public static int chickenEffectFeatherChance = 20;
    public static int feastEffectSatiationInterval = 40;
    public static int feastEffectSustenanceInterval = 200;
    public static int feastEffectHealAmount = 1;
    public static int sustenanceEffectInterval = 200;
    public static int sustenanceEffectHealAmount = 1;
    public static int sustenanceEffectFoodIncrement = 1;
    public static int satiationEffectInterval = 40;
    public static int satiationEffectHealAmount = 1;

    static {
        ModConfigSpec.Builder COMMON_BUILDER = new ModConfigSpec.Builder();
        COMMON_BUILDER.push("Blocks");
        ENABLE_BONEMEAL_EFFECT = COMMON_BUILDER.define("enableBonemealEffect", true);
        FERTILIZED_SOIL_RANGE = COMMON_BUILDER.defineInRange("fertilizedSoilRange", 5, 1, 16);
        WATER_SPRINKLER_RANGE = COMMON_BUILDER.defineInRange("waterSprinklerRange", 8, 1, 32);
        ENABLE_RAIN_GROWTH_EFFECT = COMMON_BUILDER.define("enableRainGrowthEffect", true);
        RAIN_GROWTH_MULTIPLIER = COMMON_BUILDER.defineInRange("rainGrowthMultiplier", 0.5, 0.1, 2.0);
        FEEDING_TROUGH_RANGE = COMMON_BUILDER.defineInRange("feedingTroughRange", 8, 1, 16);
        COMMON_BUILDER.pop();

        COMMON_BUILDER.push("Items");
        ENABLE_FERTILIZER = COMMON_BUILDER.define("enableFertilizer", true);
        ENABLE_TAMING = COMMON_BUILDER.define("enableDogFoodTaming", true);
        ENABLE_HORSE_TAMING = COMMON_BUILDER.define("enableHorseTaming", true);
        ENABLE_HORSE_EFFECTS = COMMON_BUILDER.define("enableHorseEffects", true);
        ENABLE_CHICKEN_EFFECTS = COMMON_BUILDER.define("enableChickenEffects", true);
        ENABLE_CAT_TAMING_CHANCE = COMMON_BUILDER.define("enableCatTamingChance", true);

        COMMON_BUILDER.push("Nutrition");
        OAT_PANCAKE_NUTRITION = COMMON_BUILDER.defineInRange("oatPancakeNutrition", 5, 0, Integer.MAX_VALUE);
        OAT_PANCAKE_SATURATION_MOD = COMMON_BUILDER.defineInRange("oatPancakeSaturationMod", 0.6, 0.0, Double.MAX_VALUE);
        ROASTED_CORN_NUTRITION = COMMON_BUILDER.defineInRange("roastedCornNutrition", 5, 0, Integer.MAX_VALUE);
        ROASTED_CORN_SATURATION_MOD = COMMON_BUILDER.defineInRange("roastedCornSaturationMod", 0.5, 0.0, Double.MAX_VALUE);
        POTATO_WITH_ROAST_MEAT_NUTRITION = COMMON_BUILDER.defineInRange("potatoWithRoastMeatNutrition", 7, 0, Integer.MAX_VALUE);
        POTATO_WITH_ROAST_MEAT_SATURATION_MOD = COMMON_BUILDER.defineInRange("potatoWithRoastMeatSaturationMod", 0.7, 0.0, Double.MAX_VALUE);
        BAKED_LAMB_HAM_NUTRITION = COMMON_BUILDER.defineInRange("bakedLambHamNutrition", 8, 0, Integer.MAX_VALUE);
        BAKED_LAMB_HAM_SATURATION_MOD = COMMON_BUILDER.defineInRange("bakedLambHamSaturationMod", 0.9, 0.0, Double.MAX_VALUE);
        FARMERS_BREAKFAST_NUTRITION = COMMON_BUILDER.defineInRange("farmersBreakfastNutrition", 12, 0, Integer.MAX_VALUE);
        FARMERS_BREAKFAST_SATURATION_MOD = COMMON_BUILDER.defineInRange("farmersBreakfastSaturationMod", 1.2, 0.0, Double.MAX_VALUE);
        STUFFED_CHICKEN_NUTRITION = COMMON_BUILDER.defineInRange("stuffedChickenNutrition", 8, 0, Integer.MAX_VALUE);
        STUFFED_CHICKEN_SATURATION_MOD = COMMON_BUILDER.defineInRange("stuffedChickenSaturationMod", 0.8, 0.0, Double.MAX_VALUE);
        STUFFED_RABBIT_NUTRITION = COMMON_BUILDER.defineInRange("stuffedRabbitNutrition", 9, 0, Integer.MAX_VALUE);
        STUFFED_RABBIT_SATURATION_MOD = COMMON_BUILDER.defineInRange("stuffedRabbitSaturationMod", 0.9, 0.0, Double.MAX_VALUE);
        GRANDMOTHERS_STRAWBERRY_CAKE_NUTRITION = COMMON_BUILDER.defineInRange("grandmothersStrawberryCakeNutrition", 4, 0, Integer.MAX_VALUE);
        GRANDMOTHERS_STRAWBERRY_CAKE_SATURATION_MOD = COMMON_BUILDER.defineInRange("grandmothersStrawberryCakeSaturationMod", 0.7, 0.0, Double.MAX_VALUE);
        FARMERS_BREAD_NUTRITION = COMMON_BUILDER.defineInRange("farmersBreadNutrition", 6, 0, Integer.MAX_VALUE);
        FARMERS_BREAD_SATURATION_MOD = COMMON_BUILDER.defineInRange("farmersBreadSaturationMod", 0.8, 0.0, Double.MAX_VALUE);
        FARMER_SALAD_NUTRITION = COMMON_BUILDER.defineInRange("farmerSaladNutrition", 7, 0, Integer.MAX_VALUE);
        FARMER_SALAD_SATURATION_MOD = COMMON_BUILDER.defineInRange("farmerSaladSaturationMod", 0.6, 0.0, Double.MAX_VALUE);
        GOULASH_NUTRITION = COMMON_BUILDER.defineInRange("goulashNutrition", 8, 0, Integer.MAX_VALUE);
        GOULASH_SATURATION_MOD = COMMON_BUILDER.defineInRange("goulashSaturationMod", 0.9, 0.0, Double.MAX_VALUE);
        SIMPLE_TOMATO_SOUP_NUTRITION = COMMON_BUILDER.defineInRange("simpleTomatoSoupNutrition", 6, 0, Integer.MAX_VALUE);
        SIMPLE_TOMATO_SOUP_SATURATION_MOD = COMMON_BUILDER.defineInRange("simpleTomatoSoupSaturationMod", 0.6, 0.0, Double.MAX_VALUE);
        BARLEY_SOUP_NUTRITION = COMMON_BUILDER.defineInRange("barleySoupNutrition", 5, 0, Integer.MAX_VALUE);
        BARLEY_SOUP_SATURATION_MOD = COMMON_BUILDER.defineInRange("barleySoupSaturationMod", 0.8, 0.0, Double.MAX_VALUE);
        ONION_SOUP_NUTRITION = COMMON_BUILDER.defineInRange("onionSoupNutrition", 7, 0, Integer.MAX_VALUE);
        ONION_SOUP_SATURATION_MOD = COMMON_BUILDER.defineInRange("onionSoupSaturationMod", 0.6, 0.0, Double.MAX_VALUE);
        POTATO_SOUP_NUTRITION = COMMON_BUILDER.defineInRange("potatoSoupNutrition", 5, 0, Integer.MAX_VALUE);
        POTATO_SOUP_SATURATION_MOD = COMMON_BUILDER.defineInRange("potatoSoupSaturationMod", 0.6, 0.0, Double.MAX_VALUE);
        PASTA_WITH_ONION_SAUCE_NUTRITION = COMMON_BUILDER.defineInRange("pastaWithOnionSauceNutrition", 6, 0, Integer.MAX_VALUE);
        PASTA_WITH_ONION_SAUCE_SATURATION_MOD = COMMON_BUILDER.defineInRange("pastaWithOnionSauceSaturationMod", 0.7, 0.0, Double.MAX_VALUE);
        CORN_GRITS_NUTRITION = COMMON_BUILDER.defineInRange("cornGritsNutrition", 6, 0, Integer.MAX_VALUE);
        CORN_GRITS_SATURATION_MOD = COMMON_BUILDER.defineInRange("cornGritsSaturationMod", 0.5, 0.0, Double.MAX_VALUE);
        OATMEAL_WITH_STRAWBERRIES_NUTRITION = COMMON_BUILDER.defineInRange("oatmealWithStrawberriesNutrition", 4, 0, Integer.MAX_VALUE);
        OATMEAL_WITH_STRAWBERRIES_SATURATION_MOD = COMMON_BUILDER.defineInRange("oatmealWithStrawberriesSaturationMod", 0.8, 0.0, Double.MAX_VALUE);
        SAUSAGE_WITH_OAT_PATTY_NUTRITION = COMMON_BUILDER.defineInRange("sausageWithOatPattyNutrition", 8, 0, Integer.MAX_VALUE);
        SAUSAGE_WITH_OAT_PATTY_SATURATION_MOD = COMMON_BUILDER.defineInRange("sausageWithOatPattySaturationMod", 0.9, 0.0, Double.MAX_VALUE);
        LAMB_WITH_CORN_NUTRITION = COMMON_BUILDER.defineInRange("lambWithCornNutrition", 8, 0, Integer.MAX_VALUE);
        LAMB_WITH_CORN_SATURATION_MOD = COMMON_BUILDER.defineInRange("lambWithCornSaturationMod", 0.8, 0.0, Double.MAX_VALUE);
        BEEF_PATTY_WITH_VEGETABLES_NUTRITION = COMMON_BUILDER.defineInRange("beefPattyWithVegetablesNutrition", 6, 0, Integer.MAX_VALUE);
        BEEF_PATTY_WITH_VEGETABLES_SATURATION_MOD = COMMON_BUILDER.defineInRange("beefPattyWithVegetablesSaturationMod", 0.8, 0.0, Double.MAX_VALUE);
        BARLEY_PATTIES_WITH_POTATOES_NUTRITION = COMMON_BUILDER.defineInRange("barleyPattiesWithPotatoesNutrition", 5, 0, Integer.MAX_VALUE);
        BARLEY_PATTIES_WITH_POTATOES_SATURATION_MOD = COMMON_BUILDER.defineInRange("barleyPattiesWithPotatoesSaturationMod", 0.9, 0.0, Double.MAX_VALUE);
        BACON_WITH_EGGS_NUTRITION = COMMON_BUILDER.defineInRange("baconWithEggsNutrition", 6, 0, Integer.MAX_VALUE);
        BACON_WITH_EGGS_SATURATION_MOD = COMMON_BUILDER.defineInRange("baconWithEggsSaturationMod", 0.7, 0.0, Double.MAX_VALUE);
        CHICKEN_WRAPPED_IN_BACON_NUTRITION = COMMON_BUILDER.defineInRange("chickenWrappedInBaconNutrition", 9, 0, Integer.MAX_VALUE);
        CHICKEN_WRAPPED_IN_BACON_SATURATION_MOD = COMMON_BUILDER.defineInRange("chickenWrappedInBaconSaturationMod", 0.9, 0.0, Double.MAX_VALUE);
        COOKED_SALMON_NUTRITION = COMMON_BUILDER.defineInRange("cookedSalmonNutrition", 7, 0, Integer.MAX_VALUE);
        COOKED_SALMON_SATURATION_MOD = COMMON_BUILDER.defineInRange("cookedSalmonSaturationMod", 0.9, 0.0, Double.MAX_VALUE);
        COOKED_COD_NUTRITION = COMMON_BUILDER.defineInRange("cookedCodNutrition", 7, 0, Integer.MAX_VALUE);
        COOKED_COD_SATURATION_MOD = COMMON_BUILDER.defineInRange("cookedCodSaturationMod", 0.9, 0.0, Double.MAX_VALUE);
        ROASTED_CHICKEN_NUTRITION = COMMON_BUILDER.defineInRange("roastedChickenNutrition", 5, 0, Integer.MAX_VALUE);
        ROASTED_CHICKEN_SATURATION_MOD = COMMON_BUILDER.defineInRange("roastedChickenSaturationMod", 0.8, 0.0, Double.MAX_VALUE);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.pop();

        COMMON_BUILDER.push("Effects");
        CHICKEN_EFFECT_TICK_INTERVAL = COMMON_BUILDER.defineInRange("chickenEffectTickInterval", 120, 10, 600);
        CHICKEN_EFFECT_EGG_CHANCE = COMMON_BUILDER.defineInRange("chickenEffectEggChance", 20, 0, 100);
        CHICKEN_EFFECT_FEATHER_CHANCE = COMMON_BUILDER.defineInRange("chickenEffectFeatherChance", 20, 0, 100);
        FEAST_EFFECT_SATIATION_INTERVAL = COMMON_BUILDER.defineInRange("feastEffectSatiationInterval", 40, 10, 200);
        FEAST_EFFECT_SUSTENANCE_INTERVAL = COMMON_BUILDER.defineInRange("feastEffectSustenanceInterval", 200, 50, 600);
        FEAST_EFFECT_HEAL_AMOUNT = COMMON_BUILDER.defineInRange("feastEffectHealAmount", 1, 1, 5);
        SUSTENANCE_EFFECT_INTERVAL = COMMON_BUILDER.defineInRange("sustenanceEffectInterval", 200, 50, 600);
        SUSTENANCE_EFFECT_HEAL_AMOUNT = COMMON_BUILDER.defineInRange("sustenanceEffectHealAmount", 1, 1, 5);
        SUSTENANCE_EFFECT_FOOD_INCREMENT = COMMON_BUILDER.defineInRange("sustenanceEffectFoodIncrement", 1, 1, 20);
        SATIATION_EFFECT_INTERVAL = COMMON_BUILDER.defineInRange("satiationEffectInterval", 40, 10, 200);
        SATIATION_EFFECT_HEAL_AMOUNT = COMMON_BUILDER.defineInRange("satiationEffectHealAmount", 1, 1, 5);
        COMMON_BUILDER.pop();

        COMMON_CONFIG = COMMON_BUILDER.build();
    }

    public static void onLoad(ModConfigEvent.Loading event) {
        sync();
    }

    public static void onReload(ModConfigEvent.Reloading event) {
        sync();
    }

    public static void sync() {
        enableBonemealEffect = ENABLE_BONEMEAL_EFFECT.get();
        fertilizedSoilRange = FERTILIZED_SOIL_RANGE.get();
        waterSprinklerRange = WATER_SPRINKLER_RANGE.get();
        enableRainGrowthEffect = ENABLE_RAIN_GROWTH_EFFECT.get();
        rainGrowthMultiplier = RAIN_GROWTH_MULTIPLIER.get();
        feedingTroughRange = FEEDING_TROUGH_RANGE.get();
        enableFertilizer = ENABLE_FERTILIZER.get();
        enableTaming = ENABLE_TAMING.get();
        enableHorseTaming = ENABLE_HORSE_TAMING.get();
        enableHorseEffects = ENABLE_HORSE_EFFECTS.get();
        enableChickenEffects = ENABLE_CHICKEN_EFFECTS.get();
        enableCatTamingChance = ENABLE_CAT_TAMING_CHANCE.get();

        oatPancakeNutrition = OAT_PANCAKE_NUTRITION.get();
        oatPancakeSaturationMod = OAT_PANCAKE_SATURATION_MOD.get();
        roastedCornNutrition = ROASTED_CORN_NUTRITION.get();
        roastedCornSaturationMod = ROASTED_CORN_SATURATION_MOD.get();
        potatoWithRoastMeatNutrition = POTATO_WITH_ROAST_MEAT_NUTRITION.get();
        potatoWithRoastMeatSaturationMod = POTATO_WITH_ROAST_MEAT_SATURATION_MOD.get();
        bakedLambHamNutrition = BAKED_LAMB_HAM_NUTRITION.get();
        bakedLambHamSaturationMod = BAKED_LAMB_HAM_SATURATION_MOD.get();
        farmersBreakfastNutrition = FARMERS_BREAKFAST_NUTRITION.get();
        farmersBreakfastSaturationMod = FARMERS_BREAKFAST_SATURATION_MOD.get();
        stuffedChickenNutrition = STUFFED_CHICKEN_NUTRITION.get();
        stuffedChickenSaturationMod = STUFFED_CHICKEN_SATURATION_MOD.get();
        stuffedRabbitNutrition = STUFFED_RABBIT_NUTRITION.get();
        stuffedRabbitSaturationMod = STUFFED_RABBIT_SATURATION_MOD.get();
        grandmothersStrawberryCakeNutrition = GRANDMOTHERS_STRAWBERRY_CAKE_NUTRITION.get();
        grandmothersStrawberryCakeSaturationMod = GRANDMOTHERS_STRAWBERRY_CAKE_SATURATION_MOD.get();
        farmersBreadNutrition = FARMERS_BREAD_NUTRITION.get();
        farmersBreadSaturationMod = FARMERS_BREAD_SATURATION_MOD.get();
        farmerSaladNutrition = FARMER_SALAD_NUTRITION.get();
        farmerSaladSaturationMod = FARMER_SALAD_SATURATION_MOD.get();
        goulashNutrition = GOULASH_NUTRITION.get();
        goulashSaturationMod = GOULASH_SATURATION_MOD.get();
        simpleTomatoSoupNutrition = SIMPLE_TOMATO_SOUP_NUTRITION.get();
        simpleTomatoSoupSaturationMod = SIMPLE_TOMATO_SOUP_SATURATION_MOD.get();
        barleySoupNutrition = BARLEY_SOUP_NUTRITION.get();
        barleySoupSaturationMod = BARLEY_SOUP_SATURATION_MOD.get();
        onionSoupNutrition = ONION_SOUP_NUTRITION.get();
        onionSoupSaturationMod = ONION_SOUP_SATURATION_MOD.get();
        potatoSoupNutrition = POTATO_SOUP_NUTRITION.get();
        potatoSoupSaturationMod = POTATO_SOUP_SATURATION_MOD.get();
        pastaWithOnionSauceNutrition = PASTA_WITH_ONION_SAUCE_NUTRITION.get();
        pastaWithOnionSauceSaturationMod = PASTA_WITH_ONION_SAUCE_SATURATION_MOD.get();
        cornGritsNutrition = CORN_GRITS_NUTRITION.get();
        cornGritsSaturationMod = CORN_GRITS_SATURATION_MOD.get();
        oatmealWithStrawberriesNutrition = OATMEAL_WITH_STRAWBERRIES_NUTRITION.get();
        oatmealWithStrawberriesSaturationMod = OATMEAL_WITH_STRAWBERRIES_SATURATION_MOD.get();
        sausageWithOatPattyNutrition = SAUSAGE_WITH_OAT_PATTY_NUTRITION.get();
        sausageWithOatPattySaturationMod = SAUSAGE_WITH_OAT_PATTY_SATURATION_MOD.get();
        lambWithCornNutrition = LAMB_WITH_CORN_NUTRITION.get();
        lambWithCornSaturationMod = LAMB_WITH_CORN_SATURATION_MOD.get();
        beefPattyWithVegetablesNutrition = BEEF_PATTY_WITH_VEGETABLES_NUTRITION.get();
        beefPattyWithVegetablesSaturationMod = BEEF_PATTY_WITH_VEGETABLES_SATURATION_MOD.get();
        barleyPattiesWithPotatoesNutrition = BARLEY_PATTIES_WITH_POTATOES_NUTRITION.get();
        barleyPattiesWithPotatoesSaturationMod = BARLEY_PATTIES_WITH_POTATOES_SATURATION_MOD.get();
        baconWithEggsNutrition = BACON_WITH_EGGS_NUTRITION.get();
        baconWithEggsSaturationMod = BACON_WITH_EGGS_SATURATION_MOD.get();
        chickenWrappedInBaconNutrition = CHICKEN_WRAPPED_IN_BACON_NUTRITION.get();
        chickenWrappedInBaconSaturationMod = CHICKEN_WRAPPED_IN_BACON_SATURATION_MOD.get();
        cookedSalmonNutrition = COOKED_SALMON_NUTRITION.get();
        cookedSalmonSaturationMod = COOKED_SALMON_SATURATION_MOD.get();
        cookedCodNutrition = COOKED_COD_NUTRITION.get();
        cookedCodSaturationMod = COOKED_COD_SATURATION_MOD.get();
        roastedChickenNutrition = ROASTED_CHICKEN_NUTRITION.get();
        roastedChickenSaturationMod = ROASTED_CHICKEN_SATURATION_MOD.get();

        chickenEffectTickInterval = CHICKEN_EFFECT_TICK_INTERVAL.get();
        chickenEffectEggChance = CHICKEN_EFFECT_EGG_CHANCE.get();
        chickenEffectFeatherChance = CHICKEN_EFFECT_FEATHER_CHANCE.get();
        feastEffectSatiationInterval = FEAST_EFFECT_SATIATION_INTERVAL.get();
        feastEffectSustenanceInterval = FEAST_EFFECT_SUSTENANCE_INTERVAL.get();
        feastEffectHealAmount = FEAST_EFFECT_HEAL_AMOUNT.get();
        sustenanceEffectInterval = SUSTENANCE_EFFECT_INTERVAL.get();
        sustenanceEffectHealAmount = SUSTENANCE_EFFECT_HEAL_AMOUNT.get();
        sustenanceEffectFoodIncrement = SUSTENANCE_EFFECT_FOOD_INCREMENT.get();
        satiationEffectInterval = SATIATION_EFFECT_INTERVAL.get();
        satiationEffectHealAmount = SATIATION_EFFECT_HEAL_AMOUNT.get();
    }
}
