/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.farm_and_charm.client.model.CraftingBowlModel;
import net.satisfy.farm_and_charm.core.block.CraftingBowlBlock;
import net.satisfy.farm_and_charm.core.block.entity.CraftingBowlBlockEntity;

public class CraftingBowlRenderer
implements BlockEntityRenderer<CraftingBowlBlockEntity> {
    private final ModelPart bowl;
    private final ModelPart swing;

    public CraftingBowlRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(CraftingBowlModel.LAYER_LOCATION);
        this.bowl = root.getChild("bowl");
        this.swing = root.getChild("swing");
    }

    public void render(CraftingBowlBlockEntity blockEntity, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j) {
        Level level = blockEntity.getLevel();
        assert (level != null);
        BlockState blockState = level.getBlockState(blockEntity.getBlockPos());
        if (!(blockState.getBlock() instanceof CraftingBowlBlock)) {
            return;
        }
        poseStack.pushPose();
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        poseStack.translate(0.5f, -1.5f, -0.5f);
        ResourceLocation location = blockEntity.getStirringProgress() >= 50 ? ResourceLocation.fromNamespaceAndPath((String)"farm_and_charm", (String)"textures/entity/crafting_bowl_full.png") : ResourceLocation.fromNamespaceAndPath((String)"farm_and_charm", (String)"textures/entity/crafting_bowl.png");
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)location));
        this.bowl.render(poseStack, vertexConsumer, i, j);
        if ((Integer)level.getBlockState(blockEntity.getBlockPos()).getValue((Property)CraftingBowlBlock.STIRRING) > 0) {
            poseStack.mulPose(Axis.YP.rotation((float)(System.currentTimeMillis() % 100000L) / 100.0f % 360.0f));
        }
        this.swing.render(poseStack, vertexConsumer, i, j);
        this.renderItems(poseStack, multiBufferSource, blockEntity.getItems(), i, j);
        poseStack.popPose();
    }

    private void renderItems(PoseStack poseStack, MultiBufferSource multiBufferSource, NonNullList<ItemStack> items, int i, int j) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        LocalPlayer player = Minecraft.getInstance().player;
        poseStack.translate(0.0f, 1.25f, 0.0f);
        poseStack.scale(0.35f, 0.35f, 0.35f);
        float offset = 0.26f;
        poseStack.translate(-offset, 0.1f, -offset);
        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        itemRenderer.renderStatic((LivingEntity)player, (ItemStack)items.get(0), ItemDisplayContext.FIXED, false, poseStack, multiBufferSource, (Level)Minecraft.getInstance().level, i, j, 0);
        poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        poseStack.translate(2.0f * offset, 0.1f, 0.0f);
        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        itemRenderer.renderStatic((LivingEntity)player, (ItemStack)items.get(1), ItemDisplayContext.FIXED, false, poseStack, multiBufferSource, (Level)Minecraft.getInstance().level, i, j, 0);
        poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        poseStack.translate(0.0f, 0.1f, 2.0f * offset);
        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        itemRenderer.renderStatic((LivingEntity)player, (ItemStack)items.get(2), ItemDisplayContext.FIXED, false, poseStack, multiBufferSource, (Level)Minecraft.getInstance().level, i, j, 0);
        poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        poseStack.translate(-2.0f * offset, 0.1f, 0.0f);
        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        itemRenderer.renderStatic((LivingEntity)player, (ItemStack)items.get(3), ItemDisplayContext.FIXED, false, poseStack, multiBufferSource, (Level)Minecraft.getInstance().level, i, j, 0);
        poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
    }
}

