/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.farm_and_charm.core.block.entity.ChickenCoopBlockEntity;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChickenCoopBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final IntegerProperty EGGS = IntegerProperty.create((String)"eggs", (int)0, (int)3);
    public static final MapCodec<ChickenCoopBlock> CODEC = ChickenCoopBlock.simpleCodec(ChickenCoopBlock::new);

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public ChickenCoopBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)EGGS, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue((Property)EGGS, (Comparable)Integer.valueOf(0));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, EGGS});
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ChickenCoopBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : (lvl, pos, st, be) -> {
            if (be instanceof ChickenCoopBlockEntity) {
                int stage;
                ChickenCoopBlockEntity coop = (ChickenCoopBlockEntity)be;
                ChickenCoopBlockEntity.tick(lvl, pos, coop);
                int eggCount = coop.getEggCount();
                int n = eggCount >= 7 ? 3 : (eggCount >= 4 ? 2 : (stage = eggCount >= 1 ? 1 : 0));
                if ((Integer)lvl.getBlockState(pos).getValue((Property)EGGS) != stage) {
                    lvl.setBlock(pos, (BlockState)lvl.getBlockState(pos).setValue((Property)EGGS, (Comparable)Integer.valueOf(stage)), 2);
                }
            }
        };
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    @NotNull
    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity be;
        if (!level.isClientSide && (be = level.getBlockEntity(pos)) instanceof ChickenCoopBlockEntity) {
            boolean hasNbt;
            ChickenCoopBlockEntity coop = (ChickenCoopBlockEntity)be;
            boolean bl = hasNbt = !coop.getStoredChickens().isEmpty() || coop.getEggCount() > 0;
            if (hasNbt || !player.isCreative()) {
                ItemStack stack = new ItemStack((ItemLike)ObjectRegistry.CHICKEN_COOP_ITEM.get());
                if (hasNbt) {
                    CompoundTag tag = new CompoundTag();
                    coop.saveAdditional(tag, (HolderLookup.Provider)level.registryAccess());
                    stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)tag));
                }
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack heldItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        BlockEntity be;
        if (!level.isClientSide && (be = level.getBlockEntity(pos)) instanceof ChickenCoopBlockEntity) {
            ChickenCoopBlockEntity coop = (ChickenCoopBlockEntity)be;
            if (heldItem.is((Item)ObjectRegistry.PITCHFORK.get()) && !coop.getStoredChickens().isEmpty()) {
                coop.releaseAllChickens();
                level.playSound(null, pos, SoundEvents.ANVIL_FALL, player.getSoundSource(), 1.0f, 1.1f);
                level.playSound(null, pos, SoundEvents.CHICKEN_HURT, player.getSoundSource(), 0.325f, 0.825f);
                level.playSound(null, pos, SoundEvents.BEEHIVE_EXIT, player.getSoundSource(), 0.7f, 1.1f);
                return ItemInteractionResult.SUCCESS;
            }
            int eggCount = coop.getEggCount();
            if (eggCount > 0) {
                player.addItem(Items.EGG.getDefaultInstance().copyWithCount(eggCount));
                coop.clearEggs();
                coop.setChanged();
                level.setBlock(pos, (BlockState)state.setValue((Property)EGGS, (Comparable)Integer.valueOf(0)), 2);
                return ItemInteractionResult.SUCCESS;
            }
            if (coop.hasSpaceForChicken()) {
                for (Chicken chicken : level.getEntitiesOfClass(Chicken.class, new AABB(pos).inflate(7.0))) {
                    if (!chicken.isLeashed() || chicken.getLeashHolder() != player || !chicken.isAlive()) continue;
                    coop.addChicken(chicken);
                    chicken.dropLeash(true, true);
                    level.playSound(null, pos, SoundEvents.BEEHIVE_ENTER, player.getSoundSource(), 1.0f, 1.0f);
                    return ItemInteractionResult.SUCCESS;
                }
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0), (VoxelShape)Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0));
    }
}

