/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineConnectingBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<GeneralUtil.LineConnectingType> TYPE = GeneralUtil.LINE_CONNECTING_TYPE;

    public LineConnectingBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(TYPE, (Comparable)((Object)GeneralUtil.LineConnectingType.NONE)));
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction facing = context.getHorizontalDirection().getOpposite();
        BlockState blockState = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing);
        Level world = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        return switch (facing) {
            case Direction.EAST -> (BlockState)blockState.setValue(TYPE, (Comparable)((Object)this.getType(blockState, world.getBlockState(clickedPos.south()), world.getBlockState(clickedPos.north()))));
            case Direction.SOUTH -> (BlockState)blockState.setValue(TYPE, (Comparable)((Object)this.getType(blockState, world.getBlockState(clickedPos.west()), world.getBlockState(clickedPos.east()))));
            case Direction.WEST -> (BlockState)blockState.setValue(TYPE, (Comparable)((Object)this.getType(blockState, world.getBlockState(clickedPos.north()), world.getBlockState(clickedPos.south()))));
            default -> (BlockState)blockState.setValue(TYPE, (Comparable)((Object)this.getType(blockState, world.getBlockState(clickedPos.east()), world.getBlockState(clickedPos.west()))));
        };
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (!world.isClientSide) {
            GeneralUtil.LineConnectingType type;
            Direction facing = (Direction)state.getValue((Property)FACING);
            switch (facing) {
                case EAST: {
                    GeneralUtil.LineConnectingType lineConnectingType = this.getType(state, world.getBlockState(pos.south()), world.getBlockState(pos.north()));
                    break;
                }
                case SOUTH: {
                    GeneralUtil.LineConnectingType lineConnectingType = this.getType(state, world.getBlockState(pos.west()), world.getBlockState(pos.east()));
                    break;
                }
                case WEST: {
                    GeneralUtil.LineConnectingType lineConnectingType = this.getType(state, world.getBlockState(pos.north()), world.getBlockState(pos.south()));
                    break;
                }
                default: {
                    GeneralUtil.LineConnectingType lineConnectingType = type = this.getType(state, world.getBlockState(pos.east()), world.getBlockState(pos.west()));
                }
            }
            if (state.getValue(TYPE) != type) {
                state = (BlockState)state.setValue(TYPE, (Comparable)((Object)type));
                world.setBlock(pos, state, 3);
            }
        }
    }

    public GeneralUtil.LineConnectingType getType(BlockState state, BlockState left, BlockState right) {
        boolean shapeRightSame;
        boolean shapeLeftSame = left.getBlock() == state.getBlock() && left.getValue((Property)FACING) == state.getValue((Property)FACING);
        boolean bl = shapeRightSame = right.getBlock() == state.getBlock() && right.getValue((Property)FACING) == state.getValue((Property)FACING);
        if (shapeLeftSame && shapeRightSame) {
            return GeneralUtil.LineConnectingType.MIDDLE;
        }
        if (shapeLeftSame) {
            return GeneralUtil.LineConnectingType.LEFT;
        }
        return shapeRightSame ? GeneralUtil.LineConnectingType.RIGHT : GeneralUtil.LineConnectingType.NONE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, TYPE});
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

