/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SinkBlock
extends Block {
    public static final BooleanProperty FILLED = BooleanProperty.create((String)"filled");
    public static final EnumProperty<DoubleBlockHalf> HALF = EnumProperty.create((String)"half", DoubleBlockHalf.class);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final Map<Direction, VoxelShape> TOP_SHAPES = new HashMap<Direction, VoxelShape>();
    public static final Map<Direction, VoxelShape> BOTTOM_SHAPES = new HashMap<Direction, VoxelShape>();

    public SinkBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)FILLED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    private static VoxelShape makeTopShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.75, (double)0.625, (double)0.0625, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.125, (double)0.75, (double)0.375, (double)0.3125, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)0.3125, (double)0.5, (double)0.5625, (double)0.5, (double)0.625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.25, (double)0.4375, (double)0.625, (double)0.3125, (double)0.6875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)0.0625, (double)0.8125, (double)0.5625, (double)0.375, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)0.375, (double)0.625, (double)0.5625, (double)0.5, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.1875, (double)0.8125, (double)0.4375, (double)0.25, (double)0.875), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    private static VoxelShape makeBottomShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.125, (double)1.0, (double)0.75, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.75, (double)0.1875, (double)0.1875, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.75, (double)0.75, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.75, (double)0.0, (double)1.0, (double)1.0, (double)0.1875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.75, (double)0.1875, (double)1.0, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            return TOP_SHAPES.get(facing);
        }
        return BOTTOM_SHAPES.get(facing);
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (world.isClientSide || state.getValue(HALF) != DoubleBlockHalf.LOWER) {
            return ItemInteractionResult.SUCCESS;
        }
        Item item = itemStack.getItem();
        if (itemStack.isEmpty() && !((Boolean)state.getValue((Property)FILLED)).booleanValue()) {
            world.setBlock(pos, (BlockState)state.setValue((Property)FILLED, (Comparable)Boolean.valueOf(true)), 3);
            world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        if (!(item != Items.WATER_BUCKET && item != Items.GLASS_BOTTLE || ((Boolean)state.getValue((Property)FILLED)).booleanValue())) {
            world.setBlock(pos, (BlockState)state.setValue((Property)FILLED, (Comparable)Boolean.valueOf(true)), 3);
            world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.isCreative()) {
                if (item == Items.WATER_BUCKET) {
                    itemStack.shrink(1);
                    player.addItem(new ItemStack((ItemLike)Items.BUCKET));
                } else {
                    itemStack.shrink(1);
                    player.addItem(new ItemStack((ItemLike)Items.GLASS_BOTTLE));
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        if ((item == Items.BUCKET || item == Items.GLASS_BOTTLE) && ((Boolean)state.getValue((Property)FILLED)).booleanValue()) {
            world.setBlock(pos, (BlockState)state.setValue((Property)FILLED, (Comparable)Boolean.valueOf(false)), 3);
            world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.isCreative()) {
                if (item == Items.BUCKET) {
                    itemStack.shrink(1);
                    player.addItem(new ItemStack((ItemLike)Items.WATER_BUCKET));
                } else {
                    itemStack.shrink(1);
                    PotionContents potionContents = new PotionContents(Potions.WATER);
                    ItemStack potionStack = new ItemStack((ItemLike)Items.POTION);
                    potionStack.set(DataComponents.POTION_CONTENTS, (Object)potionContents);
                    player.addItem(potionStack);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF, FILLED, FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockPos = context.getClickedPos();
        return context.getLevel().getBlockState(blockPos.above()).canBeReplaced(context) ? (BlockState)((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite()) : null;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        world.setBlock(pos.above(), (BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            BlockPos blockPos = pos.below();
            BlockState blockState = world.getBlockState(blockPos);
            return blockState.is((Block)this) && blockState.getValue(HALF) == DoubleBlockHalf.LOWER;
        }
        return super.canSurvive(state, world, pos);
    }

    public static void placeAt(LevelAccessor levelAccessor, BlockState blockState, BlockPos blockPos, int i) {
        BlockPos blockPos2 = blockPos.above();
        levelAccessor.setBlock(blockPos, SinkBlock.copyWaterloggedFrom((LevelReader)levelAccessor, blockPos, (BlockState)blockState.setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)), i);
        levelAccessor.setBlock(blockPos2, SinkBlock.copyWaterloggedFrom((LevelReader)levelAccessor, blockPos2, (BlockState)blockState.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)), i);
    }

    private static BlockState copyWaterloggedFrom(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) ? (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(levelReader.isWaterAt(blockPos))) : blockState;
    }

    protected static void preventCreativeDropFromBottomPart(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        BlockPos blockPos2;
        BlockState blockState2;
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)blockState.getValue(HALF);
        if (doubleBlockHalf == DoubleBlockHalf.UPPER && (blockState2 = level.getBlockState(blockPos2 = blockPos.below())).is(blockState.getBlock()) && blockState2.getValue(HALF) == DoubleBlockHalf.LOWER) {
            BlockState blockState3 = blockState2.getFluidState().is((Fluid)Fluids.WATER) ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
            level.setBlock(blockPos2, blockState3, 35);
            level.levelEvent(player, 2001, blockPos2, Block.getId((BlockState)blockState2));
        }
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        BlockPos blockPos = half == DoubleBlockHalf.LOWER ? pos.above() : pos.below();
        BlockState blockState = world.getBlockState(blockPos);
        if (blockState.getBlock() == this && blockState.getValue(HALF) != half) {
            world.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 35);
            world.levelEvent(player, 2001, blockPos, Block.getId((BlockState)blockState));
            if (!world.isClientSide && !player.isCreative()) {
                SinkBlock.dropResources((BlockState)state, (Level)world, (BlockPos)pos, null, (Entity)player, (ItemStack)player.getMainHandItem());
                SinkBlock.dropResources((BlockState)blockState, (Level)world, (BlockPos)blockPos, null, (Entity)player, (ItemStack)player.getMainHandItem());
            }
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public void playerDestroy(Level level, Player player, BlockPos blockPos, BlockState blockState, @Nullable BlockEntity blockEntity, ItemStack itemStack) {
        super.playerDestroy(level, player, blockPos, Blocks.AIR.defaultBlockState(), blockEntity, itemStack);
        if (blockState.getValue(HALF) == DoubleBlockHalf.LOWER) {
            BlockPos blockPos2 = blockPos.above();
            BlockState blockState2 = level.getBlockState(blockPos2);
            if (blockState2.is((Block)this) && blockState2.getValue(HALF) == DoubleBlockHalf.UPPER) {
                level.destroyBlock(blockPos2, true);
            }
        } else {
            BlockPos blockPos1 = blockPos.below();
            BlockState blockState1 = level.getBlockState(blockPos1);
            if (blockState1.is((Block)this) && blockState1.getValue(HALF) == DoubleBlockHalf.LOWER) {
                level.destroyBlock(blockPos1, true);
            }
        }
    }

    public long getSeed(BlockState blockState, BlockPos blockPos) {
        return Mth.getSeed((int)blockPos.getX(), (int)blockPos.below(blockState.getValue(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).getY(), (int)blockPos.getZ());
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource randomSource) {
        float chance = randomSource.nextFloat();
        if (chance < 0.1f) {
            SinkBlock.spawnDripParticle(world, pos, state);
        }
    }

    public static void spawnDripParticle(Level level, BlockPos blockPos, BlockState blockState) {
        Vec3 vec3 = blockState.getOffset((BlockGetter)level, blockPos);
        double d = 0.0625;
        double e = (double)blockPos.getX() + 0.5 + vec3.x;
        double f = (double)((float)((double)blockPos.getY() + 0.9) - 0.6875f) - d;
        double g = (double)blockPos.getZ() + 0.5 + vec3.z;
        SimpleParticleType particleOptions = ParticleTypes.DRIPPING_WATER;
        level.addParticle((ParticleOptions)particleOptions, e, f, g, 0.0, 0.0, 0.0);
    }

    static {
        Supplier<VoxelShape> topShapeSupplier = SinkBlock::makeTopShape;
        Supplier<VoxelShape> bottomShapeSupplier = SinkBlock::makeBottomShape;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            TOP_SHAPES.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, topShapeSupplier.get()));
            BOTTOM_SHAPES.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, bottomShapeSupplier.get()));
        }
    }
}

