/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.farm_and_charm.core.block.FeedingTroughBlock;
import net.satisfy.farm_and_charm.core.network.PacketHandler;
import net.satisfy.farm_and_charm.core.network.packet.SyncSaturationPacket;
import net.satisfy.farm_and_charm.core.registry.EntityTypeRegistry;
import net.satisfy.farm_and_charm.core.util.SaturationTracker;
import org.jetbrains.annotations.NotNull;

public class FeedingTroughBlockEntity
extends BlockEntity
implements WorldlyContainer {
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private boolean updatingState = false;

    public FeedingTroughBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.FEEDING_TROUGH_BLOCK_ENTITY.get(), pos, state);
    }

    public int @NotNull [] getSlotsForFace(Direction side) {
        return new int[]{0};
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return stack.is(ItemTags.VILLAGER_PLANTABLE_SEEDS) && this.getItem(slot).getCount() < 4;
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, Direction dir) {
        return this.canPlaceItem(slot, stack);
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction dir) {
        return false;
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return ((ItemStack)this.items.get(0)).isEmpty();
    }

    @NotNull
    public ItemStack getItem(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = ContainerHelper.removeItem(this.items, (int)slot, (int)amount);
        this.setChanged();
        return stack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack stack = ContainerHelper.takeItem(this.items, (int)slot);
        this.setChanged();
        return stack;
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        if (stack.isEmpty()) {
            this.items.set(slot, (Object)ItemStack.EMPTY);
        } else {
            int capped = Math.min(4, stack.getCount());
            ItemStack copy = stack.copy();
            copy.setCount(capped);
            this.items.set(slot, (Object)copy);
        }
        this.setChanged();
    }

    public int getMaxStackSize() {
        return 4;
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    public void clearContent() {
        this.items.set(0, (Object)ItemStack.EMPTY);
        this.setChanged();
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.items, (HolderLookup.Provider)provider);
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.items, (HolderLookup.Provider)provider);
    }

    public void setChanged() {
        super.setChanged();
        if (!this.updatingState) {
            this.updatingState = true;
            this.updateBlockState();
            this.updatingState = false;
        }
    }

    private void updateBlockState() {
        BlockState state;
        if (this.level != null && !this.level.isClientSide && (state = this.level.getBlockState(this.worldPosition)).getBlock() instanceof FeedingTroughBlock) {
            int newSize = ((ItemStack)this.items.get(0)).getCount();
            if ((Integer)state.getValue((Property)FeedingTroughBlock.SIZE) != newSize) {
                BlockState newState = (BlockState)state.setValue((Property)FeedingTroughBlock.SIZE, (Comparable)Integer.valueOf(newSize));
                this.level.setBlock(this.worldPosition, newState, 3);
                this.level.sendBlockUpdated(this.worldPosition, state, newState, 3);
            }
        }
    }

    public void onAnimalFed(Animal animal) {
        if (!(animal instanceof SaturationTracker.SaturatedAnimal)) {
            return;
        }
        SaturationTracker.SaturatedAnimal saturated = (SaturationTracker.SaturatedAnimal)animal;
        SaturationTracker tracker = saturated.farm_and_charm$getSaturationTracker();
        tracker.feedDirectly(animal, 5);
        if (!animal.level().isClientSide) {
            PacketHandler.sendSaturationSync(new SyncSaturationPacket(animal.getId(), tracker.level(), tracker.foodCounter()), (Entity)animal);
        }
    }
}

