/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block.entity;

import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.satisfy.farm_and_charm.core.block.MincerBlock;
import net.satisfy.farm_and_charm.core.recipe.MincerRecipe;
import net.satisfy.farm_and_charm.core.registry.EntityTypeRegistry;
import net.satisfy.farm_and_charm.core.registry.RecipeTypeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MincerBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer,
BlockEntityTicker<MincerBlockEntity> {
    public final int SLOT_COUNT = 2;
    public final int INPUT_SLOT = 0;
    public final int OUTPUT_SLOT = 1;
    private NonNullList<ItemStack> stacks = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);

    public MincerBlockEntity(BlockPos position, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.MINCER_BLOCK_ENTITY.get(), position, state);
    }

    public static void spawnItem(Level world, ItemStack stack, int speed, Direction side, Position pos) {
        double d = pos.x();
        double e = pos.y();
        double f = pos.z();
        e = side.getAxis() == Direction.Axis.Y ? (e -= 0.125) : (e -= 0.15625);
        ItemEntity itemEntity = new ItemEntity(world, d, e, f, stack);
        double g = world.random.nextDouble() * 0.1 + 0.2;
        itemEntity.setDeltaMovement(world.random.triangle((double)side.getStepX() * g, 0.0172275 * (double)speed), world.random.triangle(0.2, 0.0172275 * (double)speed), world.random.triangle((double)side.getStepZ() * g, 0.0172275 * (double)speed));
        world.addFreshEntity((Entity)itemEntity);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        if (!this.tryLoadLootTable(compound)) {
            this.stacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        }
        ContainerHelper.loadAllItems((CompoundTag)compound, this.stacks, (HolderLookup.Provider)provider);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        if (!this.trySaveLootTable(compound)) {
            ContainerHelper.saveAllItems((CompoundTag)compound, this.stacks, (HolderLookup.Provider)provider);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Component getDefaultName() {
        return Component.literal((String)"mincer");
    }

    @NotNull
    public AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return ChestMenu.threeRows((int)id, (Inventory)inventory);
    }

    private void dropItemsInOutputSlot(Level level, BlockPos pos, BlockState state, MincerBlockEntity mincer) {
        Direction direction = ((Direction)state.getValue((Property)MincerBlock.FACING)).getClockWise();
        if (!level.isClientSide() && !((ItemStack)this.stacks.get(1)).isEmpty()) {
            ItemStack droppedStack = new ItemStack((ItemLike)((ItemStack)mincer.stacks.get(1)).getItem());
            droppedStack.setCount(((ItemStack)mincer.stacks.get(1)).getCount());
            this.stacks.set(1, (Object)ItemStack.EMPTY);
            Vec3 vec3d = Vec3.atCenterOf((Vec3i)pos);
            Vec3 vec3d2 = vec3d.relative(direction, 0.7);
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SPIT, vec3d2.x(), vec3d2.y(), vec3d2.z(), 3, 0.2, 0.1, 0.0, 0.1);
            MincerBlockEntity.spawnItem(level, droppedStack, 6, direction, (Position)vec3d2);
        }
    }

    public int getMaxStackSize() {
        return 64;
    }

    public int getContainerSize() {
        return this.stacks.size();
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        ItemStack inputSlotItemStack = (ItemStack)this.stacks.get(0);
        return index == 0 && inputSlotItemStack.isEmpty() || stack.is(inputSlotItemStack.getItem()) && inputSlotItemStack.getCount() < inputSlotItemStack.getMaxStackSize();
    }

    @NotNull
    public ItemStack getItem(int index) {
        return (ItemStack)this.getItems().get(index);
    }

    @NotNull
    public NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    protected void setItems(NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public int @NotNull [] getSlotsForFace(Direction side) {
        return IntStream.range(0, this.getContainerSize()).toArray();
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        return this.canPlaceItem(index, stack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return direction == Direction.UP && this.canPlaceItem(index, stack);
    }

    public void tick(Level level, BlockPos pos, BlockState state, MincerBlockEntity mincer) {
        this.dropItemsInOutputSlot(level, pos, state, mincer);
        if (!level.isClientSide() && level.getBlockState(pos).getBlock() instanceof MincerBlock) {
            int crank = (Integer)state.getValue((Property)MincerBlock.CRANK);
            int cranked = (Integer)state.getValue((Property)MincerBlock.CRANKED);
            if (crank > 0) {
                if (cranked < 20) {
                    ++cranked;
                }
                --crank;
                if (cranked >= 20) {
                    cranked = 0;
                    RecipeManager recipeManager = level.getRecipeManager();
                    List recipes = recipeManager.getAllRecipesFor((RecipeType)RecipeTypeRegistry.MINCER_RECIPE_TYPE.get());
                    Optional<MincerRecipe> recipe = Optional.ofNullable(this.getRecipe(recipes, this.stacks));
                    if (recipe.isPresent()) {
                        ItemStack inputStack = (ItemStack)this.stacks.get(0);
                        String recipe_type = recipe.get().getRecipeType();
                        int recipe_difficulty = 5;
                        switch (recipe_type) {
                            case "MEAT": {
                                recipe_difficulty = 1;
                                break;
                            }
                            case "WOOD": {
                                recipe_difficulty = 2;
                                break;
                            }
                            case "STONE": {
                                recipe_difficulty = 3;
                                break;
                            }
                            case "METAL": {
                                recipe_difficulty = 4;
                            }
                        }
                        AABB searched_area = new AABB(pos);
                        searched_area.inflate(4.0);
                        List playersNearby = level.getEntitiesOfClass(ServerPlayer.class, searched_area, LivingEntity::isAlive);
                        if (!playersNearby.isEmpty()) {
                            for (Player player : playersNearby) {
                                if (player == null || !player.getOffhandItem().is(inputStack.getItem())) continue;
                                --recipe_difficulty;
                            }
                        }
                        if (recipe_difficulty > 0) {
                            inputStack.shrink(1);
                            inputStack = inputStack.isEmpty() ? ItemStack.EMPTY : inputStack;
                            mincer.setItem(0, inputStack);
                            mincer.setItem(1, recipe.get().getResultItem((HolderLookup.Provider)level.registryAccess()));
                            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)MincerBlock.CRANK, (Comparable)Integer.valueOf(crank))).setValue((Property)MincerBlock.CRANKED, (Comparable)Integer.valueOf(cranked)), 3);
                            return;
                        }
                    }
                }
                level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)MincerBlock.CRANK, (Comparable)Integer.valueOf(crank))).setValue((Property)MincerBlock.CRANKED, (Comparable)Integer.valueOf(cranked)), 3);
            } else if (cranked > 0 && cranked < 20) {
                level.setBlock(pos, (BlockState)state.setValue((Property)MincerBlock.CRANKED, (Comparable)Integer.valueOf(0)), 3);
            }
        }
    }

    private MincerRecipe getRecipe(List<RecipeHolder<MincerRecipe>> recipes, NonNullList<ItemStack> inventory) {
        block0: for (RecipeHolder<MincerRecipe> recipeHolder : recipes) {
            MincerRecipe recipe = (MincerRecipe)recipeHolder.value();
            for (Ingredient ingredient : recipe.getIngredients()) {
                boolean ingredientFound = false;
                for (ItemStack slotItem : inventory) {
                    if (!ingredient.test(slotItem)) continue;
                    ingredientFound = true;
                    break;
                }
                if (ingredientFound) continue;
                continue block0;
            }
            return recipe;
        }
        return null;
    }
}

