/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.satisfy.farm_and_charm.core.registry.EntityTypeRegistry;

public class ScarecrowBlockEntity
extends BlockEntity {
    private long lastTickTime = 0L;

    public ScarecrowBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.SCARECROW_BLOCK_ENTITY.get(), pos, state);
    }

    public static <T extends BlockEntity> void tick(Level level, T be) {
        long interval;
        ServerLevel serverLevel;
        long current;
        if (!(be instanceof ScarecrowBlockEntity)) {
            return;
        }
        ScarecrowBlockEntity self = (ScarecrowBlockEntity)be;
        if (level instanceof ServerLevel && (current = (serverLevel = (ServerLevel)level).getGameTime()) - self.lastTickTime > (interval = 500L)) {
            self.lastTickTime = current;
            BlockPos.betweenClosedStream((BlockPos)self.worldPosition.offset(-8, -1, -8), (BlockPos)self.worldPosition.offset(8, 1, 8)).forEach(p -> {
                CropBlock crop;
                BlockState bs = serverLevel.getBlockState(p);
                Block patt0$temp = bs.getBlock();
                if (patt0$temp instanceof CropBlock && !(crop = (CropBlock)patt0$temp).isMaxAge(bs)) {
                    crop.randomTick(bs, serverLevel, p, serverLevel.random);
                    serverLevel.gameEvent((Holder)GameEvent.BLOCK_CHANGE, p, GameEvent.Context.of((BlockState)bs));
                }
            });
        }
    }
}

