/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block.entity;

import dev.architectury.registry.fuel.FuelRegistry;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.satisfy.farm_and_charm.client.gui.handler.StoveGuiHandler;
import net.satisfy.farm_and_charm.core.block.StoveBlock;
import net.satisfy.farm_and_charm.core.item.food.EffectBlockItem;
import net.satisfy.farm_and_charm.core.item.food.EffectFood;
import net.satisfy.farm_and_charm.core.item.food.EffectFoodBlockItem;
import net.satisfy.farm_and_charm.core.item.food.EffectFoodHelper;
import net.satisfy.farm_and_charm.core.recipe.RecipeUnlockManager;
import net.satisfy.farm_and_charm.core.recipe.StoveRecipe;
import net.satisfy.farm_and_charm.core.registry.EntityTypeRegistry;
import net.satisfy.farm_and_charm.core.registry.RecipeTypeRegistry;
import net.satisfy.farm_and_charm.core.world.ImplementedInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoveBlockEntity
extends BlockEntity
implements BlockEntityTicker<StoveBlockEntity>,
ImplementedInventory,
MenuProvider {
    public static final int TOTAL_COOKING_TIME = 240;
    protected static final int[] INGREDIENT_SLOTS = new int[]{1, 2, 3};
    protected int burnTime;
    protected int burnTimeTotal;
    protected int cookTime;
    protected int cookTimeTotal;
    private UUID ownerUuid;
    private final ContainerData propertyDelegate = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> StoveBlockEntity.this.burnTime;
                case 1 -> StoveBlockEntity.this.burnTimeTotal;
                case 2 -> StoveBlockEntity.this.cookTime;
                case 3 -> StoveBlockEntity.this.cookTimeTotal;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    StoveBlockEntity.this.burnTime = value;
                    break;
                }
                case 1: {
                    StoveBlockEntity.this.burnTimeTotal = value;
                    break;
                }
                case 2: {
                    StoveBlockEntity.this.cookTime = value;
                    break;
                }
                case 3: {
                    StoveBlockEntity.this.cookTimeTotal = value;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };
    protected float experience;
    private NonNullList<ItemStack> inventory = NonNullList.withSize((int)5, (Object)ItemStack.EMPTY);

    public StoveBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.STOVE_BLOCK_ENTITY.get(), pos, state);
    }

    public int[] getIngredientSlots() {
        return INGREDIENT_SLOTS;
    }

    public int getOutputSlot() {
        return 0;
    }

    public void dropExperience(ServerLevel world, Vec3 pos) {
        ExperienceOrb.award((ServerLevel)world, (Vec3)pos, (int)((int)this.experience));
    }

    @Override
    public int @NotNull [] getSlotsForFace(Direction side) {
        if (side.equals((Object)Direction.UP)) {
            return INGREDIENT_SLOTS;
        }
        if (side.equals((Object)Direction.DOWN)) {
            return new int[]{0};
        }
        return new int[]{4};
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.inventory = NonNullList.withSize((int)5, (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.inventory, (HolderLookup.Provider)provider);
        this.burnTime = compoundTag.getShort("BurnTime");
        this.cookTime = compoundTag.getShort("CookTime");
        this.cookTimeTotal = compoundTag.getShort("CookTimeTotal");
        this.burnTimeTotal = this.getTotalBurnTime(this.getItem(4));
        this.experience = compoundTag.getFloat("Experience");
        if (compoundTag.hasUUID("Owner")) {
            this.ownerUuid = compoundTag.getUUID("Owner");
        }
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.putShort("BurnTime", (short)this.burnTime);
        compoundTag.putShort("CookTime", (short)this.cookTime);
        compoundTag.putShort("CookTimeTotal", (short)this.cookTimeTotal);
        compoundTag.putFloat("Experience", this.experience);
        if (this.ownerUuid != null) {
            compoundTag.putUUID("Owner", this.ownerUuid);
        }
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.inventory, (HolderLookup.Provider)provider);
    }

    protected boolean isBurning() {
        return this.burnTime > 0;
    }

    public void tick(Level world, BlockPos pos, BlockState state, StoveBlockEntity blockEntity) {
        ServerPlayer owner;
        if (world.isClientSide) {
            return;
        }
        boolean initialBurningState = blockEntity.isBurning();
        boolean dirty = false;
        if (initialBurningState) {
            --this.burnTime;
        }
        assert (this.level != null);
        RecipeManager recipeManager = world.getRecipeManager();
        List recipes = recipeManager.getAllRecipesFor((RecipeType)RecipeTypeRegistry.STOVE_RECIPE_TYPE.get());
        Optional<StoveRecipe> recipe = Optional.ofNullable(this.getRecipe(recipes, this.inventory));
        RegistryAccess access = this.level.registryAccess();
        if (recipe.isPresent() && recipe.get().requiresLearning() && ((owner = Objects.requireNonNull(world.getServer()).getPlayerList().getPlayer(this.ownerUuid)) == null || RecipeUnlockManager.isRecipeLocked(owner, BuiltInRegistries.RECIPE_TYPE.getKey(recipe.get().getType())))) {
            this.cookTime = 0;
            if (((Boolean)state.getValue((Property)StoveBlock.LIT)).booleanValue()) {
                world.setBlock(pos, (BlockState)state.setValue((Property)StoveBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
            }
            return;
        }
        if (!initialBurningState && recipe.isPresent() && this.canCraft(recipe.get(), access)) {
            this.burnTime = this.burnTimeTotal = this.getTotalBurnTime(this.getItem(4));
            if (this.burnTime > 0) {
                dirty = true;
                ItemStack fuelStack = this.getItem(4);
                if (fuelStack.getItem().hasCraftingRemainingItem()) {
                    this.setItem(4, new ItemStack((ItemLike)Objects.requireNonNull(fuelStack.getItem().getCraftingRemainingItem())));
                } else if (fuelStack.getCount() > 1) {
                    this.removeItem(4, 1);
                } else if (fuelStack.getCount() == 1) {
                    this.setItem(4, ItemStack.EMPTY);
                }
            }
        }
        if ((this.isBurning() || initialBurningState) && recipe.isPresent() && this.canCraft(recipe.get(), access)) {
            ++this.cookTime;
            if (this.cookTime == this.cookTimeTotal) {
                this.cookTime = 0;
                this.craft(recipe.get(), access);
                dirty = true;
            }
        } else if (recipe.isPresent() && !this.canCraft(recipe.get(), access)) {
            this.cookTime = 0;
        }
        if (initialBurningState != this.isBurning() || (Boolean)state.getValue((Property)StoveBlock.LIT) != (this.burnTime > 0 || this.burnTime == 0 && this.burnTimeTotal > 0)) {
            world.setBlock(pos, (BlockState)state.setValue((Property)StoveBlock.LIT, (Comparable)Boolean.valueOf(this.burnTime > 0 || this.burnTime == 0 && this.burnTimeTotal > 0)), 3);
            dirty = true;
        }
        if (dirty) {
            this.setChanged();
        }
    }

    protected boolean canCraft(StoveRecipe recipe, RegistryAccess access) {
        ItemStack output;
        if (recipe == null || recipe.getResultItem((HolderLookup.Provider)access).isEmpty()) {
            return false;
        }
        if (!this.matchesInventory(recipe, this.inventory)) {
            return false;
        }
        ItemStack recipeOutput = recipe.getResultItem((HolderLookup.Provider)access).copy();
        for (int slot : INGREDIENT_SLOTS) {
            PotionContents potionContents;
            ItemStack ingredientStack = this.getItem(slot);
            if (ingredientStack.isEmpty() || !(ingredientStack.getItem() instanceof EffectFood) && !(ingredientStack.getItem() instanceof EffectBlockItem) || !(potionContents = (PotionContents)ingredientStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).hasEffects()) continue;
            recipeOutput.set(DataComponents.POTION_CONTENTS, (Object)potionContents);
        }
        if (recipeOutput.getItem() instanceof EffectFood || recipeOutput.getItem() instanceof EffectFoodBlockItem) {
            EffectFoodHelper.applyEffects(recipeOutput);
        }
        if ((output = this.getItem(0)).isEmpty()) {
            return true;
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)output, (ItemStack)recipeOutput)) {
            return false;
        }
        return output.getCount() + recipeOutput.getCount() <= output.getMaxStackSize();
    }

    private StoveRecipe getRecipe(List<RecipeHolder<StoveRecipe>> recipes, NonNullList<ItemStack> inventory) {
        for (RecipeHolder<StoveRecipe> holder : recipes) {
            StoveRecipe r = (StoveRecipe)holder.value();
            if (!this.matchesInventory(r, inventory)) continue;
            return r;
        }
        return null;
    }

    private boolean matchesInventory(StoveRecipe recipe, NonNullList<ItemStack> inventory) {
        NonNullList invCopy = NonNullList.withSize((int)inventory.size(), (Object)ItemStack.EMPTY);
        for (int i : INGREDIENT_SLOTS) {
            invCopy.set(i, (Object)((ItemStack)inventory.get(i)).copy());
        }
        for (Ingredient ingredient : recipe.getIngredients()) {
            boolean matched = false;
            for (int i : INGREDIENT_SLOTS) {
                ItemStack stack = (ItemStack)invCopy.get(i);
                if (stack.isEmpty() || !ingredient.test(stack)) continue;
                stack.shrink(1);
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        for (int i : INGREDIENT_SLOTS) {
            ItemStack remaining = (ItemStack)invCopy.get(i);
            if (remaining.isEmpty()) continue;
            boolean stillIngredient = false;
            for (Ingredient ing : recipe.getIngredients()) {
                if (!ing.test(remaining)) continue;
                stillIngredient = true;
                break;
            }
            if (stillIngredient) continue;
            return false;
        }
        return true;
    }

    protected void craft(StoveRecipe recipe, RegistryAccess access) {
        if (recipe == null || !this.canCraft(recipe, access)) {
            return;
        }
        ItemStack recipeOutput = recipe.getResultItem((HolderLookup.Provider)access).copy();
        ItemStack outputSlotStack = this.getItem(0);
        if (outputSlotStack.isEmpty()) {
            this.setItem(0, recipeOutput);
        } else if (ItemStack.isSameItemSameComponents((ItemStack)outputSlotStack, (ItemStack)recipeOutput)) {
            outputSlotStack.grow(recipeOutput.getCount());
        }
        block0: for (int slot : INGREDIENT_SLOTS) {
            ItemStack stackInSlot = this.getItem(slot);
            for (Ingredient ingredient : recipe.getIngredients()) {
                if (!ingredient.test(stackInSlot)) continue;
                ItemStack remainderStack = this.getRemainderItem(stackInSlot);
                stackInSlot.shrink(1);
                if (remainderStack.isEmpty()) continue block0;
                if (stackInSlot.isEmpty()) {
                    this.setItem(slot, remainderStack);
                    continue block0;
                }
                boolean added = false;
                for (int i : INGREDIENT_SLOTS) {
                    ItemStack is = this.getItem(i);
                    if (is.isEmpty()) {
                        this.setItem(i, remainderStack.copy());
                        added = true;
                        break;
                    }
                    if (!ItemStack.isSameItemSameComponents((ItemStack)is, (ItemStack)remainderStack) || is.getCount() >= is.getMaxStackSize()) continue;
                    is.grow(1);
                    added = true;
                    break;
                }
                if (added) continue block0;
                assert (this.level != null);
                Block.popResource((Level)this.level, (BlockPos)this.worldPosition, (ItemStack)remainderStack);
                continue block0;
            }
        }
    }

    protected int getTotalBurnTime(ItemStack fuel) {
        if (fuel.isEmpty()) {
            return 0;
        }
        return FuelRegistry.get((ItemStack)fuel);
    }

    private ItemStack getRemainderItem(ItemStack stack) {
        if (stack.getItem().hasCraftingRemainingItem()) {
            return new ItemStack((ItemLike)Objects.requireNonNull(stack.getItem().getCraftingRemainingItem()));
        }
        return ItemStack.EMPTY;
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        ItemStack stackInSlot = (ItemStack)this.inventory.get(slot);
        boolean dirty = !stack.isEmpty() && ItemStack.isSameItem((ItemStack)stack, (ItemStack)stackInSlot) && ItemStack.matches((ItemStack)stack, (ItemStack)stackInSlot);
        this.inventory.set(slot, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        boolean hasIngredientChange = false;
        for (int ingredientSlot : INGREDIENT_SLOTS) {
            if (ItemStack.isSameItemSameComponents((ItemStack)this.getItem(ingredientSlot), (ItemStack)stackInSlot)) continue;
            hasIngredientChange = true;
            break;
        }
        if (hasIngredientChange && !dirty) {
            this.cookTimeTotal = 240;
            this.cookTime = 0;
            this.setChanged();
        }
    }

    @Override
    public boolean stillValid(Player player) {
        assert (this.level != null);
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
        return new StoveGuiHandler(syncId, inv, (Container)this, this.propertyDelegate);
    }

    @Override
    public void setChanged() {
        super.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public void setOwner(UUID uuid) {
        this.ownerUuid = uuid;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        this.saveAdditional(compoundTag, provider);
        return compoundTag;
    }
}

