/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.compat.rei.cooking;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.satisfy.farm_and_charm.core.recipe.CookingPotRecipe;

public class CookingPotDisplay
extends BasicDisplay {
    public static final CategoryIdentifier<CookingPotDisplay> COOKING_POT_DISPLAY = CategoryIdentifier.of((String)"farm_and_charm", (String)"cooking_pot_display");

    public CookingPotDisplay(CookingPotRecipe recipe) {
        super(CookingPotDisplay.createInputs(recipe), CookingPotDisplay.createOutputs(recipe), Optional.of(CookingPotRecipe.getIdStatic()));
    }

    private static List<EntryIngredient> createInputs(CookingPotRecipe recipe) {
        ArrayList<EntryIngredient> inputs = new ArrayList<EntryIngredient>();
        for (int i = 0; i < 6; ++i) {
            if (i < recipe.getIngredients().size()) {
                Ingredient ingredient = (Ingredient)recipe.getIngredients().get(i);
                inputs.add(EntryIngredients.ofIngredient((Ingredient)ingredient));
                continue;
            }
            inputs.add(EntryIngredients.of((ItemStack)ItemStack.EMPTY));
        }
        if (recipe.isContainerRequired() && !recipe.getContainerItem().isEmpty()) {
            inputs.add(EntryIngredients.of((ItemStack)recipe.getContainerItem()));
        } else {
            inputs.add(EntryIngredients.of((ItemStack)ItemStack.EMPTY));
        }
        return inputs;
    }

    private static List<EntryIngredient> createOutputs(CookingPotRecipe recipe) {
        RegistryAccess.Frozen access = Minecraft.getInstance().level != null ? Minecraft.getInstance().level.registryAccess() : RegistryAccess.EMPTY;
        return List.of(EntryIngredients.of((ItemStack)recipe.getResultItem((HolderLookup.Provider)access)));
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return COOKING_POT_DISPLAY;
    }
}

