/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.effect;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.satisfy.farm_and_charm.platform.PlatformHelper;

public class ChickenEffect
extends MobEffect {
    public ChickenEffect() {
        super(MobEffectCategory.BENEFICIAL, 0xFFFFFF);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (!entity.level().isClientSide) {
            int tickInterval = PlatformHelper.getChickenEffectTickInterval();
            float eggChance = (float)PlatformHelper.getChickenEffectEggChance() / 100.0f;
            float featherChance = (float)PlatformHelper.getChickenEffectFeatherChance() / 100.0f;
            if (entity.tickCount % tickInterval == 0) {
                if (entity.level().random.nextFloat() < eggChance) {
                    ItemEntity eggEntity = new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), new ItemStack((ItemLike)Items.EGG));
                    entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.CHICKEN_EGG, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    entity.level().addFreshEntity((Entity)eggEntity);
                }
                if (entity.level().random.nextFloat() < featherChance) {
                    ItemEntity featherEntity = new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), new ItemStack((ItemLike)Items.FEATHER));
                    entity.level().addFreshEntity((Entity)featherEntity);
                }
                if (entity instanceof Player && (double)entity.level().random.nextFloat() < 0.1) {
                    entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.CHICKEN_AMBIENT, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int i, int j) {
        return true;
    }
}

