/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.entity;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.satisfy.farm_and_charm.core.entity.AbstractTowableEntity;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class SupplyCartEntity
extends AbstractTowableEntity
implements MenuProvider,
Container {
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
    private int openCount;

    public SupplyCartEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.inventory, (HolderLookup.Provider)this.registryAccess());
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.inventory, (HolderLookup.Provider)this.registryAccess());
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)((Item)ObjectRegistry.SUPPLY_CART.get()).getDescriptionId());
    }

    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player player) {
        return ChestMenu.threeRows((int)i, (Inventory)playerInventory, (Container)this);
    }

    public void remove(Entity.RemovalReason removalReason) {
        if (!this.level().isClientSide && removalReason.shouldDestroy()) {
            Vector3f pos = new Vector3f((float)this.getX(), (float)this.getY(), (float)this.getZ());
            for (ItemStack stack : this.inventory) {
                if (stack.isEmpty()) continue;
                ItemEntity itementity = new ItemEntity(this.level(), (double)pos.x, (double)pos.y, (double)pos.z, stack);
                this.level().addFreshEntity((Entity)itementity);
            }
        }
        super.remove(removalReason);
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public InteractionResult interact(Player player, InteractionHand interactionHand) {
        if (this.hasDriver()) {
            this.removeDriver();
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.WOOD_PLACE, SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (!player.isShiftKeyDown()) {
            player.openMenu((MenuProvider)this);
            this.startOpen(player);
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.CHEST_OPEN, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        boolean added = this.addDriver((Entity)player);
        if (added) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.WOOD_FALL, SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public ItemStack getItem(int i) {
        return (ItemStack)this.inventory.get(i);
    }

    @NotNull
    public ItemStack removeItem(int i, int count) {
        return ContainerHelper.removeItem(this.inventory, (int)i, (int)count);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int i) {
        return ContainerHelper.takeItem(this.inventory, (int)i);
    }

    public void setItem(int i, ItemStack itemStack) {
        this.inventory.set(i, (Object)itemStack);
    }

    public int getMaxStackSize() {
        return 64;
    }

    public void setChanged() {
    }

    public boolean stillValid(Player player) {
        return !this.isRemoved() && player.distanceToSqr((Entity)this) <= 64.0;
    }

    public void clearContent() {
        this.inventory.clear();
    }

    @Override
    protected ItemStack getDropItem() {
        return new ItemStack((ItemLike)ObjectRegistry.SUPPLY_CART.get());
    }

    public void startOpen(Player player) {
        if (!this.level().isClientSide) {
            ++this.openCount;
        }
    }

    public void stopOpen(Player player) {
        if (!this.level().isClientSide) {
            --this.openCount;
        }
    }

    public boolean isOpen() {
        return this.openCount > 0;
    }
}

