/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.item;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.satisfy.farm_and_charm.core.registry.EntityTypeRegistry;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class CartItem
extends Item {
    public CartItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        if (!world.isClientSide) {
            Entity entity = null;
            if (this == ObjectRegistry.SUPPLY_CART.get()) {
                entity = ((EntityType)EntityTypeRegistry.SUPPLY_CART.get()).create(world);
            } else if (this == ObjectRegistry.PLOW.get()) {
                entity = ((EntityType)EntityTypeRegistry.PLOW.get()).create(world);
            }
            if (entity != null) {
                entity.setPos((double)context.getClickedPos().getX() + 0.5, (double)(context.getClickedPos().getY() + 1), (double)context.getClickedPos().getZ() + 0.5);
                world.addFreshEntity(entity);
                world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.WOOD_PLACE, entity.getSoundSource(), 1.0f, 1.0f);
                context.getItemInHand().shrink(1);
            }
        }
        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
    }
}

