/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.item.food;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class EffectBlockItem
extends BlockItem {
    public EffectBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        List list2 = Lists.newArrayList();
        if (itemStack.has(DataComponents.FOOD)) {
            list2 = Objects.requireNonNull((FoodProperties)itemStack.get(DataComponents.FOOD)).effects();
        }
        ArrayList list3 = Lists.newArrayList();
        if (list2.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"effect.none").withStyle(ChatFormatting.GRAY));
        } else {
            for (FoodProperties.PossibleEffect possibleEffect : list2) {
                MutableComponent mutable = Component.translatable((String)possibleEffect.effect().getDescriptionId());
                MobEffectInstance mobEffectInstance = possibleEffect.effect();
                ((MobEffect)mobEffectInstance.getEffect().value()).createModifiers(mobEffectInstance.getAmplifier(), (holderx, attributeModifierx) -> {
                    AttributeModifier entityAttributeModifier = new AttributeModifier(attributeModifierx.id(), attributeModifierx.amount() * (double)(mobEffectInstance.getAmplifier() + 1), attributeModifierx.operation());
                    list3.add(new Pair(holderx, (Object)entityAttributeModifier));
                });
                if (mobEffectInstance.getDuration() > 20) {
                    mutable = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{mutable, MobEffectUtil.formatDuration((MobEffectInstance)mobEffectInstance, (float)possibleEffect.probability(), (float)tooltipContext.tickRate())});
                }
                tooltip.add((Component)mutable.withStyle(((MobEffect)mobEffectInstance.getEffect().value()).getCategory().getTooltipFormatting()));
            }
        }
        if (!list3.isEmpty()) {
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)Component.translatable((String)"potion.whenDrank").withStyle(ChatFormatting.DARK_PURPLE));
            for (Pair pair : list3) {
                AttributeModifier entityAttributeModifier3 = (AttributeModifier)pair.getSecond();
                double d = entityAttributeModifier3.amount();
                double e = entityAttributeModifier3.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_BASE && entityAttributeModifier3.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? entityAttributeModifier3.amount() : entityAttributeModifier3.amount() * 100.0;
                if (d > 0.0) {
                    tooltip.add((Component)Component.translatable((String)("attribute.modifier.plus." + entityAttributeModifier3.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(e), Component.translatable((String)((Attribute)((Holder)pair.getFirst()).value()).getDescriptionId())}).withStyle(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d < 0.0)) continue;
                tooltip.add((Component)Component.translatable((String)("attribute.modifier.take." + entityAttributeModifier3.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(e *= -1.0), Component.translatable((String)((Attribute)((Holder)pair.getFirst()).value()).getDescriptionId())}).withStyle(ChatFormatting.RED));
            }
        }
        tooltip.add((Component)Component.empty());
        tooltip.add((Component)Component.translatable((String)"tooltip.farm_and_charm.canbeplaced").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
    }

    @NotNull
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity user) {
        return user.eat(level, stack);
    }

    @NotNull
    public InteractionResult place(BlockPlaceContext context) {
        Player player = context.getPlayer();
        if (player != null && player.isShiftKeyDown()) {
            return super.place(context);
        }
        return InteractionResult.PASS;
    }
}

