/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.item.food;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.satisfy.farm_and_charm.core.item.food.EffectFood;
import net.satisfy.farm_and_charm.core.item.food.EffectFoodHelper;
import org.jetbrains.annotations.NotNull;

public class EffectFoodBlockItem
extends BlockItem
implements EffectFood {
    private final int foodStages;

    public EffectFoodBlockItem(Block block, Item.Properties properties, int foodStages) {
        super(block, properties);
        this.foodStages = foodStages;
    }

    @NotNull
    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        Player player;
        if (!world.isClientSide) {
            List<Pair<MobEffectInstance, Float>> effects = EffectFoodHelper.getEffects(stack);
            for (Pair<MobEffectInstance, Float> effect : effects) {
                if (effect.getFirst() == null || !(world.random.nextFloat() < ((Float)effect.getSecond()).floatValue())) continue;
                user.addEffect(new MobEffectInstance((MobEffectInstance)effect.getFirst()));
            }
        }
        int stage = EffectFoodHelper.getStage(stack);
        int slot = -1;
        Inventory inv = null;
        if (user instanceof Player && !(player = (Player)user).isCreative()) {
            inv = player.getInventory();
            slot = inv.findSlotMatchingUnusedItem(stack);
        }
        ItemStack eaten = user.eat(world, stack);
        if (inv != null && stage < this.foodStages) {
            ItemStack next = EffectFoodHelper.setStage(new ItemStack((ItemLike)this), stage + 1);
            if (slot >= 0 && slot < inv.items.size() && inv.getItem(slot).isEmpty()) {
                inv.add(slot, next);
                return eaten;
            }
            int space = inv.getSlotWithRemainingSpace(next);
            if (space >= 0 && space < inv.items.size()) {
                inv.add(space, next);
            }
        }
        return eaten;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        EffectFoodHelper.getTooltip(itemStack, tooltip);
        tooltip.add((Component)Component.empty());
        tooltip.add((Component)Component.translatable((String)"tooltip.farm_and_charm.canbeplaced").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
    }

    @NotNull
    public InteractionResult place(BlockPlaceContext context) {
        Player player = context.getPlayer();
        if (player != null && player.isShiftKeyDown()) {
            return super.place(context);
        }
        return InteractionResult.PASS;
    }
}

