/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.item.food;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.CustomModelData;

public class EffectFoodHelper {
    private static float saturationModifierOf(FoodProperties base) {
        if (base.nutrition() <= 0) {
            return 0.0f;
        }
        return base.saturation() / ((float)base.nutrition() * 2.0f);
    }

    public static void addEffect(ItemStack stack, Pair<MobEffectInstance, Float> effect) {
        FoodProperties base = (FoodProperties)stack.get(DataComponents.FOOD);
        if (base == null) {
            return;
        }
        Holder target = ((MobEffectInstance)effect.getFirst()).getEffect();
        for (FoodProperties.PossibleEffect e : base.effects()) {
            if (e.effect().getEffect() != target) continue;
            return;
        }
        FoodProperties.Builder b = new FoodProperties.Builder().nutrition(base.nutrition()).saturationModifier(EffectFoodHelper.saturationModifierOf(base));
        if (base.canAlwaysEat()) {
            b.alwaysEdible();
        }
        if (base.eatSeconds() == 0.8f) {
            b.fast();
        }
        for (FoodProperties.PossibleEffect e : base.effects()) {
            b.effect(e.effect(), e.probability());
        }
        b.effect((MobEffectInstance)effect.getFirst(), ((Float)effect.getSecond()).floatValue());
        stack.set(DataComponents.FOOD, (Object)b.build());
    }

    private static void rebuildWithout(ItemStack stack) {
        FoodProperties base = (FoodProperties)stack.get(DataComponents.FOOD);
        if (base == null) {
            return;
        }
        FoodProperties.Builder b = new FoodProperties.Builder().nutrition(base.nutrition()).saturationModifier(EffectFoodHelper.saturationModifierOf(base));
        if (base.canAlwaysEat()) {
            b.alwaysEdible();
        }
        if (base.eatSeconds() == 0.8f) {
            b.fast();
        }
        for (FoodProperties.PossibleEffect e : base.effects()) {
            if (e.effect().getEffect() == MobEffects.HUNGER) continue;
            b.effect(e.effect(), e.probability());
        }
        stack.set(DataComponents.FOOD, (Object)b.build());
    }

    private static void removeHungerEffect(ItemStack stack) {
        EffectFoodHelper.rebuildWithout(stack);
    }

    private static void removeRawChickenEffects(ItemStack stack) {
        if (stack.getItem() != Items.CHICKEN) {
            return;
        }
        EffectFoodHelper.removeHungerEffect(stack);
    }

    public static List<Pair<MobEffectInstance, Float>> getEffects(ItemStack stack) {
        EffectFoodHelper.removeHungerEffect(stack);
        EffectFoodHelper.removeRawChickenEffects(stack);
        ArrayList out = Lists.newArrayList();
        if (stack.getItem() instanceof PotionItem) {
            PotionContents pc = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
            for (MobEffectInstance e : pc.customEffects()) {
                out.add(new Pair((Object)e, (Object)Float.valueOf(1.0f)));
            }
            return out;
        }
        FoodProperties base = (FoodProperties)stack.get(DataComponents.FOOD);
        if (base != null) {
            for (FoodProperties.PossibleEffect e : base.effects()) {
                out.add(new Pair((Object)e.effect(), (Object)Float.valueOf(e.probability())));
            }
        }
        return out;
    }

    public static void applyEffects(ItemStack stack) {
        PotionContents pc = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        if (pc.hasEffects()) {
            return;
        }
        FoodProperties base = (FoodProperties)stack.get(DataComponents.FOOD);
        if (base == null) {
            return;
        }
        FoodProperties.Builder b = new FoodProperties.Builder().nutrition(base.nutrition()).saturationModifier(EffectFoodHelper.saturationModifierOf(base));
        if (base.canAlwaysEat()) {
            b.alwaysEdible();
        }
        if (base.eatSeconds() == 0.8f) {
            b.fast();
        }
        for (FoodProperties.PossibleEffect e : base.effects()) {
            b.effect(e.effect(), e.probability());
        }
        stack.set(DataComponents.FOOD, (Object)b.build());
    }

    public static CompoundTag createNbt(short id, Pair<MobEffectInstance, Float> effect) {
        CompoundTag nbtCompound = new CompoundTag();
        nbtCompound.putShort("id", id);
        nbtCompound.putInt("duration", ((MobEffectInstance)effect.getFirst()).getDuration());
        nbtCompound.putInt("amplifier", ((MobEffectInstance)effect.getFirst()).getAmplifier());
        nbtCompound.putFloat("chance", ((Float)effect.getSecond()).floatValue());
        return nbtCompound;
    }

    public static List<Pair<MobEffectInstance, Float>> fromNbt(ListTag list) {
        ArrayList effects = Lists.newArrayList();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag nbtCompound = list.getCompound(i);
            Optional effect = BuiltInRegistries.MOB_EFFECT.getHolder((int)nbtCompound.getShort("id"));
            effect.ifPresent(mobEffectReference -> effects.add(new Pair((Object)new MobEffectInstance((Holder)mobEffectReference, nbtCompound.getInt("duration"), nbtCompound.getInt("amplifier")), (Object)Float.valueOf(nbtCompound.getFloat("chance")))));
        }
        return effects;
    }

    public static ItemStack setStage(ItemStack stack, int stage) {
        stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(stage));
        return stack;
    }

    public static int getStage(ItemStack stack) {
        return ((CustomModelData)stack.getOrDefault(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(0))).value();
    }

    public static void getTooltip(ItemStack stack, List<Component> tooltip) {
        List<Pair<MobEffectInstance, Float>> effects = EffectFoodHelper.getEffects(stack);
        if (effects.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"effect.none").withStyle(ChatFormatting.GRAY));
        } else {
            for (Pair<MobEffectInstance, Float> effectPair : effects) {
                MobEffectInstance statusEffect = (MobEffectInstance)effectPair.getFirst();
                MutableComponent mutableText = Component.translatable((String)statusEffect.getDescriptionId());
                if (statusEffect.getAmplifier() > 0) {
                    mutableText = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{mutableText, Component.translatable((String)("potion.potency." + statusEffect.getAmplifier()))});
                }
                if (((MobEffectInstance)effectPair.getFirst()).getDuration() > 20) {
                    mutableText = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{mutableText, MobEffectUtil.formatDuration((MobEffectInstance)statusEffect, (float)1.0f, (float)1.0f)});
                }
                tooltip.add((Component)mutableText.withStyle(((MobEffect)statusEffect.getEffect().value()).getCategory().getTooltipFormatting()));
            }
        }
    }
}

