/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import net.satisfy.farm_and_charm.platform.PlatformHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CropBlock.class})
public abstract class CropBlockMixin {
    @Shadow
    public abstract BlockState getStateForAge(int var1);

    @Shadow
    public abstract int getAge(BlockState var1);

    @Shadow
    public abstract boolean isMaxAge(BlockState var1);

    @Inject(at={@At(value="HEAD")}, method={"randomTick(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V"})
    public void boostGrowthInRain(BlockState state, ServerLevel level, BlockPos pos, RandomSource random, CallbackInfo ci) {
        if (PlatformHelper.isRainGrowthEffectEnabled() && level.isRainingAt(pos.above()) && !this.isMaxAge(state)) {
            float growthChance = level.isThundering() ? 0.7f : 0.5f;
            growthChance *= PlatformHelper.getRainGrowthMultiplier();
            if (random.nextFloat() < growthChance) {
                level.setBlock(pos, this.getStateForAge(this.getAge(state) + 1), 2);
                for (int i = 0; i < 5; ++i) {
                    double offsetX = random.nextDouble() - 0.5;
                    double offsetY = random.nextDouble() * 0.5;
                    double offsetZ = random.nextDouble() - 0.5;
                    level.sendParticles((ParticleOptions)ParticleTypes.WAX_OFF, (double)pos.getX() + 0.5 + offsetX, (double)pos.getY() + 1.0 + offsetY, (double)pos.getZ() + 0.5 + offsetZ, 1, 0.0, 0.0, 0.0, 0.1);
                }
            }
        }
    }

    @Inject(method={"mayPlaceOn(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void mayPlaceOn(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CallbackInfoReturnable<Boolean> cir) {
        if (blockState.is((Block)ObjectRegistry.FERTILIZED_FARM_BLOCK.get())) {
            cir.setReturnValue((Object)true);
        }
    }
}

