/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.registry;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public final class ArmorMaterialRegistry {
    public static final Holder<ArmorMaterial> CLOTH = ArmorMaterialRegistry.register("cloth", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), m -> {
        m.put(ArmorItem.Type.BOOTS, 1);
        m.put(ArmorItem.Type.LEGGINGS, 1);
        m.put(ArmorItem.Type.CHESTPLATE, 2);
        m.put(ArmorItem.Type.HELMET, 1);
    }), () -> Ingredient.of((TagKey)ItemTags.WOOL), ResourceLocation.fromNamespaceAndPath((String)"farm_and_charm", (String)"armor/default"));
    public static final Holder<ArmorMaterial> JEWELRY = ArmorMaterialRegistry.register("jewelry", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), m -> {
        m.put(ArmorItem.Type.BOOTS, 1);
        m.put(ArmorItem.Type.LEGGINGS, 1);
        m.put(ArmorItem.Type.CHESTPLATE, 1);
        m.put(ArmorItem.Type.HELMET, 1);
    }), () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT}), ResourceLocation.fromNamespaceAndPath((String)"farm_and_charm", (String)"armor/default"));
    private static final Map<String, Holder<ArmorMaterial>> CACHE = new HashMap<String, Holder<ArmorMaterial>>();

    public static Holder<ArmorMaterial> withTextureNoOverlay(Holder<ArmorMaterial> base, ResourceLocation texturePng) {
        return ArmorMaterialRegistry.withLayer(base, ArmorMaterialRegistry.toLayerPrefix(texturePng));
    }

    private static ResourceLocation toLayerPrefix(ResourceLocation png) {
        String p = png.getPath();
        int slash = p.lastIndexOf(47);
        String name = slash >= 0 ? p.substring(slash + 1) : p;
        int dot = name.lastIndexOf(46);
        if (dot >= 0) {
            name = name.substring(0, dot);
        }
        return ResourceLocation.fromNamespaceAndPath((String)png.getNamespace(), (String)name);
    }

    private static Holder<ArmorMaterial> register(String id, EnumMap<ArmorItem.Type, Integer> map, Supplier<Ingredient> repair, ResourceLocation layerPrefix) {
        EnumMap<ArmorItem.Type, Integer> copy = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        for (ArmorItem.Type t : ArmorItem.Type.values()) {
            Integer v = map.get(t);
            if (v == null) {
                v = 0;
            }
            copy.put(t, v);
        }
        List<ArmorMaterial.Layer> layers = List.of(new ArmorMaterial.Layer(layerPrefix, "", true));
        return Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"farm_and_charm", (String)id), (Object)new ArmorMaterial(copy, 15, SoundEvents.ARMOR_EQUIP_LEATHER, repair, layers, 0.0f, 0.0f));
    }

    private static Holder<ArmorMaterial> withLayer(Holder<ArmorMaterial> base, ResourceLocation layerPrefix) {
        String key = String.valueOf(BuiltInRegistries.ARMOR_MATERIAL.getKey((Object)((ArmorMaterial)base.value()))) + "|" + String.valueOf(layerPrefix);
        Holder<ArmorMaterial> cached = CACHE.get(key);
        if (cached != null) {
            return cached;
        }
        EnumMap<ArmorItem.Type, Integer> def = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        for (ArmorItem.Type t : ArmorItem.Type.values()) {
            def.put(t, ((ArmorMaterial)base.value()).getDefense(t));
        }
        List<ArmorMaterial.Layer> layers = List.of(new ArmorMaterial.Layer(layerPrefix, "", true));
        Holder.Reference res = Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"farm_and_charm", (String)("mat_" + layerPrefix.getNamespace() + "_" + layerPrefix.getPath().replace('/', '_'))), (Object)new ArmorMaterial(def, ((ArmorMaterial)base.value()).enchantmentValue(), ((ArmorMaterial)base.value()).equipSound(), ((ArmorMaterial)base.value()).repairIngredient(), layers, ((ArmorMaterial)base.value()).toughness(), ((ArmorMaterial)base.value()).knockbackResistance()));
        CACHE.put(key, (Holder<ArmorMaterial>)res);
        return res;
    }

    private ArmorMaterialRegistry() {
    }
}

