/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.neoforge.core.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Wolf;
import net.satisfy.farm_and_charm.core.entity.BowlAccessor;
import net.satisfy.farm_and_charm.core.entity.ai.DogEatFromBowlGoal;
import net.satisfy.farm_and_charm.core.entity.ai.WhineAtBowlGoal;
import net.satisfy.farm_and_charm.neoforge.core.mixin.MobAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Wolf.class})
public class WolfMixin
implements BowlAccessor.StayNearBowl {
    @Unique
    private boolean fedRecently = false;
    @Unique
    private BlockPos stayCenter = null;
    @Unique
    private boolean wasSittingLastTick = false;

    @Inject(method={"registerGoals()V"}, at={@At(value="TAIL")})
    private void farmAndCharm$addFeedingGoal(CallbackInfo ci) {
        Mob self = (Mob)this;
        ((MobAccessor)self).farmAndCharm$getGoalSelector().addGoal(13, (Goal)new DogEatFromBowlGoal((Wolf)this));
        ((MobAccessor)self).farmAndCharm$getGoalSelector().addGoal(14, (Goal)new WhineAtBowlGoal((Wolf)this));
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void farmAndCharm$handleStayRestriction(CallbackInfo ci) {
        double dist;
        Wolf wolf = (Wolf)this;
        boolean isSittingNow = wolf.isInSittingPose();
        if (!this.wasSittingLastTick && isSittingNow) {
            this.fedRecently = false;
            this.stayCenter = null;
        }
        this.wasSittingLastTick = isSittingNow;
        if (this.fedRecently && this.stayCenter != null && !isSittingNow && (dist = this.stayCenter.distSqr((Vec3i)wolf.blockPosition())) > 256.0) {
            wolf.getNavigation().moveTo((double)this.stayCenter.getX() + 0.5, (double)this.stayCenter.getY(), (double)this.stayCenter.getZ() + 0.5, 1.0);
        }
    }

    @Inject(method={"die(Lnet/minecraft/world/damagesource/DamageSource;)V"}, at={@At(value="HEAD")})
    private void farmAndCharm$clearOnDeath(CallbackInfo ci) {
        this.fedRecently = false;
        this.stayCenter = null;
    }

    @Override
    public void farmAndCharm$setStayCenter(BlockPos pos) {
        this.fedRecently = true;
        this.stayCenter = pos.immutable();
    }

    @Override
    public void farmAndCharm$clearStayRestriction() {
        this.fedRecently = false;
        this.stayCenter = null;
    }

    @Override
    public boolean farmAndCharm$isWithinStayRange(BlockPos pos) {
        return this.fedRecently && this.stayCenter != null && pos.distSqr((Vec3i)this.stayCenter) <= 256.0;
    }

    @Override
    public BlockPos farmAndCharm$getStayCenter() {
        return this.stayCenter != null ? this.stayCenter : ((Wolf)this).blockPosition();
    }

    @Override
    public boolean farmAndCharm$hasStayRestriction() {
        return this.fedRecently;
    }
}

