/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block.entity;

import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_5558;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.satisfy.farm_and_charm.core.block.SiloBlock;
import net.satisfy.farm_and_charm.core.recipe.SiloRecipe;
import net.satisfy.farm_and_charm.core.registry.EntityTypeRegistry;
import net.satisfy.farm_and_charm.core.util.ConnectivityHandler;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import net.satisfy.farm_and_charm.core.util.IMultiBlockEntityContainer;
import net.satisfy.farm_and_charm.core.world.ImplementedInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SiloBlockEntity
extends class_2586
implements IMultiBlockEntityContainer.Inventory,
ImplementedInventory,
class_3908,
class_5558<SiloBlockEntity> {
    private static final int MAX_WIDTH = 3;
    private static final int MAX_HEIGHT = 9;
    public static final int MAX_CAPACITY = 81;
    private static final int DRY_TIME = 200;
    protected class_2338 controller;
    protected boolean updateConnectivity = false;
    protected int width = 1;
    protected int height = 1;
    private class_2371<class_1799> items = class_2371.method_10213((int)162, (Object)class_1799.field_8037);
    private int[] times = new int[81];

    public SiloBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)EntityTypeRegistry.SILO_BLOCK_ENTITY.get(), pos, state);
    }

    public static void dropStack(class_1937 level, double x, double y, double z, class_1799 itemStack, class_2350 direction) {
        double g = class_1299.field_6052.method_17685();
        double h = 1.0 - g;
        double i = g / 2.0;
        double j = Math.floor(x) + level.field_9229.method_43058() * h + i;
        double k = Math.floor(y) + level.field_9229.method_43058() * h;
        double l = Math.floor(z) + level.field_9229.method_43058() * h + i;
        while (!itemStack.method_7960()) {
            class_1542 itemEntity = new class_1542(level, j, k, l, itemStack.method_7971(level.field_9229.method_43048(21) + 10));
            itemEntity.method_18800(level.field_9229.method_43385((double)direction.method_10148() * 0.4, 0.11485000171139836), level.field_9229.method_43385(-0.2, 0.11485000171139836), level.field_9229.method_43385((double)direction.method_10165() * 0.4, 0.11485000171139836));
            level.method_8649((class_1297)itemEntity);
        }
    }

    @Override
    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    @Override
    public boolean isController() {
        return this.controller == null || this.field_11867.equals((Object)this.controller);
    }

    @Override
    public class_2338 getController() {
        return this.isController() ? this.field_11867 : this.controller;
    }

    @Override
    public void setController(class_2338 controller) {
        assert (this.field_11863 != null);
        if (this.field_11863.field_9236 || controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        class_1264.method_5451((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1263)this);
    }

    @Override
    public <T extends class_2586> T getControllerBE() {
        if (this.isController()) {
            SiloBlockEntity result = this;
            return (T)result;
        }
        assert (this.field_11863 != null);
        class_2586 be = this.field_11863.method_8321(this.controller);
        if (be instanceof IMultiBlockEntityContainer) {
            class_2586 result = be;
            return (T)result;
        }
        return null;
    }

    @Override
    public void removeController(boolean keepContents) {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        this.updateConnectivity = true;
        this.controller = null;
        this.width = 1;
        this.height = 1;
        class_2680 state = this.method_11010();
        if (SiloBlock.isSilo(state)) {
            state = (class_2680)state.method_11657((class_2769)SiloBlock.BOTTOM, (Comparable)Boolean.valueOf(true));
            state = (class_2680)state.method_11657((class_2769)SiloBlock.TOP, (Comparable)Boolean.valueOf(true));
            state = (class_2680)state.method_11657(SiloBlock.SHAPE, (Comparable)((Object)SiloBlock.Shape.NONE));
            this.field_11863.method_8652(this.field_11867, state, 23);
        }
    }

    public void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, SiloBlockEntity blockEntity) {
        if (this.field_11863 == null) {
            this.field_11863 = level;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        this.dry();
        this.tryDropFinish(blockState);
    }

    public void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti(this);
    }

    public boolean tryAddItem(class_1799 itemStack) {
        boolean added = false;
        for (int slot = 0; !itemStack.method_7960() && slot < this.getCapacity(); ++slot) {
            if (!this.method_5438(slot).method_7960()) continue;
            this.method_5447(slot, itemStack.method_7971(1));
            added = true;
        }
        return added;
    }

    public class_1799 tryRemoveItem() {
        for (int slot = 81 + this.getCapacity(); slot > 81; --slot) {
            class_1799 stack = this.method_5438(slot);
            if (stack.method_7960()) continue;
            return this.method_5434(slot, stack.method_7947());
        }
        return class_1799.field_8037;
    }

    @Override
    public void notifyMultiUpdated() {
        if (this.field_11863 == null) {
            return;
        }
        class_2680 state = this.method_11010();
        if (SiloBlock.isSilo(state)) {
            state = (class_2680)state.method_11657((class_2769)SiloBlock.BOTTOM, (Comparable)Boolean.valueOf(this.getController().method_10264() == this.method_11016().method_10264()));
            state = (class_2680)state.method_11657((class_2769)SiloBlock.TOP, (Comparable)Boolean.valueOf(this.getController().method_10264() + this.height - 1 == this.method_11016().method_10264()));
            class_2680 controllerState = this.field_11863.method_8320(this.getController());
            if (controllerState.method_28498((class_2769)class_2741.field_12537)) {
                state = (class_2680)state.method_11657((class_2769)SiloBlock.OPEN, (Comparable)((Boolean)controllerState.method_11654((class_2769)class_2741.field_12537)));
            }
            if (controllerState.method_28498((class_2769)class_2741.field_12481)) {
                state = (class_2680)state.method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)controllerState.method_11654((class_2769)class_2741.field_12481)));
            }
            this.field_11863.method_8652(this.field_11867, state, 6);
        }
        if (this.isController()) {
            this.updateShape();
        }
    }

    public void updateShape() {
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    class_2338 pos = this.field_11867.method_10069(xOffset, yOffset, zOffset);
                    assert (this.field_11863 != null);
                    class_2680 blockState = this.field_11863.method_8320(pos);
                    if (!SiloBlock.isSilo(blockState)) continue;
                    SiloBlock.Shape shape = SiloBlock.Shape.NONE;
                    if (this.width == 2) {
                        SiloBlock.Shape shape2 = xOffset == 0 ? (zOffset == 0 ? SiloBlock.Shape.NORTH_WEST : SiloBlock.Shape.SOUTH_WEST) : (shape = zOffset == 0 ? SiloBlock.Shape.NORTH_EAST : SiloBlock.Shape.SOUTH_EAST);
                    }
                    if (this.width == 3) {
                        shape = switch (xOffset) {
                            case 0 -> {
                                if (zOffset == 0) {
                                    yield SiloBlock.Shape.NORTH_WEST;
                                }
                                if (zOffset == 2) {
                                    yield SiloBlock.Shape.SOUTH_WEST;
                                }
                                yield SiloBlock.Shape.WEST;
                            }
                            case 1 -> {
                                if (zOffset == 0) {
                                    yield SiloBlock.Shape.NORTH;
                                }
                                if (zOffset == 2) {
                                    yield SiloBlock.Shape.SOUTH;
                                }
                                yield SiloBlock.Shape.NONE;
                            }
                            case 2 -> {
                                if (zOffset == 0) {
                                    yield SiloBlock.Shape.NORTH_EAST;
                                }
                                if (zOffset == 2) {
                                    yield SiloBlock.Shape.SOUTH_EAST;
                                }
                                yield SiloBlock.Shape.EAST;
                            }
                            default -> SiloBlock.Shape.NONE;
                        };
                    }
                    this.field_11863.method_8501(pos, (class_2680)blockState.method_11657(SiloBlock.SHAPE, (Comparable)((Object)shape)));
                }
            }
        }
    }

    private void dry() {
        for (int fresh = 0; fresh < this.getCapacity(); ++fresh) {
            class_1799 freshStack = this.method_5438(fresh);
            Optional<class_8786<SiloRecipe>> recipe = SiloBlock.getDryItemRecipe(this.field_11863, freshStack);
            if (!recipe.isPresent() || freshStack.method_7960()) continue;
            int dryTime = this.times[fresh];
            if (++dryTime >= 200) {
                for (int finish = 81; finish < 81 + this.getCapacity(); ++finish) {
                    if (!this.method_5438(finish).method_7960()) continue;
                    class_1799 finishStack = this.method_5434(fresh, freshStack.method_7947());
                    class_1799 outputStack = ((SiloRecipe)recipe.get().comp_1933()).method_8110((class_7225.class_7874)this.field_11863.method_30349()).method_46651(finishStack.method_7947());
                    this.method_5447(finish, SiloBlock.isDryItem(this.field_11863, finishStack) ? outputStack : finishStack);
                    dryTime = 0;
                    if (this.field_11863 == null || this.field_11863.field_9236) break;
                    this.field_11863.method_8396(null, this.field_11867, class_3417.field_17608, class_3419.field_15245, 0.7f, 1.0f);
                    break;
                }
            }
            this.times[fresh] = dryTime;
        }
    }

    private void tryDropFinish(class_2680 blockState) {
        if (this.field_11863 == null || !((Boolean)blockState.method_11654((class_2769)SiloBlock.OPEN)).booleanValue()) {
            return;
        }
        for (int finish = 81; finish < 81 + this.getCapacity(); ++finish) {
            class_1799 finishStack = this.method_5438(finish);
            if (finishStack.method_7960()) continue;
            class_2350 direction = (class_2350)blockState.method_11654((class_2769)class_2741.field_12481);
            double x = switch (direction) {
                case class_2350.field_11034 -> this.width;
                case class_2350.field_11039 -> 0.0;
                default -> (double)this.width / 2.0;
            };
            double z = switch (direction) {
                case class_2350.field_11043 -> 0.0;
                case class_2350.field_11035 -> this.width;
                default -> (double)this.width / 2.0;
            };
            SiloBlockEntity.dropStack(this.field_11863, (double)this.field_11867.method_10263() + x, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + z, finishStack, direction);
            return;
        }
    }

    public void open(boolean open) {
        if (!this.isController()) {
            return;
        }
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    class_2338 pos = this.field_11867.method_10069(xOffset, yOffset, zOffset);
                    assert (this.field_11863 != null);
                    class_2680 blockState = this.field_11863.method_8320(pos);
                    if (!SiloBlock.isSilo(blockState)) continue;
                    this.field_11863.method_8501(pos, (class_2680)blockState.method_11657((class_2769)SiloBlock.OPEN, (Comparable)Boolean.valueOf(open)));
                }
            }
        }
    }

    @Override
    public class_2350.class_2351 getMainConnectionAxis() {
        return class_2350.class_2351.field_11052;
    }

    @Override
    public int getMaxLength(class_2350.class_2351 longAxis, int width) {
        return longAxis.method_10179() ? this.getMaxWidth() : 9;
    }

    @Override
    public int getMaxWidth() {
        return 3;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    public int getCapacity() {
        return !this.isController() ? 0 : this.width * this.width * this.height;
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.items;
    }

    @Override
    public boolean hasInventory() {
        return this.isController();
    }

    protected void method_11007(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11007(compoundTag, provider);
        if (this.controller != null) {
            GeneralUtil.putBlockPos(compoundTag, this.controller);
        }
        compoundTag.method_10556("Update", this.updateConnectivity);
        compoundTag.method_10569("Width", this.width);
        compoundTag.method_10569("Height", this.height);
        class_1262.method_5426((class_2487)compoundTag, this.items, (class_7225.class_7874)provider);
        compoundTag.method_10539("Times", this.times);
    }

    protected void method_11014(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11014(compoundTag, provider);
        this.controller = GeneralUtil.readBlockPos(compoundTag);
        this.updateConnectivity = !compoundTag.method_10545("Update") || compoundTag.method_10577("Update");
        this.width = compoundTag.method_10545("Width") ? compoundTag.method_10550("Width") : 1;
        this.height = compoundTag.method_10545("Height") ? compoundTag.method_10550("Height") : 1;
        this.items = class_2371.method_10213((int)162, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)compoundTag, this.items, (class_7225.class_7874)provider);
        this.times = compoundTag.method_10545("Times") ? compoundTag.method_10561("Times") : new int[81];
    }

    @NotNull
    public class_2561 method_5476() {
        return class_2561.method_43473();
    }

    @Nullable
    public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
        return null;
    }
}

