/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.entity;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.satisfy.farm_and_charm.core.entity.DrivableEntity;
import net.satisfy.farm_and_charm.core.registry.SoundEventRegistry;
import net.satisfy.farm_and_charm.core.util.CartWheel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTowableEntity
extends class_1297 {
    public static final String DRIVER = "Driver";
    @Nullable
    public class_1297 driver;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    private double lerpPitch;
    private int soundCooldownTicks = 0;
    final CartWheel leftWheel = new CartWheel(this, -1.5f);
    final CartWheel rightWheel = new CartWheel(this, 1.5f);
    private float health = 10.0f;
    private int wobbleTicks = 0;
    private float wobbleDirection = 0.0f;

    public AbstractTowableEntity(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    public float method_49476() {
        return 1.2f;
    }

    public boolean hasDriver() {
        return this.driver != null;
    }

    @Nullable
    public class_1297 getDriver() {
        return this.driver;
    }

    protected void removeDriver() {
        this.driver = null;
    }

    public boolean canAddDriver() {
        return !this.hasDriver();
    }

    public boolean addDriver(class_1297 entity) {
        if (entity instanceof class_1657) {
            List entities = this.method_37908().method_18467(class_1297.class, entity.method_5829().method_1014(100.0));
            for (class_1297 ent : entities) {
                DrivableEntity drivable;
                if (!(ent instanceof DrivableEntity) || !(drivable = (DrivableEntity)ent).hasDriver() || !drivable.getDriver().equals((Object)entity)) continue;
                return false;
            }
        }
        if (!this.hasDriver() && this.canAddDriver()) {
            this.driver = entity;
            return true;
        }
        return false;
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    public boolean method_30948() {
        return !this.method_31481();
    }

    protected void method_5652(class_2487 compoundTag) {
        if (this.hasDriver()) {
            compoundTag.method_10569(DRIVER, this.getDriver().method_5628());
        }
    }

    protected void method_5749(class_2487 compoundTag) {
        if (compoundTag.method_10545(DRIVER)) {
            this.driver = this.method_37908().method_8469(compoundTag.method_10550(DRIVER));
        }
    }

    @NotNull
    public class_1269 method_5688(class_1657 player, class_1268 interactionHand) {
        if (this.hasDriver()) {
            this.removeDriver();
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14718, class_3419.field_15248, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        boolean added = this.addDriver((class_1297)player);
        if (added) {
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14607, class_3419.field_15248, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public class_243 getRelativeTargetVec(float delta) {
        double z;
        double y;
        double x;
        if (this.driver == null) {
            return class_243.field_1353;
        }
        if (delta == 1.0f) {
            x = this.driver.method_23317() - this.method_23317();
            y = this.driver.method_23318() - this.method_23318();
            z = this.driver.method_23321() - this.method_23321();
        } else {
            x = class_3532.method_16436((double)delta, (double)this.driver.field_6038, (double)this.driver.method_23317()) - class_3532.method_16436((double)delta, (double)this.field_6038, (double)this.method_23317());
            y = class_3532.method_16436((double)delta, (double)this.driver.field_5971, (double)this.driver.method_23318()) - class_3532.method_16436((double)delta, (double)this.field_5971, (double)this.method_23318());
            z = class_3532.method_16436((double)delta, (double)this.driver.field_5989, (double)this.driver.method_23321()) - class_3532.method_16436((double)delta, (double)this.field_5989, (double)this.method_23321());
        }
        float yaw = (float)Math.toRadians(this.driver.method_36454());
        float nx = -class_3532.method_15374((float)yaw);
        float nz = class_3532.method_15362((float)yaw);
        double r = this.getOffsetRadius();
        return new class_243(x + (double)nx * r, -y, z + (double)nz * r);
    }

    public void handleRotation(class_243 target) {
        this.method_36456(AbstractTowableEntity.getYaw(target));
        this.method_36457(AbstractTowableEntity.getPitch(target));
    }

    public static float getYaw(class_243 vec) {
        return class_3532.method_15393((float)((float)Math.toDegrees(-class_3532.method_15349((double)vec.field_1352, (double)vec.field_1350))));
    }

    public static float getPitch(class_243 vec) {
        return class_3532.method_15393((float)((float)Math.toDegrees(class_3532.method_15349((double)vec.field_1351, (double)class_3532.method_15355((float)((float)(vec.field_1352 * vec.field_1352 + vec.field_1350 * vec.field_1350)))))));
    }

    public void pulledTick() {
        if (this.driver == null) {
            return;
        }
        class_243 targetVec = this.getRelativeTargetVec(1.0f);
        this.handleRotation(targetVec);
        while (this.method_36454() - this.field_5982 < -180.0f) {
            this.field_5982 -= 360.0f;
        }
        while (this.method_36454() - this.field_5982 >= 180.0f) {
            this.field_5982 += 360.0f;
        }
        if (this.driver.method_24828()) {
            targetVec = new class_243(targetVec.field_1352, 0.0, targetVec.field_1350);
        }
        double targetVecLength = targetVec.method_1033();
        double r = this.getOffsetRadius();
        double relativeSpacing = this.getRelativeSpacing();
        double diff = targetVecLength - relativeSpacing;
        class_243 move = Math.abs(diff) < r ? this.method_18798() : this.method_18798().method_1019(targetVec.method_1020(targetVec.method_1029().method_1021(relativeSpacing + r * Math.signum(diff))));
        this.method_24830(true);
        this.method_5784(class_1313.field_6308, move);
        if (!this.method_5805()) {
            return;
        }
        this.addStats();
        if (!this.method_37908().field_9236 && (targetVec = this.getRelativeTargetVec(1.0f)).method_1033() > relativeSpacing + 1.0) {
            this.driver = null;
        }
        this.updatePassengers();
    }

    public void updatePassengers() {
        for (class_1297 passenger : this.method_5685()) {
            this.method_24201(passenger);
        }
    }

    private void addStats() {
    }

    void tickLerp() {
        if (this.lerpSteps > 0) {
            double dx = (this.lerpX - this.method_23317()) / (double)this.lerpSteps;
            double dy = (this.lerpY - this.method_23318()) / (double)this.lerpSteps;
            double dz = (this.lerpZ - this.method_23321()) / (double)this.lerpSteps;
            this.method_36456((float)((double)this.method_36454() + class_3532.method_15338((double)(this.lerpYaw - (double)this.method_36454())) / (double)this.lerpSteps));
            this.method_36457((float)((double)this.method_36455() + (this.lerpPitch - (double)this.method_36455()) / (double)this.lerpSteps));
            --this.lerpSteps;
            this.method_24830(true);
            this.method_5784(class_1313.field_6308, new class_243(dx, dy, dz));
            this.method_5710(this.method_36454(), this.method_36455());
        }
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int posRotationIncrements) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.lerpSteps = posRotationIncrements;
    }

    public void method_5773() {
        if (!this.method_5740()) {
            this.method_18799(this.method_18798().method_1031(0.0, -0.08, 0.0));
        }
        super.method_5773();
        this.tickLerp();
        if (this.driver != null) {
            this.pulledTick();
        }
        this.leftWheel.tick();
        this.rightWheel.tick();
        this.method_5784(class_1313.field_6308, this.method_18798());
        double dx = this.method_23317() - this.field_6038;
        double dz = this.method_23321() - this.field_5989;
        double distanceTravelled = Math.sqrt(dx * dx + dz * dz);
        if (distanceTravelled > 0.2 && this.soundCooldownTicks <= 0 && !this.method_37908().method_8608()) {
            this.method_37908().method_8396(null, this.method_24515(), (class_3414)SoundEventRegistry.CART_MOVING.get(), class_3419.field_15245, 0.7f, 1.0f);
            this.soundCooldownTicks = 45;
        }
        if (this.soundCooldownTicks > 0) {
            --this.soundCooldownTicks;
        }
        if (this.wobbleTicks > 0) {
            float wobbleAmount = (float)Math.sin((double)(10 - this.wobbleTicks) * Math.PI / 10.0) * this.wobbleDirection;
            this.method_36456(this.method_36454() + wobbleAmount);
            --this.wobbleTicks;
            if (this.wobbleTicks == 0) {
                this.method_36456(this.method_36454() - this.wobbleDirection);
            }
        }
    }

    public float getWheelRotation() {
        return this.leftWheel.getRotation();
    }

    protected double getRelativeSpacing() {
        return 2.0;
    }

    protected double getOffsetRadius() {
        return 0.0;
    }

    public boolean method_5643(class_1282 source, float damage) {
        if (this.method_31481() || !this.method_5805()) {
            return false;
        }
        if (source.method_5529() instanceof class_1657) {
            this.setHealth(this.getHealth() - damage);
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14808, class_3419.field_15248, 1.0f, 1.0f);
            this.wobbleTicks = 10;
            float f = this.wobbleDirection = this.field_5974.method_43056() ? 5.0f : -5.0f;
            if (this.getHealth() <= 0.0f) {
                this.destroy();
            }
            return true;
        }
        return false;
    }

    public float getHealth() {
        return this.health;
    }

    public void setHealth(float health) {
        this.health = health;
    }

    private void destroy() {
        if (!this.method_37908().field_9236) {
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15215, class_3419.field_15248, 1.0f, 1.0f);
            this.method_5775(this.getDropItem());
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    protected class_1799 getDropItem() {
        return null;
    }
}

