/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.entity;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.satisfy.farm_and_charm.core.entity.DrivableEntity;
import net.satisfy.farm_and_charm.core.registry.SoundEventRegistry;
import net.satisfy.farm_and_charm.core.util.CartWheel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTowableEntity
extends Entity {
    public static final String DRIVER = "Driver";
    @Nullable
    public Entity driver;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    private double lerpPitch;
    private int soundCooldownTicks = 0;
    final CartWheel leftWheel = new CartWheel(this, -1.5f);
    final CartWheel rightWheel = new CartWheel(this, 1.5f);
    private float health = 10.0f;
    private int wobbleTicks = 0;
    private float wobbleDirection = 0.0f;

    public AbstractTowableEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public float maxUpStep() {
        return 1.2f;
    }

    public boolean hasDriver() {
        return this.driver != null;
    }

    @Nullable
    public Entity getDriver() {
        return this.driver;
    }

    protected void removeDriver() {
        this.driver = null;
    }

    public boolean canAddDriver() {
        return !this.hasDriver();
    }

    public boolean addDriver(Entity entity) {
        if (entity instanceof Player) {
            List entities = this.level().getEntitiesOfClass(Entity.class, entity.getBoundingBox().inflate(100.0));
            for (Entity ent : entities) {
                DrivableEntity drivable;
                if (!(ent instanceof DrivableEntity) || !(drivable = (DrivableEntity)ent).hasDriver() || !drivable.getDriver().equals((Object)entity)) continue;
                return false;
            }
        }
        if (!this.hasDriver() && this.canAddDriver()) {
            this.driver = entity;
            return true;
        }
        return false;
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    public boolean canBeCollidedWith() {
        return !this.isRemoved();
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        if (this.hasDriver()) {
            compoundTag.putInt(DRIVER, this.getDriver().getId());
        }
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        if (compoundTag.contains(DRIVER)) {
            this.driver = this.level().getEntity(compoundTag.getInt(DRIVER));
        }
    }

    @NotNull
    public InteractionResult interact(Player player, InteractionHand interactionHand) {
        if (this.hasDriver()) {
            this.removeDriver();
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.WOOD_PLACE, SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        boolean added = this.addDriver((Entity)player);
        if (added) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.WOOD_FALL, SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public Vec3 getRelativeTargetVec(float delta) {
        double z;
        double y;
        double x;
        if (this.driver == null) {
            return Vec3.ZERO;
        }
        if (delta == 1.0f) {
            x = this.driver.getX() - this.getX();
            y = this.driver.getY() - this.getY();
            z = this.driver.getZ() - this.getZ();
        } else {
            x = Mth.lerp((double)delta, (double)this.driver.xOld, (double)this.driver.getX()) - Mth.lerp((double)delta, (double)this.xOld, (double)this.getX());
            y = Mth.lerp((double)delta, (double)this.driver.yOld, (double)this.driver.getY()) - Mth.lerp((double)delta, (double)this.yOld, (double)this.getY());
            z = Mth.lerp((double)delta, (double)this.driver.zOld, (double)this.driver.getZ()) - Mth.lerp((double)delta, (double)this.zOld, (double)this.getZ());
        }
        float yaw = (float)Math.toRadians(this.driver.getYRot());
        float nx = -Mth.sin((float)yaw);
        float nz = Mth.cos((float)yaw);
        double r = this.getOffsetRadius();
        return new Vec3(x + (double)nx * r, -y, z + (double)nz * r);
    }

    public void handleRotation(Vec3 target) {
        this.setYRot(AbstractTowableEntity.getYaw(target));
        this.setXRot(AbstractTowableEntity.getPitch(target));
    }

    public static float getYaw(Vec3 vec) {
        return Mth.wrapDegrees((float)((float)Math.toDegrees(-Mth.atan2((double)vec.x, (double)vec.z))));
    }

    public static float getPitch(Vec3 vec) {
        return Mth.wrapDegrees((float)((float)Math.toDegrees(Mth.atan2((double)vec.y, (double)Mth.sqrt((float)((float)(vec.x * vec.x + vec.z * vec.z)))))));
    }

    public void pulledTick() {
        if (this.driver == null) {
            return;
        }
        Vec3 targetVec = this.getRelativeTargetVec(1.0f);
        this.handleRotation(targetVec);
        while (this.getYRot() - this.yRotO < -180.0f) {
            this.yRotO -= 360.0f;
        }
        while (this.getYRot() - this.yRotO >= 180.0f) {
            this.yRotO += 360.0f;
        }
        if (this.driver.onGround()) {
            targetVec = new Vec3(targetVec.x, 0.0, targetVec.z);
        }
        double targetVecLength = targetVec.length();
        double r = this.getOffsetRadius();
        double relativeSpacing = this.getRelativeSpacing();
        double diff = targetVecLength - relativeSpacing;
        Vec3 move = Math.abs(diff) < r ? this.getDeltaMovement() : this.getDeltaMovement().add(targetVec.subtract(targetVec.normalize().scale(relativeSpacing + r * Math.signum(diff))));
        this.setOnGround(true);
        this.move(MoverType.SELF, move);
        if (!this.isAlive()) {
            return;
        }
        this.addStats();
        if (!this.level().isClientSide && (targetVec = this.getRelativeTargetVec(1.0f)).length() > relativeSpacing + 1.0) {
            this.driver = null;
        }
        this.updatePassengers();
    }

    public void updatePassengers() {
        for (Entity passenger : this.getPassengers()) {
            this.positionRider(passenger);
        }
    }

    private void addStats() {
    }

    void tickLerp() {
        if (this.lerpSteps > 0) {
            double dx = (this.lerpX - this.getX()) / (double)this.lerpSteps;
            double dy = (this.lerpY - this.getY()) / (double)this.lerpSteps;
            double dz = (this.lerpZ - this.getZ()) / (double)this.lerpSteps;
            this.setYRot((float)((double)this.getYRot() + Mth.wrapDegrees((double)(this.lerpYaw - (double)this.getYRot())) / (double)this.lerpSteps));
            this.setXRot((float)((double)this.getXRot() + (this.lerpPitch - (double)this.getXRot()) / (double)this.lerpSteps));
            --this.lerpSteps;
            this.setOnGround(true);
            this.move(MoverType.SELF, new Vec3(dx, dy, dz));
            this.setRot(this.getYRot(), this.getXRot());
        }
    }

    public void lerpTo(double x, double y, double z, float yaw, float pitch, int posRotationIncrements) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.lerpSteps = posRotationIncrements;
    }

    public void tick() {
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.08, 0.0));
        }
        super.tick();
        this.tickLerp();
        if (this.driver != null) {
            this.pulledTick();
        }
        this.leftWheel.tick();
        this.rightWheel.tick();
        this.move(MoverType.SELF, this.getDeltaMovement());
        double dx = this.getX() - this.xOld;
        double dz = this.getZ() - this.zOld;
        double distanceTravelled = Math.sqrt(dx * dx + dz * dz);
        if (distanceTravelled > 0.2 && this.soundCooldownTicks <= 0 && !this.level().isClientSide()) {
            this.level().playSound(null, this.blockPosition(), (SoundEvent)SoundEventRegistry.CART_MOVING.get(), SoundSource.BLOCKS, 0.7f, 1.0f);
            this.soundCooldownTicks = 45;
        }
        if (this.soundCooldownTicks > 0) {
            --this.soundCooldownTicks;
        }
        if (this.wobbleTicks > 0) {
            float wobbleAmount = (float)Math.sin((double)(10 - this.wobbleTicks) * Math.PI / 10.0) * this.wobbleDirection;
            this.setYRot(this.getYRot() + wobbleAmount);
            --this.wobbleTicks;
            if (this.wobbleTicks == 0) {
                this.setYRot(this.getYRot() - this.wobbleDirection);
            }
        }
    }

    public float getWheelRotation() {
        return this.leftWheel.getRotation();
    }

    protected double getRelativeSpacing() {
        return 2.0;
    }

    protected double getOffsetRadius() {
        return 0.0;
    }

    public boolean hurt(DamageSource source, float damage) {
        if (this.isRemoved() || !this.isAlive()) {
            return false;
        }
        if (source.getEntity() instanceof Player) {
            this.setHealth(this.getHealth() - damage);
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.WOOD_HIT, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.wobbleTicks = 10;
            float f = this.wobbleDirection = this.random.nextBoolean() ? 5.0f : -5.0f;
            if (this.getHealth() <= 0.0f) {
                this.destroy();
            }
            return true;
        }
        return false;
    }

    public float getHealth() {
        return this.health;
    }

    public void setHealth(float health) {
        this.health = health;
    }

    private void destroy() {
        if (!this.level().isClientSide) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.WOOD_BREAK, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.spawnAtLocation(this.getDropItem());
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    protected ItemStack getDropItem() {
        return null;
    }
}

