package net.satisfy.farm_and_charm.core.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.farm_and_charm.core.registry.EntityTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class RopeKnotBlockEntity extends BlockEntity {
    private BlockState held;

    public RopeKnotBlockEntity(BlockPos pos, BlockState state) {
        super(EntityTypeRegistry.ROPE_KNOT_BLOCK_ENTITY.get(), pos, state);
    }

    public BlockState getHeldBlock() {
        return held;
    }

    public void setHeldBlock(BlockState state) {
        this.held = state;
        setChanged();
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (held != null) {
            BlockState.CODEC.encodeStart(provider.createSerializationContext(NbtOps.INSTANCE), held)
                    .result()
                    .ifPresent(n -> tag.put("Held", n));
        }
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("Held")) {
            BlockState.CODEC.parse(provider.createSerializationContext(NbtOps.INSTANCE), tag.get("Held"))
                    .result()
                    .ifPresent(blockState -> this.held = blockState);
        }
    }

    @Override
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public @NotNull CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return saveWithoutMetadata(provider);
    }
}
