/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block.entity;

import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.class_1262;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2621;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3956;
import net.minecraft.class_5558;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.satisfy.farm_and_charm.core.block.MincerBlock;
import net.satisfy.farm_and_charm.core.recipe.MincerRecipe;
import net.satisfy.farm_and_charm.core.registry.EntityTypeRegistry;
import net.satisfy.farm_and_charm.core.registry.RecipeTypeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MincerBlockEntity
extends class_2621
implements class_1278,
class_5558<MincerBlockEntity> {
    public final int SLOT_COUNT = 2;
    public final int INPUT_SLOT = 0;
    public final int OUTPUT_SLOT = 1;
    private class_2371<class_1799> stacks = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
    private float crankAngle;
    private float crankAnglePrev;
    private float crankSpeed;
    private float crankTargetSpeed;

    public MincerBlockEntity(class_2338 position, class_2680 state) {
        super((class_2591)EntityTypeRegistry.MINCER_BLOCK_ENTITY.get(), position, state);
    }

    public static void spawnItem(class_1937 world, class_1799 stack, int speed, class_2350 side, class_2374 pos) {
        double d = pos.method_10216();
        double e = pos.method_10214();
        double f = pos.method_10215();
        e = side.method_10166() == class_2350.class_2351.field_11052 ? (e -= 0.125) : (e -= 0.15625);
        class_1542 itemEntity = new class_1542(world, d, e, f, stack);
        double g = world.field_9229.method_43058() * 0.1 + 0.2;
        itemEntity.method_18800(world.field_9229.method_43385((double)side.method_10148() * g, 0.0172275 * (double)speed), world.field_9229.method_43385(0.2, 0.0172275 * (double)speed), world.field_9229.method_43385((double)side.method_10165() * g, 0.0172275 * (double)speed));
        world.method_8649((class_1297)itemEntity);
    }

    public void method_11014(class_2487 compound, class_7225.class_7874 provider) {
        super.method_11014(compound, provider);
        if (!this.method_54871(compound)) {
            this.stacks = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        }
        class_1262.method_5429((class_2487)compound, this.stacks, (class_7225.class_7874)provider);
        this.crankAngle = compound.method_10583("CrankAngle");
        this.crankSpeed = compound.method_10583("CrankSpeed");
        this.crankTargetSpeed = compound.method_10583("CrankTargetSpeed");
    }

    public void method_11007(class_2487 compound, class_7225.class_7874 provider) {
        super.method_11007(compound, provider);
        if (!this.method_54872(compound)) {
            class_1262.method_5426((class_2487)compound, this.stacks, (class_7225.class_7874)provider);
        }
        compound.method_10548("CrankAngle", this.crankAngle);
        compound.method_10548("CrankSpeed", this.crankSpeed);
        compound.method_10548("CrankTargetSpeed", this.crankTargetSpeed);
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887(class_7225.class_7874 provider) {
        return this.method_38244(provider);
    }

    public boolean method_5442() {
        for (class_1799 itemstack : this.stacks) {
            if (itemstack.method_7960()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public class_2561 method_17823() {
        return class_2561.method_43470((String)"mincer");
    }

    @NotNull
    public class_1703 method_5465(int id, class_1661 inventory) {
        return class_1707.method_19248((int)id, (class_1661)inventory);
    }

    private void dropItemsInOutputSlot(class_1937 level, class_2338 pos, class_2680 state, MincerBlockEntity mincer) {
        class_2350 direction = ((class_2350)state.method_11654((class_2769)MincerBlock.FACING)).method_10170();
        if (!level.method_8608() && !((class_1799)this.stacks.get(1)).method_7960()) {
            class_1799 droppedStack = new class_1799((class_1935)((class_1799)mincer.stacks.get(1)).method_7909());
            droppedStack.method_7939(((class_1799)mincer.stacks.get(1)).method_7947());
            this.stacks.set(1, (Object)class_1799.field_8037);
            class_243 vec3d = class_243.method_24953((class_2382)pos);
            class_243 vec3d2 = vec3d.method_43206(direction, 0.7);
            ((class_3218)level).method_14199((class_2394)class_2398.field_11228, vec3d2.method_10216(), vec3d2.method_10214(), vec3d2.method_10215(), 3, 0.2, 0.1, 0.0, 0.1);
            MincerBlockEntity.spawnItem(level, droppedStack, 6, direction, (class_2374)vec3d2);
        }
    }

    public int method_5444() {
        return 64;
    }

    public int method_5439() {
        return this.stacks.size();
    }

    public boolean method_5437(int index, class_1799 stack) {
        class_1799 inputSlotItemStack = (class_1799)this.stacks.get(0);
        return index == 0 && inputSlotItemStack.method_7960() || stack.method_31574(inputSlotItemStack.method_7909()) && inputSlotItemStack.method_7947() < inputSlotItemStack.method_7914();
    }

    @NotNull
    public class_1799 method_5438(int index) {
        return (class_1799)this.method_11282().get(index);
    }

    @NotNull
    public class_2371<class_1799> method_11282() {
        return this.stacks;
    }

    protected void method_11281(class_2371<class_1799> stacks) {
        this.stacks = stacks;
    }

    public int @NotNull [] method_5494(class_2350 side) {
        return IntStream.range(0, this.method_5439()).toArray();
    }

    public boolean method_5492(int index, class_1799 stack, @Nullable class_2350 direction) {
        return this.method_5437(index, stack);
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        return direction == class_2350.field_11036 && this.method_5437(index, stack);
    }

    private MincerRecipe getRecipe(List<class_8786<MincerRecipe>> recipes, class_2371<class_1799> inventory) {
        for (class_8786<MincerRecipe> recipeHolder : recipes) {
            MincerRecipe recipe = (MincerRecipe)recipeHolder.comp_1933();
            boolean ok = true;
            for (class_1856 ingredient : recipe.method_8117()) {
                boolean found = false;
                for (class_1799 slotItem : inventory) {
                    if (!ingredient.method_8093(slotItem)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            return recipe;
        }
        return null;
    }

    public float getInterpolatedCrankAngle(float partial) {
        float a0 = this.crankAnglePrev;
        float a1 = this.crankAngle;
        float da = a1 - a0;
        float tau = (float)Math.PI * 2;
        if ((double)da > Math.PI) {
            da -= tau;
        }
        if ((double)da < -Math.PI) {
            da += tau;
        }
        return a0 + da * partial;
    }

    public void addCrankImpulse(float v) {
        this.crankTargetSpeed = Math.min(0.5f, this.crankTargetSpeed + v);
    }

    public void tick(class_1937 level, class_2338 pos, class_2680 state, MincerBlockEntity mincer) {
        this.crankAnglePrev = this.crankAngle;
        this.dropItemsInOutputSlot(level, pos, state, mincer);
        int crank = (Integer)state.method_11654((class_2769)MincerBlock.CRANK);
        this.crankTargetSpeed = crank > 0 ? 0.5f : 0.0f;
        float k = 0.22f;
        this.crankSpeed += (this.crankTargetSpeed - this.crankSpeed) * k;
        if (crank == 0) {
            this.crankSpeed *= 0.96f;
        }
        this.crankAngle += this.crankSpeed;
        float tau = (float)Math.PI * 2;
        if (this.crankAngle > tau) {
            this.crankAngle -= tau;
        }
        if (this.crankAngle < 0.0f) {
            this.crankAngle += tau;
        }
        if (!level.field_9236 && state.method_26204() instanceof MincerBlock) {
            int cranked = (Integer)state.method_11654((class_2769)MincerBlock.CRANKED);
            if (crank > 0) {
                if (cranked < 20) {
                    ++cranked;
                }
                --crank;
                if (cranked >= 20) {
                    cranked = 0;
                    class_1863 rm = level.method_8433();
                    List recipes = rm.method_30027((class_3956)RecipeTypeRegistry.MINCER_RECIPE_TYPE.get());
                    Optional<MincerRecipe> recipe = Optional.ofNullable(this.getRecipe(recipes, this.stacks));
                    if (recipe.isPresent()) {
                        class_1799 inputStack = (class_1799)this.stacks.get(0);
                        String t = recipe.get().getRecipeType();
                        int d = 5;
                        switch (t) {
                            case "MEAT": {
                                d = 1;
                                break;
                            }
                            case "WOOD": {
                                d = 2;
                                break;
                            }
                            case "STONE": {
                                d = 3;
                                break;
                            }
                            case "METAL": {
                                d = 4;
                            }
                        }
                        class_238 area = new class_238(pos).method_1014(4.0);
                        List playersNearby = level.method_8390(class_3222.class, area, class_1309::method_5805);
                        if (!playersNearby.isEmpty()) {
                            for (class_1657 p : playersNearby) {
                                if (p == null || !p.method_6079().method_31574(inputStack.method_7909())) continue;
                                --d;
                            }
                        }
                        if (d > 0) {
                            inputStack.method_7934(1);
                            inputStack = inputStack.method_7960() ? class_1799.field_8037 : inputStack;
                            mincer.method_5447(0, inputStack);
                            mincer.method_5447(1, recipe.get().method_8110((class_7225.class_7874)level.method_30349()));
                            level.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)MincerBlock.CRANK, (Comparable)Integer.valueOf(crank))).method_11657((class_2769)MincerBlock.CRANKED, (Comparable)Integer.valueOf(cranked)), 3);
                            if (level.method_8510() % 5L == 0L) {
                                this.method_5431();
                            }
                            return;
                        }
                    }
                }
                level.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)MincerBlock.CRANK, (Comparable)Integer.valueOf(crank))).method_11657((class_2769)MincerBlock.CRANKED, (Comparable)Integer.valueOf(cranked)), 3);
            } else if (cranked > 0 && cranked < 20) {
                level.method_8652(pos, (class_2680)state.method_11657((class_2769)MincerBlock.CRANKED, (Comparable)Integer.valueOf(0)), 3);
            }
            if (level.method_8510() % 5L == 0L) {
                this.method_5431();
            }
        }
    }
}

