/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.item.food;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_4174;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9280;
import net.minecraft.class_9285;
import net.minecraft.class_9334;

public class EffectFoodHelper {
    private static float saturationModifierOf(class_4174 base) {
        if (base.comp_2491() <= 0) {
            return 0.0f;
        }
        return base.comp_2492() / ((float)base.comp_2491() * 2.0f);
    }

    public static void addEffect(class_1799 stack, Pair<class_1293, Float> effect) {
        class_4174 base = (class_4174)stack.method_57824(class_9334.field_50075);
        if (base == null) {
            return;
        }
        class_6880 target = ((class_1293)effect.getFirst()).method_5579();
        for (class_4174.class_9423 e : base.comp_2495()) {
            if (e.comp_2496().method_5579() != target) continue;
            return;
        }
        class_4174.class_4175 b = new class_4174.class_4175().method_19238(base.comp_2491()).method_19237(EffectFoodHelper.saturationModifierOf(base));
        if (base.comp_2493()) {
            b.method_19240();
        }
        if (base.comp_2494() == 0.8f) {
            b.method_19241();
        }
        for (class_4174.class_9423 e : base.comp_2495()) {
            b.method_19239(e.comp_2496(), e.comp_2497());
        }
        b.method_19239((class_1293)effect.getFirst(), ((Float)effect.getSecond()).floatValue());
        stack.method_57379(class_9334.field_50075, (Object)b.method_19242());
    }

    private static void rebuildWithout(class_1799 stack) {
        class_4174 base = (class_4174)stack.method_57824(class_9334.field_50075);
        if (base == null) {
            return;
        }
        class_4174.class_4175 b = new class_4174.class_4175().method_19238(base.comp_2491()).method_19237(EffectFoodHelper.saturationModifierOf(base));
        if (base.comp_2493()) {
            b.method_19240();
        }
        if (base.comp_2494() == 0.8f) {
            b.method_19241();
        }
        for (class_4174.class_9423 e : base.comp_2495()) {
            if (e.comp_2496().method_5579() == class_1294.field_5903) continue;
            b.method_19239(e.comp_2496(), e.comp_2497());
        }
        stack.method_57379(class_9334.field_50075, (Object)b.method_19242());
    }

    private static void removeHungerEffect(class_1799 stack) {
        EffectFoodHelper.rebuildWithout(stack);
    }

    private static void removeRawChickenEffects(class_1799 stack) {
        if (stack.method_7909() != class_1802.field_8726) {
            return;
        }
        EffectFoodHelper.removeHungerEffect(stack);
    }

    public static List<Pair<class_1293, Float>> getEffects(class_1799 stack) {
        EffectFoodHelper.removeHungerEffect(stack);
        EffectFoodHelper.removeRawChickenEffects(stack);
        ArrayList out = Lists.newArrayList();
        if (stack.method_7909() instanceof class_1812) {
            class_1844 pc = (class_1844)stack.method_57825(class_9334.field_49651, (Object)class_1844.field_49274);
            pc.comp_2378().ifPresent(p -> {
                for (class_1293 e : ((class_1842)p.comp_349()).method_8049()) {
                    out.add(new Pair((Object)e, (Object)Float.valueOf(1.0f)));
                }
            });
            for (class_1293 e : pc.comp_2380()) {
                out.add(new Pair((Object)e, (Object)Float.valueOf(1.0f)));
            }
            return out;
        }
        class_4174 base = (class_4174)stack.method_57824(class_9334.field_50075);
        if (base != null) {
            for (class_4174.class_9423 e : base.comp_2495()) {
                out.add(new Pair((Object)e.comp_2496(), (Object)Float.valueOf(e.comp_2497())));
            }
        }
        return out;
    }

    public static void applyEffects(class_1799 stack) {
        class_1844 pc = (class_1844)stack.method_57825(class_9334.field_49651, (Object)class_1844.field_49274);
        if (pc.method_57405()) {
            return;
        }
        class_4174 base = (class_4174)stack.method_57824(class_9334.field_50075);
        if (base == null) {
            return;
        }
        class_4174.class_4175 b = new class_4174.class_4175().method_19238(base.comp_2491()).method_19237(EffectFoodHelper.saturationModifierOf(base));
        if (base.comp_2493()) {
            b.method_19240();
        }
        if (base.comp_2494() == 0.8f) {
            b.method_19241();
        }
        for (class_4174.class_9423 e : base.comp_2495()) {
            b.method_19239(e.comp_2496(), e.comp_2497());
        }
        stack.method_57379(class_9334.field_50075, (Object)b.method_19242());
    }

    public static class_2487 createNbt(short id, Pair<class_1293, Float> effect) {
        class_2487 nbtCompound = new class_2487();
        nbtCompound.method_10575("id", id);
        nbtCompound.method_10569("duration", ((class_1293)effect.getFirst()).method_5584());
        nbtCompound.method_10569("amplifier", ((class_1293)effect.getFirst()).method_5578());
        nbtCompound.method_10548("chance", ((Float)effect.getSecond()).floatValue());
        return nbtCompound;
    }

    public static List<Pair<class_1293, Float>> fromNbt(class_2499 list) {
        ArrayList effects = Lists.newArrayList();
        for (int i = 0; i < list.size(); ++i) {
            class_2487 nbtCompound = list.method_10602(i);
            Optional effect = class_7923.field_41174.method_40265((int)nbtCompound.method_10568("id"));
            effect.ifPresent(mobEffectReference -> effects.add(new Pair((Object)new class_1293((class_6880)mobEffectReference, nbtCompound.method_10550("duration"), nbtCompound.method_10550("amplifier")), (Object)Float.valueOf(nbtCompound.method_10583("chance")))));
        }
        return effects;
    }

    public static class_1799 setStage(class_1799 stack, int stage) {
        stack.method_57379(class_9334.field_49637, (Object)new class_9280(stage));
        return stack;
    }

    public static int getStage(class_1799 stack) {
        return ((class_9280)stack.method_57825(class_9334.field_49637, (Object)new class_9280(0))).comp_2382();
    }

    public static void getTooltip(class_1799 stack, class_1792.class_9635 tooltipContext, List<class_2561> tooltip) {
        ArrayList effects = stack.method_57826(class_9334.field_50075) ? Objects.requireNonNull((class_4174)stack.method_57824(class_9334.field_50075)).comp_2495() : Lists.newArrayList();
        ArrayList attrs = Lists.newArrayList();
        if (effects.isEmpty()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"effect.none").method_27692(class_124.field_1080));
            return;
        }
        for (class_4174.class_9423 pe : effects) {
            class_5250 name = class_2561.method_43471((String)pe.comp_2496().method_5586());
            class_1291 eff = (class_1291)pe.comp_2496().method_5579().comp_349();
            eff.method_55650(pe.comp_2496().method_5578(), (h, base) -> {
                class_1322 m = new class_1322(base.comp_2447(), base.comp_2449() * (double)(pe.comp_2496().method_5578() + 1), base.comp_2450());
                attrs.add(new Pair(h, (Object)m));
            });
            if (pe.comp_2496().method_5584() > 20) {
                name = class_2561.method_43469((String)"potion.withDuration", (Object[])new Object[]{name, class_1292.method_5577((class_1293)pe.comp_2496(), (float)pe.comp_2497(), (float)tooltipContext.method_59531())});
            }
            tooltip.add((class_2561)name.method_27692(eff.method_18792().method_18793()));
        }
        if (!attrs.isEmpty()) {
            tooltip.add((class_2561)class_2561.method_43473());
            tooltip.add((class_2561)class_2561.method_43471((String)"potion.whenDrank").method_27692(class_124.field_1064));
            for (Pair pair : attrs) {
                double shown;
                class_1322 m = (class_1322)pair.getSecond();
                double amt = m.comp_2449();
                double d = shown = m.comp_2450() == class_1322.class_1323.field_6330 || m.comp_2450() == class_1322.class_1323.field_6331 ? amt * 100.0 : amt;
                if (amt > 0.0) {
                    tooltip.add((class_2561)class_2561.method_43469((String)("attribute.modifier.plus." + m.comp_2450().method_56082()), (Object[])new Object[]{class_9285.field_49329.format(shown), class_2561.method_43471((String)((class_1320)((class_6880)pair.getFirst()).comp_349()).method_26830())}).method_27692(class_124.field_1078));
                    continue;
                }
                if (!(amt < 0.0)) continue;
                tooltip.add((class_2561)class_2561.method_43469((String)("attribute.modifier.take." + m.comp_2450().method_56082()), (Object[])new Object[]{class_9285.field_49329.format(-shown), class_2561.method_43471((String)((class_1320)((class_6880)pair.getFirst()).comp_349()).method_26830())}).method_27692(class_124.field_1061));
            }
        }
    }

    public static Map<class_6880<class_1291>, class_1293> bestEffects(Iterable<Pair<class_1293, Float>> effects) {
        HashMap<class_6880<class_1291>, class_1293> best = new HashMap<class_6880<class_1291>, class_1293>();
        for (Pair<class_1293, Float> p : effects) {
            class_1293 cur = (class_1293)p.getFirst();
            class_6880 key = cur.method_5579();
            class_1293 prev = (class_1293)best.get(key);
            if (prev != null && cur.method_5578() <= prev.method_5578() && (cur.method_5578() != prev.method_5578() || cur.method_5584() <= prev.method_5584())) continue;
            best.put((class_6880<class_1291>)key, cur);
        }
        return best;
    }

    public static List<class_1293> collectMergedSortedEffects(Iterable<class_1799> stacks) {
        ArrayList<Pair<class_1293, Float>> collected = new ArrayList<Pair<class_1293, Float>>();
        for (class_1799 in : stacks) {
            if (in.method_7960()) continue;
            collected.addAll(EffectFoodHelper.getEffects(in));
        }
        Map<class_6880<class_1291>, class_1293> best = EffectFoodHelper.bestEffects(collected);
        ArrayList<class_1293> sorted = new ArrayList<class_1293>(best.values());
        sorted.sort(Comparator.comparingInt(a -> class_7923.field_41174.method_10206((Object)((class_1291)a.method_5579().comp_349()))));
        return sorted;
    }

    public static List<class_1293> collectMergedSortedEffects(class_1263 container, int from, int to) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        for (int i = from; i <= to; ++i) {
            stacks.add(container.method_5438(i));
        }
        return EffectFoodHelper.collectMergedSortedEffects(stacks);
    }
}

