/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_52;
import net.minecraft.class_8567;

public class SaturationTracker {
    private static final int[] FEEDING_THRESHOLDS = new int[]{5, 10, 15, 20};
    private int level = 0;
    private int foodCounter = 0;
    private long lastFedTick = -1L;
    private int decayDelay = -1;
    private long nextDecayGameTime = -1L;

    private void scheduleNextDecay(class_1429 animal, long now) {
        this.decayDelay = 2400 + animal.method_59922().method_43048(2400);
        this.nextDecayGameTime = now + (long)this.decayDelay;
        this.lastFedTick = now;
    }

    public void tryFeed(class_1429 animal, class_1657 player, class_1268 hand) {
        if (animal.method_37908().field_9236) {
            return;
        }
        if (this.level >= 4) {
            return;
        }
        class_1799 stack = player.method_5998(hand);
        if (!animal.method_6481(stack) || animal.method_6109()) {
            return;
        }
        if (!player.method_31549().field_7477) {
            stack.method_7934(1);
        }
        ++this.foodCounter;
        long now = animal.method_37908().method_8510();
        this.scheduleNextDecay(animal, now);
        if (this.level < 4 && this.foodCounter >= FEEDING_THRESHOLDS[this.level]) {
            ++this.level;
            this.foodCounter = 0;
        }
    }

    public void tick(class_1429 animal) {
        if (animal.method_37908().field_9236) {
            return;
        }
        long now = animal.method_37908().method_8510();
        if (((long)animal.method_5628() + now) % 20L != 0L) {
            return;
        }
        if (this.nextDecayGameTime == -1L) {
            return;
        }
        if (now >= this.nextDecayGameTime) {
            if (this.foodCounter > 0) {
                --this.foodCounter;
            } else if (this.level > 0) {
                --this.level;
                this.foodCounter = FEEDING_THRESHOLDS[Math.max(0, this.level - 1)] - 1;
            }
            this.scheduleNextDecay(animal, now);
        }
    }

    public void dropExtraLoot(class_1429 animal, class_1282 source) {
        class_1657 p;
        int bonusRolls;
        if (source == null) {
            return;
        }
        class_1937 class_19372 = animal.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        if (!serverLevel.method_8450().method_8355(class_1928.field_19391)) {
            return;
        }
        switch (this.level) {
            case 1: {
                int n = 1;
                break;
            }
            case 2: {
                int n = 1 + animal.method_59922().method_43048(2);
                break;
            }
            case 3: {
                int n = 2 + animal.method_59922().method_43048(2);
                break;
            }
            case 4: {
                int n = 3;
                break;
            }
            default: {
                int n = bonusRolls = 0;
            }
        }
        if (bonusRolls == 0) {
            return;
        }
        class_1297 attacker = source.method_5529();
        class_8567 params = new class_8567.class_8568(serverLevel).method_51874(class_181.field_1226, (Object)animal).method_51874(class_181.field_24424, (Object)animal.method_19538()).method_51874(class_181.field_1231, (Object)source).method_51877(class_181.field_1230, (Object)attacker).method_51877(class_181.field_1233, attacker instanceof class_1657 ? (p = (class_1657)attacker) : null).method_51875(class_173.field_1173);
        class_52 table = serverLevel.method_8503().method_58576().method_58295(animal.method_5989());
        for (int i = 0; i < bonusRolls; ++i) {
            ObjectArrayList loot = table.method_51878(params);
            for (class_1799 stack : loot) {
                serverLevel.method_8649((class_1297)new class_1542((class_1937)serverLevel, animal.method_23317(), animal.method_23318(), animal.method_23321(), stack));
            }
        }
    }

    public int level() {
        return this.level;
    }

    public int foodCounter() {
        return this.foodCounter;
    }

    public void feedDirectly(class_1429 animal, int amount) {
        if (this.level >= 4) {
            return;
        }
        this.foodCounter += amount;
        long now = animal.method_37908().method_8510();
        this.scheduleNextDecay(animal, now);
        while (this.level < 4 && this.foodCounter >= FEEDING_THRESHOLDS[this.level]) {
            this.foodCounter -= FEEDING_THRESHOLDS[this.level];
            ++this.level;
        }
    }

    public int getDecayDelay() {
        return this.decayDelay;
    }

    public void setDecayDelay(int delay) {
        this.decayDelay = delay;
        if (this.lastFedTick >= 0L && delay >= 0) {
            this.nextDecayGameTime = this.lastFedTick + (long)delay;
        }
    }

    public long getLastFedTick() {
        return this.lastFedTick;
    }

    public void setLastFedTick(long tick) {
        this.lastFedTick = tick;
        if (this.decayDelay >= 0) {
            this.nextDecayGameTime = tick + (long)this.decayDelay;
        }
    }

    public void setLevel(int level) {
        this.level = Math.max(0, Math.min(4, level));
        if (this.level == 4) {
            this.foodCounter = 0;
        }
    }

    public void setFoodCounter(int count) {
        this.foodCounter = Math.max(0, count);
        if (this.level >= 4) {
            this.foodCounter = 0;
        }
    }

    public void clientSync(int syncedLevel, int syncedFoodCounter) {
        this.level = Math.max(0, Math.min(4, syncedLevel));
        this.foodCounter = Math.max(0, syncedFoodCounter);
        if (this.level == 4) {
            this.foodCounter = 0;
        }
    }

    public static interface SaturatedAnimal {
        public SaturationTracker farm_and_charm$getSaturationTracker();

        public void farm_and_charm$setSaturationTracker(SaturationTracker var1);
    }
}

