package net.satisfy.farm_and_charm.core.network.packet;

import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.satisfy.farm_and_charm.core.block.entity.TextEditableBlockEntity;
import net.satisfy.farm_and_charm.core.network.PacketHandler;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;

public record SetTextPacket(BlockPos pos, List<String> texts) implements CustomPacketPayload {

    public static final CustomPacketPayload.Type<SetTextPacket> TYPE =
            new Type<>(PacketHandler.SET_SIGN_TEXT);

    public static final StreamCodec<RegistryFriendlyByteBuf, SetTextPacket> STREAM_CODEC =
            StreamCodec.of(SetTextPacket::toNetwork, SetTextPacket::fromNetwork);


    public static void toNetwork(RegistryFriendlyByteBuf buf, SetTextPacket msg) {
        buf.writeBlockPos(msg.pos);
        buf.writeInt(msg.texts.size());
        for (String text : msg.texts) {
            buf.writeUtf(text);
        }
    }

    public static SetTextPacket fromNetwork(RegistryFriendlyByteBuf buf) {
        BlockPos pos = buf.readBlockPos();
        int size = buf.readInt();
        List<String> texts = new ArrayList<>();
        for (int i = 0; i < size; i++) {
            texts.add(buf.readUtf(50));
        }
        return new SetTextPacket(pos, texts);
    }

    public static void handle(SetTextPacket msg, ServerPlayer player) {
        Level level = player.level();
        if (level.isLoaded(msg.pos)) {
            BlockEntity entity = level.getBlockEntity(msg.pos);
            if (entity instanceof TextEditableBlockEntity editable) {
                int maxLines = editable.getTextLineCount();
                for (int i = 0; i < Math.min(msg.texts.size(), maxLines); i++) {
                    editable.setText(i, Component.literal(msg.texts.get(i)));
                }
            }
        }
    }

    @Override
    public @NotNull Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}